/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.MedicamentCoding;
import ch.elexis.core.findings.util.fhir.transformer.PrescriptionEntryTypeFactory;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.utils.CoreUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class MedicationStatementPrescriptionTransformer
implements IFhirTransformer<MedicationStatement, IPrescription> {
    public static final String EXTENSION_PRESCRIPTION_ENTRYTYPE_URL = "www.elexis.info/extensions/prescription/entrytype";
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IContextService contextService;
    @Reference
    private ICodeElementService codeElementService;
    private PrescriptionEntryTypeFactory entryTypeFactory = new PrescriptionEntryTypeFactory();

    @Override
    public Optional<MedicationStatement> getFhirObject(IPrescription localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        String remark;
        String disposalComment;
        LocalDateTime dateUntil;
        Coding coding;
        MedicationStatement fhirObject = new MedicationStatement();
        FhirUtil.setVersionedIdPartLastUpdatedMeta(MedicationStatement.class, (DomainResource)fhirObject, (Identifiable)localObject);
        MedicationStatement.MedicationStatementStatus statusEnum = MedicationStatement.MedicationStatementStatus.ACTIVE;
        if (localObject.getDateTo() != null && localObject.getDateTo().isBefore(LocalDateTime.now())) {
            statusEnum = MedicationStatement.MedicationStatementStatus.COMPLETED;
        }
        fhirObject.addIdentifier(this.getElexisObjectIdentifier((Identifiable)localObject));
        fhirObject.setSubject(FhirUtil.getReference((Identifiable)localObject.getPatient()));
        if (localObject.getPrescriptor() != null && localObject.getPrescriptor().isMandator()) {
            IMandator mandator = (IMandator)CoreModelServiceHolder.get().load(localObject.getPrescriptor().getId(), IMandator.class).get();
            fhirObject.setInformationSource(FhirUtil.getReference((Identifiable)mandator));
        }
        StringBuilder textBuilder = new StringBuilder();
        CodeableConcept medication = new CodeableConcept();
        String gtin = this.getArticleGtin(localObject);
        String atc = this.getArticleAtc(localObject);
        String articleLabel = this.getArticleLabel(localObject);
        if (gtin != null) {
            coding = medication.addCoding();
            coding.setSystem(MedicamentCoding.GTIN.getOid());
            coding.setCode(gtin);
            coding.setDisplay(articleLabel);
        }
        if (atc != null) {
            coding = medication.addCoding();
            coding.setSystem(MedicamentCoding.ATC.getOid());
            coding.setCode(atc);
        }
        medication.setText(articleLabel);
        textBuilder.append(articleLabel);
        fhirObject.setMedication((Type)medication);
        Period effectivePeriod = new Period();
        LocalDateTime dateFrom = localObject.getDateFrom();
        if (dateFrom != null) {
            Date time = Date.from(dateFrom.atZone(ZoneId.systemDefault()).toInstant());
            effectivePeriod.setStart(time);
        }
        if ((dateUntil = localObject.getDateTo()) != null) {
            Date time = Date.from(dateUntil.atZone(ZoneId.systemDefault()).toInstant());
            effectivePeriod.setEnd(time);
            String reasonText = localObject.getStopReason();
            if (reasonText != null && !reasonText.isEmpty()) {
                Annotation note = fhirObject.addNote();
                note.setText("Stop: " + reasonText);
                statusEnum = MedicationStatement.MedicationStatementStatus.STOPPED;
            }
        }
        fhirObject.setEffective((Type)effectivePeriod);
        String dose = localObject.getDosageInstruction();
        Dosage dosage = null;
        if (dose != null && !dose.isEmpty()) {
            textBuilder.append(", ").append(dose);
            if (dosage == null) {
                dosage = fhirObject.addDosage();
            }
            dosage.setText(dose);
        }
        if ((disposalComment = localObject.getDisposalComment()) != null && !disposalComment.isEmpty()) {
            textBuilder.append(", ").append(disposalComment);
            if (dosage == null) {
                dosage = fhirObject.addDosage();
            }
            CodeableConcept additional = dosage.addAdditionalInstruction();
            additional.setText(disposalComment);
        }
        if ((remark = localObject.getRemark()) != null && !remark.isEmpty()) {
            textBuilder.append(", ").append(remark);
            Annotation annotation = new Annotation();
            annotation.setText(remark);
            fhirObject.addNote(annotation);
        }
        fhirObject.setStatus(statusEnum);
        Narrative narrative = new Narrative();
        narrative.setStatus(Narrative.NarrativeStatus.GENERATED);
        ModelUtil.setNarrativeFromString(narrative, textBuilder.toString());
        fhirObject.setText(narrative);
        Extension elexisEntryType = new Extension();
        elexisEntryType.setUrl(EXTENSION_PRESCRIPTION_ENTRYTYPE_URL);
        EntryType entryType = localObject.getEntryType();
        elexisEntryType.setValue((Type)new Enumeration((EnumFactory)this.entryTypeFactory, (Enum)entryType));
        fhirObject.addExtension(elexisEntryType);
        return Optional.of(fhirObject);
    }

    @Override
    public Optional<IPrescription> getLocalObject(MedicationStatement fhirObject) {
        String id = fhirObject.getIdElement().getIdPart();
        if (id != null && !id.isEmpty()) {
            return this.modelService.load(id, IPrescription.class);
        }
        return Optional.empty();
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return MedicationStatement.class.equals(fhirClazz) && IPrescription.class.equals(localClazz);
    }

    @Override
    public Optional<IPrescription> updateLocalObject(MedicationStatement fhirObject, IPrescription localObject) {
        Optional localFhirObject = this.getFhirObject(localObject);
        if (!fhirObject.equalsDeep((Base)localFhirObject.get())) {
            if (this.isStopUpdate(fhirObject)) {
                Date dateTo = ((Period)fhirObject.getEffective()).getEnd();
                localObject.setDateTo(dateTo.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                localObject.setStopReason("Gestoppt");
                this.modelService.save((Identifiable)localObject);
                return Optional.of(localObject);
            }
            localObject.setDateTo(LocalDateTime.now());
            localObject.setStopReason("Ge\u00e4ndert durch FHIR Server");
            this.modelService.save((Identifiable)localObject);
            return this.createLocalObject(fhirObject);
        }
        return Optional.empty();
    }

    private boolean isStopUpdate(MedicationStatement fhirObject) {
        if (fhirObject.getStatus() == MedicationStatement.MedicationStatementStatus.STOPPED && fhirObject.hasEffective() && fhirObject.getEffective() instanceof Period) {
            Period period = (Period)fhirObject.getEffective();
            return period.hasEnd();
        }
        return false;
    }

    private String getArticleGtin(IPrescription localObject) {
        IArticle localArticle = localObject.getArticle();
        if (localArticle != null) {
            return localArticle.getGtin();
        }
        return null;
    }

    private String getArticleAtc(IPrescription localObject) {
        IArticle localArticle = localObject.getArticle();
        if (localArticle != null) {
            return localArticle.getAtcCode();
        }
        return null;
    }

    private String getArticleLabel(IPrescription localObject) {
        IArticle localArticle = localObject.getArticle();
        if (localArticle != null) {
            return localArticle.getLabel();
        }
        return "Unknown article";
    }

    @Override
    public Optional<IPrescription> createLocalObject(MedicationStatement fhirObject) {
        Optional item = Optional.empty();
        Optional<String> gtin = this.getMedicationStatementGtin(fhirObject);
        if (gtin.isPresent()) {
            item = this.codeElementService.findArticleByGtin(gtin.get());
            if (item.isEmpty() && CoreUtil.isTestMode()) {
                IQuery query = this.modelService.getQuery(IArticle.class);
                query.and((EStructuralFeature)ModelPackage.Literals.IARTICLE__GTIN, IQuery.COMPARATOR.EQUALS, (Object)gtin.get());
                item = query.executeSingleResult();
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).error("MedicationStatement ohne GTIN");
        }
        Optional patient = this.modelService.load((String)FhirUtil.getId(fhirObject.getSubject()).orElse(null), IPatient.class);
        Optional mandator = this.modelService.load((String)FhirUtil.getId(fhirObject.getInformationSource()).orElse(null), IMandator.class);
        if (item.isPresent() && patient.isPresent() && mandator.isPresent()) {
            IPrescription localObject = (IPrescription)new IPrescriptionBuilder(this.modelService, this.contextService, (IArticle)item.get(), (IPatient)patient.get(), this.getMedicationStatementDosage(fhirObject)).build();
            Optional<LocalDateTime> startDateTime = this.getMedicationStatementStartDateTime(fhirObject);
            startDateTime.ifPresent(arg_0 -> ((IPrescription)localObject).setDateFrom(arg_0));
            Optional<LocalDateTime> endDateTime = this.getMedicationStatementEndDateTime(fhirObject);
            endDateTime.ifPresent(arg_0 -> ((IPrescription)localObject).setDateTo(arg_0));
            localObject.setDisposalComment(this.getMedicationStatementAdditionalInstructions(fhirObject));
            localObject.setRemark(this.getMedicationStatementRemark(fhirObject));
            Optional<EntryType> prescriptionType = this.getMedicationStatementPrescriptionType(fhirObject);
            prescriptionType.ifPresent(arg_0 -> ((IPrescription)localObject).setEntryType(arg_0));
            this.modelService.save((Identifiable)localObject);
            return Optional.of(localObject);
        }
        if (!item.isPresent()) {
            StringJoiner medicationCodes = new StringJoiner(",");
            Type medication = fhirObject.getMedication();
            if (medication instanceof CodeableConcept) {
                List codings = ((CodeableConcept)medication).getCoding();
                for (Coding coding : codings) {
                    medicationCodes.add(coding.getSystem() + "|" + coding.getCode());
                }
            }
            LoggerFactory.getLogger(this.getClass()).error("MedicationStatement mit unbekanntem Medikament [" + medicationCodes.toString() + "]");
        }
        if (!patient.isPresent()) {
            LoggerFactory.getLogger(this.getClass()).error("MedicationStatement mit unbekanntem Patienten [" + (String)FhirUtil.getId(fhirObject.getSubject()).orElse(null) + "]");
        }
        if (!mandator.isPresent()) {
            LoggerFactory.getLogger(this.getClass()).error("MedicationStatement mit unbekanntem Mandator [" + (String)FhirUtil.getId(fhirObject.getInformationSource()).orElse(null) + "]");
        }
        return Optional.empty();
    }

    private Optional<EntryType> getMedicationStatementPrescriptionType(MedicationStatement fhirObject) {
        List extensionsEntryType = fhirObject.getExtensionsByUrl(EXTENSION_PRESCRIPTION_ENTRYTYPE_URL);
        for (Extension extension : extensionsEntryType) {
            try {
                EntryType entryType = EntryType.valueOf((String)((String)((CodeType)extension.getValue()).getValue()));
                return Optional.of(entryType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private Optional<LocalDateTime> getMedicationStatementEndDateTime(MedicationStatement fhirObject) {
        Period period;
        if (fhirObject.hasEffective() && fhirObject.getEffective() instanceof Period && (period = (Period)fhirObject.getEffective()).hasEnd()) {
            Date endDate = period.getEnd();
            return Optional.of(LocalDateTime.ofInstant(endDate.toInstant(), ZoneId.systemDefault()));
        }
        return Optional.empty();
    }

    private Optional<LocalDateTime> getMedicationStatementStartDateTime(MedicationStatement fhirObject) {
        Period period;
        if (fhirObject.hasEffective() && fhirObject.getEffective() instanceof Period && (period = (Period)fhirObject.getEffective()).hasStart()) {
            Date startDate = period.getStart();
            return Optional.of(LocalDateTime.ofInstant(startDate.toInstant(), ZoneId.systemDefault()));
        }
        return Optional.empty();
    }

    private String getMedicationStatementRemark(MedicationStatement fhirObject) {
        List notes = fhirObject.getNote();
        StringBuilder sb = new StringBuilder();
        for (Annotation annotation : notes) {
            String text = annotation.getText();
            if (text == null) continue;
            if (sb.length() == 0) {
                sb.append(text);
                continue;
            }
            sb.append(", ").append(text);
        }
        return sb.toString();
    }

    private String getMedicationStatementAdditionalInstructions(MedicationStatement fhirObject) {
        List instructions = fhirObject.getDosage();
        StringBuilder sb = new StringBuilder();
        for (Dosage dosage : instructions) {
            List additionals = dosage.getAdditionalInstruction();
            for (CodeableConcept codeableConcept : additionals) {
                String text = codeableConcept.getText();
                if (text == null) continue;
                if (sb.length() == 0) {
                    sb.append(text);
                    continue;
                }
                sb.append(", ").append(text);
            }
        }
        return sb.toString();
    }

    private Optional<String> getMedicationStatementGtin(MedicationStatement fhirObject) {
        Type medication = fhirObject.getMedication();
        if (medication instanceof CodeableConcept) {
            List codings = ((CodeableConcept)medication).getCoding();
            for (Coding coding : codings) {
                String codeSystem = coding.getSystem();
                if (!MedicamentCoding.GTIN.getUrl().equals(codeSystem) && !MedicamentCoding.GTIN.getOid().equals(codeSystem)) continue;
                return Optional.of(coding.getCode());
            }
        }
        return Optional.empty();
    }

    private String getMedicationStatementDosage(MedicationStatement fhirObject) {
        List instructions = fhirObject.getDosage();
        StringBuilder sb = new StringBuilder();
        double morn = 0.0;
        double noon = 0.0;
        double aft = 0.0;
        double eve = 0.0;
        for (Dosage dosage : instructions) {
            String text = dosage.getText();
            if (text != null) {
                if (sb.length() == 0) {
                    sb.append(text);
                    continue;
                }
                sb.append(", ").append(text);
                continue;
            }
            if (!dosage.hasTiming() || !dosage.getTiming().hasRepeat() || !dosage.hasDoseAndRate()) continue;
            List doseAndRate = dosage.getDoseAndRate();
            for (Dosage.DosageDoseAndRateComponent doseRate : doseAndRate) {
                double amount = 0.0;
                if (doseRate.hasRateQuantity()) {
                    amount = doseRate.getRateQuantity().getValue().doubleValue();
                }
                if (doseRate.hasDoseQuantity()) {
                    amount = doseRate.getDoseQuantity().getValue().doubleValue();
                }
                if (this.isDosageAt(Timing.EventTiming.MORN, dosage)) {
                    morn = amount;
                    continue;
                }
                if (this.isDosageAt(Timing.EventTiming.NOON, dosage)) {
                    noon = amount;
                    continue;
                }
                if (this.isDosageAt(Timing.EventTiming.AFT, dosage)) {
                    aft = amount;
                    continue;
                }
                if (!this.isDosageAt(Timing.EventTiming.EVE, dosage)) continue;
                eve = amount;
            }
        }
        if (morn > 0.0 || noon > 0.0 || aft > 0.0 || eve > 0.0) {
            StringJoiner sj = new StringJoiner("-");
            sj.add(this.getDoubleString(morn)).add(this.getDoubleString(noon)).add(this.getDoubleString(aft)).add(this.getDoubleString(eve));
            if (sb.length() == 0) {
                sb.append(sj.toString());
            } else {
                sb.append(", ").append(sj.toString());
            }
        }
        return sb.toString();
    }

    private String getDoubleString(Double value) {
        if (value % 1.0 == 0.0) {
            return Integer.toString(value.intValue());
        }
        return Double.toString(value);
    }

    private boolean isDosageAt(Timing.EventTiming eventTiming, Dosage dosage) {
        Timing.TimingRepeatComponent repeat = dosage.getTiming().getRepeat();
        if (repeat != null) {
            for (Enumeration when : repeat.getWhen()) {
                if (when.getValue() != eventTiming) continue;
                return true;
            }
        }
        return false;
    }
}

