/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.model.Identifiable;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class FhirTransformerCache<T> {
    private Cache<String, T> fhirObjectCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public Optional<T> get(Identifiable localObject, SummaryEnum summaryEnum, Set<Include> includes, Callable<T> callable) {
        try {
            Object ret = this.fhirObjectCache.get((Object)this.getCacheKey(localObject, summaryEnum, includes), callable);
            if (ret != null) {
                return Optional.of(ret);
            }
        }
        catch (ExecutionException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error transform to FHIR [" + String.valueOf(localObject) + "]", (Throwable)e);
        }
        return Optional.empty();
    }

    private String getCacheKey(Identifiable localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        StringJoiner sj = new StringJoiner("|");
        sj.add(localObject.getId());
        if (localObject.getLastupdate() != null) {
            sj.add(Long.toString(localObject.getLastupdate()));
        }
        if (summaryEnum != null) {
            sj.add(summaryEnum.name());
        }
        if (includes != null) {
            sj.add(includes.stream().map(i -> i.getValue()).collect(Collectors.joining(",")));
        }
        return sj.toString();
    }

    public void invalidate(Identifiable localObject) {
        this.fhirObjectCache.asMap().keySet().forEach(k -> {
            if (k.startsWith(localObject.getId() + "|")) {
                this.fhirObjectCache.invalidate(k);
            }
        });
    }
}

