/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.fhir.model.adapter;

import ch.elexis.core.fhir.model.impl.FhirPatient;
import ch.elexis.core.fhir.model.impl.FhirPractitionerContact;
import ch.elexis.core.fhir.model.impl.FhirReminder;
import ch.elexis.core.fhir.model.impl.FhirUserGroup;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.Identifiable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Task;
import org.slf4j.LoggerFactory;

public class ModelAdapterFactory {
    private Map<Class<? extends BaseResource>, Class<?>> fhirAdapterClassMap = Map.of(Task.class, FhirReminder.class, Patient.class, FhirPatient.class, Practitioner.class, FhirPractitionerContact.class, CareTeam.class, FhirUserGroup.class);
    private Map<Class<? extends Identifiable>, Class<? extends BaseResource>> modelFhirClassMap = Map.of(IReminder.class, Task.class, IPatient.class, Patient.class, IMandator.class, Practitioner.class, IUserGroup.class, CareTeam.class);

    public Identifiable createAdapter(BaseResource resource) {
        if (resource != null) {
            Class<?> adapterClass = this.fhirAdapterClassMap.get(resource.getClass());
            if (adapterClass != null) {
                try {
                    Constructor<?> constructor = adapterClass.getDeclaredConstructor(resource.getClass());
                    return (Identifiable)constructor.newInstance(resource);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Exception creating adapter for [" + String.valueOf(resource) + "]", (Throwable)e);
                }
            } else {
                throw new IllegalArgumentException("No adapter class for resource [" + String.valueOf(resource) + "]");
            }
        }
        return null;
    }

    public Class<? extends BaseResource> getFhirType(Class<? extends Identifiable> modelType) {
        if (modelType.equals(IContact.class) || modelType.equals(IMandator.class)) {
            return Practitioner.class;
        }
        return this.modelFhirClassMap.get(modelType);
    }
}

