/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.ICodeElement;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.types.Gender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;

public class Person
extends Kontakt {
    public static final String TITLE = "Titel";
    public static final String FLD_TITLE_SUFFIX = "TitelSuffix";
    public static final String MOBILE = "Natel";
    public static final String SEX = "Geschlecht";
    public static final String BIRTHDATE = "Geburtsdatum";
    public static final String FIRSTNAME = "Vorname";
    public static final String NAME = "Name";
    public static final String MALE = "m";
    public static final String FEMALE = "w";

    static {
        Person.addMapping("KONTAKT", "Name=Bezeichnung1", "Vorname=Bezeichnung2", "Zusatz \t\t=Bezeichnung3", "Geburtsdatum=\tS:D:Geburtsdatum", SEX, "Natel=NatelNr", "istPerson", TITLE, FLD_TITLE_SUFFIX);
    }

    public String getName() {
        return Person.checkNull(this.get(NAME));
    }

    public String getVorname() {
        return Person.checkNull(this.get(FIRSTNAME));
    }

    public String getGeburtsdatum() {
        return Person.checkNull(this.get(BIRTHDATE));
    }

    public String getGeschlecht() {
        return Person.checkNull(this.get(SEX));
    }

    public Gender getGender() {
        return Gender.fromValue((String)this.getGeschlecht().toUpperCase());
    }

    public String getNatel() {
        return this.get(MOBILE);
    }

    @Override
    public boolean isValid() {
        return super.isValid();
    }

    public static Person load(String id) {
        Person ret = new Person(id);
        return ret;
    }

    protected Person(String id) {
        super(id);
    }

    public Person() {
    }

    public Person(String Name, String Vorname, String Geburtsdatum, String s) {
        TimeTool dateOfBirth = new TimeTool(Geburtsdatum);
        String[] fields = new String[]{NAME, FIRSTNAME, BIRTHDATE, SEX};
        String[] values = new String[]{Name, Vorname, dateOfBirth.toString(9), s};
        this.create(null, fields, values);
    }

    public Person(String name, String vorname, TimeTool gebDat, String s) throws PersonDataException {
        name = name.trim();
        vorname = vorname.trim();
        if (StringTool.isNothing((Object)name)) {
            throw new PersonDataException(PersonDataException.CAUSE.LASTNAME, Messages.GlobalMessage_valueNotSet);
        }
        if (!name.matches("[\\p{L}'\\s-]+")) {
            throw new PersonDataException(PersonDataException.CAUSE.LASTNAME, Messages.GlobalMessage_noNumericValue);
        }
        if (!StringTool.isNothing((Object)vorname) && !vorname.matches("[\\p{L}'\\s-]+")) {
            throw new PersonDataException(PersonDataException.CAUSE.FIRSTNAME, Messages.GlobalMessage_noNumericValue);
        }
        String dat = "";
        if (gebDat != null) {
            TimeTool now = new TimeTool();
            int myYear = now.get(1);
            int oYear = gebDat.get(1);
            if (oYear > myYear || oYear < myYear - 120) {
                throw new PersonDataException(PersonDataException.CAUSE.BIRTHDATE);
            }
            dat = gebDat.toString(9);
        }
        if (!s.equalsIgnoreCase(MALE) && !s.equalsIgnoreCase(FEMALE)) {
            throw new PersonDataException(PersonDataException.CAUSE.SEX);
        }
        this.create(null);
        String[] fields = new String[]{NAME, FIRSTNAME, BIRTHDATE, SEX};
        String[] vals = new String[]{name, vorname, dat, s};
        this.set(fields, vals);
    }

    @Override
    public String getLabel(boolean shortLabel) {
        StringBuilder sb = new StringBuilder();
        if (shortLabel) {
            sb.append(this.getVorname()).append(" ").append(this.getName());
            return sb.toString();
        }
        return this.getPersonalia();
    }

    public String getInitials(int num) {
        StringBuilder ret = new StringBuilder();
        String name = this.getName();
        String vorname = this.getVorname();
        String sex = this.getGeschlecht();
        String geb = this.getGeburtsdatum();
        if (geb.length() > 7) {
            geb = geb.substring(6);
        }
        ret.append(name.length() > num - 1 ? name.substring(0, num) : name).append(".");
        ret.append(vorname.length() > num - 1 ? vorname.substring(0, num) : vorname).append(".(").append(sex).append("), ").append(geb);
        return ret.toString();
    }

    public String getPersonalia() {
        StringBuffer ret = new StringBuffer(200);
        String[] fields = new String[]{NAME, FIRSTNAME, BIRTHDATE, SEX, TITLE};
        String[] vals = new String[fields.length];
        this.get(fields, vals);
        ret.append(vals[0]);
        if (!StringTool.isNothing((Object)vals[1])) {
            ret.append(" ").append(vals[1]);
        }
        if (StringTool.isNothing((Object)vals[3])) {
            ret.append(" ");
        } else {
            String shortVal = vals[3];
            String localiced = shortVal.contentEquals(FEMALE) ? Messages.Patient_female_short : Messages.Patient_male_short;
            ret.append(" (").append(localiced).append("), ");
        }
        if (!StringTool.isNothing((Object)vals[2])) {
            ret.append(new TimeTool(vals[2]).toString(4));
        }
        if (!StringTool.isNothing((Object)vals[4])) {
            ret.append(", ").append(vals[4]);
        }
        return ret.toString();
    }

    @Override
    protected String getConstraint() {
        return "istPerson" + "=" + JdbcLink.wrap((String)"1");
    }

    @Override
    protected void setConstraint() {
        this.set("istPerson", "1");
    }

    public void countItem(ICodeElement ice) {
        if (ice instanceof PersistentObject) {
            this.statForItem((PersistentObject)((Object)ice));
        }
    }

    public static class PersonDataException
    extends Exception {
        static final String[] causes = new String[]{"Name", "Vorname", "Geburtsdatum", "Geschlecht (m oder w)"};
        public CAUSE cause;

        PersonDataException(CAUSE cause) {
            super("'" + causes[cause.ordinal()] + "'");
            this.cause = cause;
        }

        PersonDataException(CAUSE cause, String additional) {
            super("'" + causes[cause.ordinal()] + "'\n\n" + additional);
            this.cause = cause;
        }

        static enum CAUSE {
            LASTNAME,
            FIRSTNAME,
            BIRTHDATE,
            SEX;

        }
    }
}

