/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.IOrder;
import ch.elexis.core.data.interfaces.IOrderEntry;
import ch.elexis.core.data.interfaces.IStock;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.Anwender;
import ch.elexis.data.Artikel;
import ch.elexis.data.BestellungEntry;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Stock;
import ch.rgw.tools.TimeTool;
import java.util.Comparator;
import java.util.List;

public class Bestellung
extends PersistentObject
implements IOrder {
    public static final String TABLENAME = "BESTELLUNGEN";
    public static final String FLD_DATE = "DATUM";
    public static final String FLD_JOINT_BESTELLUNGEN_ENTRIES = "BESTELLUNGEN_ENTRIES";

    static {
        Bestellung.addMapping(TABLENAME, "BESTELLUNGEN_ENTRIES=LIST:BESTELLUNG:BESTELLUNG_ENTRY");
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public static Bestellung load(String id) {
        return new Bestellung(id);
    }

    protected Bestellung() {
    }

    protected Bestellung(String id) {
        super(id);
    }

    public Bestellung(String name, Anwender an) {
        TimeTool t = new TimeTool();
        this.create(name + ":" + t.toString(13) + ":" + an.getId());
    }

    @Override
    public String getLabel() {
        String[] i = this.getId().split(":");
        TimeTool t = new TimeTool(i[1]);
        return i[0] + ": " + t.toString(0);
    }

    @Override
    public IOrderEntry addEntry(Object article, IStock stock, Object provider, int num) {
        return this.addBestellungEntry((Artikel)article, (Stock)stock, (Kontakt)provider, num);
    }

    public BestellungEntry addBestellungEntry(Artikel article, Stock stock, Kontakt provider, int num) {
        BestellungEntry i;
        Kontakt defProvider;
        String providerId;
        if (provider == null && (providerId = ConfigServiceHolder.getGlobal((String)"inventory/defaultArticleProvider", null)) != null && (defProvider = Kontakt.load(providerId)).exists()) {
            provider = defProvider;
        }
        if ((i = this.findBestellungEntry(stock, article)) != null) {
            int count = i.getCount();
            count += num;
            if (count <= 0) {
                i.removeFromDatabase();
            } else {
                i.setCount(count);
            }
        } else if (num > 0) {
            i = new BestellungEntry(this, article, stock, provider, num);
        }
        return i;
    }

    @Nullable
    public BestellungEntry findBestellungEntry(@Nullable Stock stock, Artikel article) {
        List result;
        Query qbe = new Query(BestellungEntry.class);
        qbe.add("BESTELLUNG", "=", this.getId());
        qbe.add("ARTICLE_ID", "=", article.getId());
        qbe.add("ARTICLE_TYPE", "=", article.getClass().getName());
        if (stock != null) {
            qbe.add("STOCK", "=", stock.getId());
        }
        if (!(result = qbe.execute()).isEmpty()) {
            return (BestellungEntry)result.get(0);
        }
        return null;
    }

    public List<BestellungEntry> getEntries() {
        List<BestellungEntry> execute = new Query(BestellungEntry.class, "BESTELLUNG", this.getId()).execute();
        return execute;
    }

    public static void markAsOrdered(List<BestellungEntry> list) {
        for (BestellungEntry item : list) {
            item.setState(1);
        }
    }

    public void removeEntry(BestellungEntry entry) {
        entry.removeFromDatabase();
    }

    public boolean isDone() {
        List<BestellungEntry> entries = this.getEntries();
        for (BestellungEntry bestellungEntry : entries) {
            if (bestellungEntry.getState() == 3) continue;
            return false;
        }
        return true;
    }

    public TimeTool getTime() {
        TimeTool ret = new TimeTool();
        try {
            String[] i = this.getId().split(":");
            ret.set(i[1]);
        }
        catch (Exception e) {
            ret.set("1.1.1970");
        }
        return ret;
    }

    public ch.elexis.core.model.IOrder toIOrder() {
        return (ch.elexis.core.model.IOrder)CoreModelServiceHolder.get().load(this.getId(), ch.elexis.core.model.IOrder.class).orElseThrow(() -> new IllegalStateException("Could not convert order [" + this.getId() + "]"));
    }

    public static class BestellungDateComparator
    implements Comparator<Bestellung> {
        private TimeTool t1 = new TimeTool();
        private TimeTool t2 = new TimeTool();

        @Override
        public int compare(Bestellung b1, Bestellung b2) {
            this.setTimeTool(b1, this.t1);
            this.setTimeTool(b2, this.t2);
            if (this.t1.after((Object)this.t2)) {
                return -1;
            }
            if (this.t2.after((Object)this.t1)) {
                return 1;
            }
            return 0;
        }

        private void setTimeTool(Bestellung bestellung, TimeTool timeTool) {
            try {
                String[] i = bestellung.getId().split(":");
                timeTool.set(i[1]);
            }
            catch (Exception e) {
                timeTool.set("1.1.1970");
            }
        }
    }

    public static enum ListenTyp {
        PHARMACODE,
        NAME,
        VOLL;

    }
}

