/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.service;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.data.Konsultation;
import java.util.HashMap;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class CodeElementServiceHolder {
    private static HashMap<Object, Object> emptyMap = new HashMap();
    private static ICodeElementService elementService;

    @Reference(unbind="-")
    public void setCodeElementService(ICodeElementService elementService) {
        CodeElementServiceHolder.elementService = elementService;
    }

    public static ICodeElementService get() {
        return elementService;
    }

    public static HashMap<Object, Object> createContext() {
        Optional coverage;
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Optional consultation = ContextServiceHolder.get().getRootContext().getTyped(IEncounter.class);
        if (consultation.isPresent()) {
            ret.put(ICodeElementService.ContextKeys.CONSULTATION, consultation.get());
        }
        if ((coverage = ContextServiceHolder.get().getRootContext().getTyped(ICoverage.class)).isPresent()) {
            ret.put(ICodeElementService.ContextKeys.COVERAGE, coverage.get());
        }
        return ret;
    }

    public static HashMap<Object, Object> createContext(Konsultation consultation) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        if (consultation != null) {
            IEncounter encounter = NoPoUtil.loadAsIdentifiable(consultation, IEncounter.class).get();
            ret.put(ICodeElementService.ContextKeys.CONSULTATION, encounter);
            ret.put(ICodeElementService.ContextKeys.COVERAGE, encounter.getCoverage());
        }
        return ret;
    }

    public static HashMap<Object, Object> emtpyContext() {
        return emptyMap;
    }
}

