/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Eigenleistung;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.JdbcLinkException;
import ch.rgw.tools.TimeTool;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class Test_VkPreise
extends AbstractPersistentObjectTest {
    @Test
    public void testVKMultiplikator() throws SQLException {
        Eigenleistung leistung = new Eigenleistung("TD999", "Leistung.xy999", "99", "10");
        TimeTool now = new TimeTool(System.currentTimeMillis());
        leistung.setVKMultiplikator(now, null, 98.12345, "typ");
        Assert.assertEquals((double)98.12345, (double)leistung.getVKMultiplikator(now, "typ"), (double)1.0E-5);
        ResultSet res = this.getLink().getStatement().query("SELECT ID FROM VK_PREISE WHERE TYP='typ'");
        if (res.next()) {
            Assert.assertNotNull((Object)res.getString("ID"));
        } else {
            Assert.fail((String)"no result for vk_preise");
        }
    }

    @Test
    public void testStoringVkPreiseWithSameId() {
        try {
            String id = String.valueOf(UUID.randomUUID()).substring(0, 20);
            Assert.assertEquals((long)1L, (long)this.getLink().exec("INSERT INTO VK_PREISE (ID) VALUES (" + JdbcLink.wrap((String)id) + ")"));
            this.getLink().exec("INSERT INTO VK_PREISE (ID) VALUES (" + JdbcLink.wrap((String)id) + ")");
            Assert.fail((String)"should not happen");
        }
        catch (JdbcLinkException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    @Ignore(value="not working for postgre - char 8 field returns exactly 8 bytes only for postgre")
    public void testStoringVkPreiseDatumIdChar8() throws SQLException {
        String id = String.valueOf(UUID.randomUUID()).substring(0, 20);
        String datumVon = "2010121";
        this.getLink().exec("INSERT INTO VK_PREISE (ID, DATUM_VON) VALUES (" + JdbcLink.wrap((String)id) + ", " + JdbcLink.wrap((String)datumVon) + ")");
        ResultSet res = this.getLink().getStatement().query("SELECT DATUM_VON FROM VK_PREISE WHERE ID=" + JdbcLink.wrap((String)id));
        if (res.next()) {
            Assert.assertEquals((long)datumVon.length(), (long)res.getString("DATUM_VON").length());
        } else {
            Assert.fail((String)"no result for vk_preise");
        }
    }
}

