/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.OrderServiceHolder;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Artikel;
import ch.elexis.data.Bestellung;
import ch.elexis.data.BestellungEntry;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_OrderService
extends AbstractPersistentObjectTest {
    private static IStock stock_A_5_order;
    private static Artikel artikel_A;
    private static IStockEntry stockEntry;
    private static IStockService stockService;

    static {
        stockService = (IStockService)OsgiServiceUtil.getService(IStockService.class).get();
    }

    @BeforeClass
    public static void init() {
        stock_A_5_order = (IStock)CoreModelServiceHolder.get().create(IStock.class);
        stock_A_5_order.setCode("AOD");
        stock_A_5_order.setPriority(5);
        CoreModelServiceHolder.get().save((Identifiable)stock_A_5_order);
        artikel_A = new Artikel("ArtikelAOrder", "Eigenartikel");
        artikel_A.set("Typ", ArticleTyp.EIGENARTIKEL.name());
        stockEntry = stockService.storeArticleInStock(stock_A_5_order, artikel_A.storeToString());
        Assert.assertNotNull((Object)stockEntry);
        stockEntry.setMinimumStock(5);
        stockEntry.setCurrentStock(10);
        stockEntry.setMaximumStock(15);
    }

    @AfterClass
    public static void afterClass() {
        CoreModelServiceHolder.get().remove((Identifiable)stockEntry);
        CoreModelServiceHolder.get().remove((Identifiable)stock_A_5_order);
    }

    @Test
    public void testAddRefillForStockEntryToOrderAndFindOpenOrder() {
        Bestellung b = new Bestellung("TestBestellung", CoreHub.getLoggedInContact());
        OrderServiceHolder.get().addRefillForStockEntryToOrder(stockEntry, b.toIOrder());
        Assert.assertEquals((long)1L, (long)b.getEntries().size());
        Assert.assertEquals((long)5L, (long)((BestellungEntry)b.getEntries().get(0)).getCount());
        IOrderEntry ioe = OrderServiceHolder.get().findOpenOrderEntryForStockEntry(stockEntry);
        Assert.assertNotNull((Object)ioe);
    }
}

