/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin.data;

import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.novcom.elexis.mednet.plugin.MedNet;
import ch.novcom.elexis.mednet.plugin.messages.MedNetMessages;
import java.text.MessageFormat;
import java.util.List;

public class ContactLinkRecord
extends PersistentObject
implements Comparable<ContactLinkRecord> {
    public static final String FLD_CONTACT_ID = "ContactID";
    public static final String FLD_MEDNET_ID = "MedNetID";
    public static final String FLD_CATEGORY_DOC = "category_doc";
    public static final String FLD_CATEGORY_FORM = "category_form";
    public static final String FLD_DOCIMPORT_ISACTIVE = "docImport_isActive";
    public static final String FLD_DOCIMPORT_ID = "docImport_id";
    public static final String FLD_FORMIMPORT_ISACTIVE = "formImport_isActive";
    public static final String FLD_XID_DOMAIN = "xid_domain";
    static final String TABLENAME = "MEDNET_CONTACTLINK";
    public static final int DBVERSION_ADDDOCIMPORTISACTIVE = 1;
    public static final int CURRENT_DBVERSION = 2;
    private static final String createTable = "CREATE TABLE MEDNET_CONTACTLINK(id VARCHAR(25) primary key,ContactID VARCHAR(25),MedNetID VARCHAR(255),category_doc VARCHAR(255),category_form VARCHAR(255),docImport_isActive CHAR(1) default '1',docImport_id VARCHAR(255),formImport_isActive CHAR(1) default '1',xid_domain VARCHAR(255),lastupdate BIGINT,deleted CHAR(1) default '0');";
    private static final String addMedNetIndex = "CREATE INDEX MEDNET_CONTACTLINK_idx_mednet on MEDNET_CONTACTLINK(MedNetID);";
    private static final String addImportIsActiveColumns = "ALTER TABLE MEDNET_CONTACTLINK ADD docImport_isActive CHAR(1) default '1', ADD formImport_isActive CHAR(1) default '1';";
    private static final String addDocImportIdColumns = "ALTER TABLE MEDNET_CONTACTLINK ADD docImport_id VARCHAR(255);";

    static {
        ContactLinkRecord.addMapping((String)TABLENAME, (String[])new String[]{FLD_CONTACT_ID, FLD_MEDNET_ID, FLD_CATEGORY_DOC, FLD_CATEGORY_FORM, FLD_DOCIMPORT_ISACTIVE, FLD_DOCIMPORT_ID, FLD_FORMIMPORT_ISACTIVE, FLD_XID_DOMAIN});
        ContactLinkRecord.checkTable();
    }

    protected String getTableName() {
        return TABLENAME;
    }

    private static void checkTable() {
        if (!PersistentObject.tableExists((String)TABLENAME)) {
            ContactLinkRecord.createOrModifyTable((String)createTable);
            ContactLinkRecord.createOrModifyTable((String)addMedNetIndex);
            MedNet.getSettings().setDBVersion(2);
            MedNet.getSettings().saveSettings();
        } else if (MedNet.getSettings().getDBVersion() < 1) {
            ContactLinkRecord.createOrModifyTable((String)addImportIsActiveColumns);
            ContactLinkRecord.createOrModifyTable((String)addMedNetIndex);
            ContactLinkRecord.createOrModifyTable((String)addDocImportIdColumns);
            MedNet.getSettings().setDBVersion(2);
            MedNet.getSettings().saveSettings();
        } else if (MedNet.getSettings().getDBVersion() < 2) {
            ContactLinkRecord.createOrModifyTable((String)addDocImportIdColumns);
            MedNet.getSettings().setDBVersion(2);
            MedNet.getSettings().saveSettings();
        }
    }

    public ContactLinkRecord(String contactID, String mednetID, String category_doc, String category_form, boolean docImport_isActive, String docImport_id, boolean formImport_isActive, String xidDomain) {
        this.create(null);
        this.set(new String[]{FLD_CONTACT_ID, FLD_MEDNET_ID, FLD_CATEGORY_DOC, FLD_CATEGORY_FORM, FLD_DOCIMPORT_ISACTIVE, FLD_DOCIMPORT_ID, FLD_FORMIMPORT_ISACTIVE, FLD_XID_DOMAIN}, new String[]{contactID, mednetID, category_doc, category_form, docImport_isActive ? "1" : "0", docImport_id, formImport_isActive ? "1" : "0", xidDomain});
    }

    public ContactLinkRecord() {
    }

    public ContactLinkRecord(String id) {
        super(id);
    }

    public static ContactLinkRecord load(String id) {
        return new ContactLinkRecord(id);
    }

    public String toString() {
        return this.getLabel();
    }

    public String getContactID() {
        return PersistentObject.checkNull((Object)this.get(FLD_CONTACT_ID));
    }

    public void setContactID(String contactID) {
        this.set(FLD_CONTACT_ID, contactID);
    }

    public String getMedNetID() {
        return PersistentObject.checkNull((Object)this.get(FLD_MEDNET_ID));
    }

    public void setMedNetID(String mednetID) {
        this.set(FLD_MEDNET_ID, mednetID);
    }

    public String getCategoryDoc() {
        return PersistentObject.checkNull((Object)this.get(FLD_CATEGORY_DOC));
    }

    public void setCategoryDoc(String category) {
        this.set(FLD_CATEGORY_DOC, category);
    }

    public String getCategoryForm() {
        return PersistentObject.checkNull((Object)this.get(FLD_CATEGORY_FORM));
    }

    public void setCategoryForm(String category) {
        this.set(FLD_CATEGORY_FORM, category);
    }

    public boolean docImport_isActive() {
        return PersistentObject.checkNull((Object)this.get(FLD_DOCIMPORT_ISACTIVE)).equals("1");
    }

    public String getDocImport_id() {
        return PersistentObject.checkNull((Object)this.get(FLD_DOCIMPORT_ID));
    }

    public void setDocImport_id(String docImport_id) {
        this.set(FLD_DOCIMPORT_ID, docImport_id);
    }

    public void docImport_setActive(boolean isActive) {
        this.set(FLD_DOCIMPORT_ISACTIVE, isActive ? "1" : "0");
    }

    public boolean formImport_isActive() {
        return PersistentObject.checkNull((Object)this.get(FLD_FORMIMPORT_ISACTIVE)).equals("1");
    }

    public void formImport_setActive(boolean isActive) {
        this.set(FLD_FORMIMPORT_ISACTIVE, isActive ? "1" : "0");
    }

    public String getXIDDomain() {
        return PersistentObject.checkNull((Object)this.get(FLD_XID_DOMAIN));
    }

    public void setXIDDomain(String xidDomain) {
        this.set(FLD_XID_DOMAIN, xidDomain);
    }

    public String getLabel() {
        String[] fields = new String[]{FLD_CONTACT_ID, FLD_MEDNET_ID, FLD_CATEGORY_DOC, FLD_CATEGORY_FORM, FLD_DOCIMPORT_ISACTIVE, FLD_DOCIMPORT_ID, FLD_FORMIMPORT_ISACTIVE, FLD_XID_DOMAIN};
        String[] vals = new String[fields.length];
        this.get(fields, vals);
        return MessageFormat.format(MedNetMessages.ContactLinkRecord_Label, vals[0], vals[1], vals[2], vals[3], vals[4], vals[5], vals[6], vals[7]);
    }

    @Override
    public int compareTo(ContactLinkRecord other) {
        if (other == null) {
            return -1;
        }
        if (this.getContactID() != null && other.getContactID() == null) {
            return -1;
        }
        if (this.getContactID() == null && other.getContactID() != null) {
            return 1;
        }
        int comparator = this.getContactID().compareTo(other.getContactID());
        if (comparator != 0) {
            return comparator;
        }
        if (this.getMedNetID() != null && other.getMedNetID() == null) {
            return -1;
        }
        if (this.getMedNetID() == null && other.getMedNetID() != null) {
            return 1;
        }
        comparator = this.getMedNetID().compareTo(other.getMedNetID());
        if (comparator != 0) {
            return comparator;
        }
        return 0;
    }

    public static List<ContactLinkRecord> getAllContactLinkRecords() {
        Query qbe = new Query(ContactLinkRecord.class);
        return qbe.execute();
    }

    public static List<ContactLinkRecord> getContactLinkRecord(String contactId, String mednetId) {
        Query qbe = new Query(ContactLinkRecord.class);
        if (contactId != null && contactId.length() > 0) {
            qbe.add(FLD_CONTACT_ID, "=", contactId);
        }
        if (mednetId != null && mednetId.length() > 0) {
            qbe.add(FLD_MEDNET_ID, "=", mednetId, true);
        }
        return qbe.execute();
    }
}

