/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.ui.model;

import ch.elexis.regiomed.order.model.RegiomedProductLookupResponse;
import org.apache.commons.lang3.StringUtils;

public class SearchProductViewModel {
    private final RegiomedProductLookupResponse.ProductResult product;
    private final int index;

    public SearchProductViewModel(RegiomedProductLookupResponse.ProductResult product, int index) {
        this.product = product;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getProdName() {
        return this.escapeHtml(this.product.prodName);
    }

    public String getManufacturer() {
        return this.escapeHtml(this.product.manufacturer);
    }

    public String getEan() {
        return this.escapeHtml(this.product.ean);
    }

    public String getMessage() {
        return this.escapeHtml(this.product.message);
    }

    public String getPrice() {
        return String.format("%.2f", this.product.price);
    }

    public String getStock() {
        return this.escapeHtml(this.product.availableInventory);
    }

    public boolean hasStock() {
        return StringUtils.isNotBlank((CharSequence)this.product.availableInventory);
    }

    private String escapeHtml(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }
}

