/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.ui.model;

import ch.elexis.regiomed.order.messages.Messages;
import ch.elexis.regiomed.order.model.RegiomedOrderResponse;
import ch.elexis.regiomed.order.ui.model.RenderingContext;
import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ArticleViewModel {
    private final RegiomedOrderResponse.ArticleResult item;
    private final String rowId;
    private final boolean isErrorTable;
    private final RenderingContext ctx;
    private final boolean isStockError;
    private final boolean isReplaced;
    private final boolean isRemoved;
    private final boolean isForced;
    private final String key;

    public ArticleViewModel(RegiomedOrderResponse.ArticleResult item, String rowId, boolean isErrorTable, RenderingContext ctx) {
        this.item = item;
        this.rowId = rowId;
        this.isErrorTable = isErrorTable;
        this.ctx = ctx;
        this.key = this.getKey(item);
        this.isReplaced = ctx.replacements() != null && ctx.replacements().containsKey(this.key);
        this.isRemoved = ctx.removed() != null && ctx.removed().contains(this.key);
        this.isForced = ctx.forcedItems() != null && ctx.forcedItems().contains(this.key);
        this.isStockError = item.getAvailableInventory() > 0 && item.getQuantity() > item.getAvailableInventory();
    }

    public String getRowId() {
        return this.rowId;
    }

    public String getDescription() {
        return this.escapeHtml(this.item.getDescription());
    }

    public String getEscapedDescription() {
        return this.escapeHtml(this.item.getDescription()).replace("'", "\\'");
    }

    public String getPharmaCode() {
        return String.valueOf(this.item.getPharmaCode());
    }

    public String getEan() {
        return String.valueOf(this.item.getEanID());
    }

    public String getStock() {
        return String.valueOf(this.item.getAvailableInventory());
    }

    public int getQuantity() {
        return this.item.getQuantity();
    }

    public boolean isStockError() {
        return this.isStockError;
    }

    public boolean isErrorTable() {
        return this.isErrorTable;
    }

    public boolean isDisabled() {
        return this.isReplaced || this.isRemoved || this.isForced;
    }

    public boolean isHandled() {
        return this.isRemoved || this.isReplaced || this.isForced;
    }

    public boolean getShowEditIcon() {
        return !this.isRemoved;
    }

    public String getRowClass() {
        if (this.isReplaced) {
            return "row-replaced";
        }
        if (this.isForced) {
            return "row-forced";
        }
        return "";
    }

    public String getContentClass() {
        if (this.isRemoved) {
            return "state-removed";
        }
        return "";
    }

    public String getInfoClass() {
        if (this.isRemoved) {
            return "state-removed";
        }
        if (this.isErrorTable && !this.isReplaced && !this.isRemoved && !this.isForced) {
            return "text-danger";
        }
        return "";
    }

    public String getBadgeClass() {
        if (this.isReplaced) {
            return "badge-replaced";
        }
        if (this.isForced) {
            return "badge-forced";
        }
        if (this.isErrorTable && !this.isRemoved) {
            return "badge-error";
        }
        if (this.isErrorTable && this.isRemoved) {
            return "badge-error";
        }
        return "badge-ok";
    }

    public String getInfoText() {
        StringBuilder sb = new StringBuilder();
        String originalMsg = StringUtils.defaultString((String)(StringUtils.isBlank((CharSequence)this.item.getInfo()) ? this.item.getAvailMsg() : this.item.getInfo()));
        if (this.isStockError) {
            sb.append(MessageFormat.format(Messages.RegiomedCheckTemplate_QtyExceedsStock, this.item.getQuantity(), this.item.getAvailableInventory()));
            if (StringUtils.isNotBlank((CharSequence)originalMsg) && !originalMsg.contains("\u00fcbersteigt Bestand")) {
                sb.append("<br><small style='color:#666'>").append(Messages.RegiomedCheckTemplate_NoteLabel).append(" ").append(this.escapeHtml(originalMsg)).append("</small>");
            }
        } else {
            sb.append(this.escapeHtml(originalMsg));
        }
        String availMsg = this.item.getAvailMsg();
        String orgMsg = this.item.getAvailMsgOrg();
        if (StringUtils.isNotBlank((CharSequence)orgMsg) && !availMsg.equalsIgnoreCase(orgMsg.trim())) {
            sb.append("<br><small style='color:#666'>").append(this.escapeHtml(orgMsg)).append("</small>");
        }
        return sb.toString();
    }

    public String getReplacementName() {
        if (!this.isReplaced) {
            return null;
        }
        if (this.ctx.replacementNames() != null && this.ctx.replacementNames().containsKey(this.key)) {
            return this.escapeHtml(this.ctx.replacementNames().get(this.key));
        }
        String newKey = this.ctx.replacements().get(this.key);
        if (newKey == null) {
            return null;
        }
        List<RegiomedOrderResponse.AlternativeResult> alts = this.ctx.alternativesMap().get(this.key);
        if (alts != null) {
            for (RegiomedOrderResponse.AlternativeResult alt : alts) {
                String altKey = alt.getPharmaCode() + ":" + alt.getEanID();
                if (!altKey.equals(newKey)) continue;
                return this.escapeHtml(alt.getDescription());
            }
        }
        return null;
    }

    public boolean getHasAlternatives() {
        List<RegiomedOrderResponse.AlternativeResult> alts = this.ctx.alternativesMap().get(this.key);
        return this.isErrorTable && alts != null && !alts.isEmpty();
    }

    public List<Map<String, String>> getAlternatives() {
        List<RegiomedOrderResponse.AlternativeResult> alts = this.ctx.alternativesMap().get(this.key);
        if (alts == null) {
            return Collections.emptyList();
        }
        return alts.stream().map(a -> {
            HashMap<String, CallSite> m = new HashMap<String, CallSite>();
            String label = a.getDescription() + (String)(a.getPrice() != null && a.getPrice() > 0.0 ? " (CHF " + String.format("%.2f", a.getPrice()) + ")" : "");
            m.put("label", (CallSite)((Object)label));
            m.put("value", (CallSite)((Object)(a.getPharmaCode() + ":" + a.getEanID())));
            return m;
        }).collect(Collectors.toList());
    }

    public String getBadgeText() {
        if (this.isReplaced) {
            return Messages.RegiomedCheckTemplate_BadgeReplaced;
        }
        if (this.isForced) {
            return Messages.RegiomedCheckTemplate_BadgeOrder;
        }
        if (this.isErrorTable) {
            return Messages.RegiomedCheckTemplate_BadgeError;
        }
        return Messages.RegiomedCheckTemplate_BadgeOk;
    }

    public boolean getCanReset() {
        return this.isReplaced || this.isRemoved || this.isForced;
    }

    public boolean getShowForceBtn() {
        return this.isErrorTable && this.isStockError && !this.isForced && !this.isReplaced && !this.isRemoved;
    }

    public int getBtnCount() {
        int c = 1;
        if (this.getShowForceBtn()) {
            ++c;
        }
        if (this.ctx.isSearchAvailable()) {
            ++c;
        }
        if (this.getHasAlternatives()) {
            ++c;
        }
        return c;
    }

    private String getKey(RegiomedOrderResponse.ArticleResult a) {
        return a.getPharmaCode() + ":" + a.getEanID();
    }

    private String escapeHtml(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }
}

