/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.ui;

import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.regiomed.order.messages.Messages;
import ch.elexis.regiomed.order.model.RegiomedOrderResponse;
import ch.elexis.regiomed.order.model.RegiomedProductLookupResponse;
import ch.elexis.regiomed.order.ui.model.ArticleViewModel;
import ch.elexis.regiomed.order.ui.model.RenderingContext;
import ch.elexis.regiomed.order.ui.model.SearchProductViewModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegiomedCheckTemplate {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
    private static final Logger log = LoggerFactory.getLogger(RegiomedCheckTemplate.class);
    private static Configuration cfg = new Configuration(Configuration.VERSION_2_3_32);

    static {
        cfg.setClassForTemplateLoading(RegiomedCheckTemplate.class, "/rsc");
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
    }

    public static String generateHtml(RegiomedOrderResponse response, boolean isSearchAvailable, Set<String> removed, Map<String, String> replacements, Map<String, String> replacementNames, Set<String> forcedItems) {
        try {
            RenderingContext context = RegiomedCheckTemplate.createContext(response, isSearchAvailable, removed, replacements, replacementNames, forcedItems);
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("cssContent", RegiomedCheckTemplate.loadResourceFile("/rsc/styles.css"));
            List<Object> allArticles = response.getArticles() != null ? response.getArticles() : Collections.emptyList();
            ArrayList<ArticleViewModel> nokItems = new ArrayList<ArticleViewModel>();
            ArrayList<ArticleViewModel> okItems = new ArrayList<ArticleViewModel>();
            int i = 0;
            for (RegiomedOrderResponse.ArticleResult articleResult : allArticles) {
                boolean isError = RegiomedCheckTemplate.isCalculatedError(articleResult, context.alternativesMap());
                String rowId = (isError ? "nok_row_" : "ok_row_") + i++;
                ArticleViewModel vm2 = new ArticleViewModel(articleResult, rowId, isError, context);
                if (isError) {
                    nokItems.add(vm2);
                    continue;
                }
                okItems.add(vm2);
            }
            root.put("nokItems", nokItems);
            root.put("okItems", okItems);
            boolean bl = nokItems.stream().anyMatch(vm -> !vm.isHandled());
            root.put("hasActiveErrors", bl);
            root.put("responseMessage", response.getMessage());
            root.put("currentDate", LocalDateTime.now().format(DATE_FORMATTER));
            root.put("logoBase64", context.imgLogo());
            root.put("imgWarning", context.imgWarning());
            root.put("imgEdit", context.imgEdit());
            root.put("isSearchAvailable", isSearchAvailable);
            root.put("messages", RegiomedCheckTemplate.loadMessagesMap());
            Template temp = cfg.getTemplate("regiomed_result_html.ftlh");
            StringWriter out = new StringWriter();
            temp.process(root, (Writer)out);
            return out.toString();
        }
        catch (Exception e) {
            log.error("Error generating HTML for Regiomed check result", (Throwable)e);
            return "<html><body><h1>Error generating template</h1><pre>" + e.getMessage() + "</pre></body></html>";
        }
    }

    public static String generateSearchResultRows(List<RegiomedProductLookupResponse.ProductResult> products) {
        try {
            HashMap<String, Object> root = new HashMap<String, Object>();
            if (products == null || products.isEmpty()) {
                root.put("products", Collections.emptyList());
                root.put("noResultsMsg", Messages.RegiomedCheckTemplate_NoResults);
            } else {
                ArrayList<SearchProductViewModel> viewModels = new ArrayList<SearchProductViewModel>();
                boolean anyHasStock = false;
                int i = 0;
                while (i < products.size()) {
                    SearchProductViewModel vm = new SearchProductViewModel(products.get(i), i);
                    viewModels.add(vm);
                    if (vm.hasStock()) {
                        anyHasStock = true;
                    }
                    ++i;
                }
                root.put("products", viewModels);
                root.put("hasStockColumn", anyHasStock);
                root.put("noResultsMsg", Messages.RegiomedCheckTemplate_NoResults);
            }
            Template temp = cfg.getTemplate("regiomed_search_rows_html.ftlh");
            StringWriter out = new StringWriter();
            temp.process(root, (Writer)out);
            return out.toString().replace("\r", "").replace("\n", "");
        }
        catch (Exception e) {
            log.error("Error generating search result rows template", (Throwable)e);
            return "<tr><td colspan='5' style='color:red'>Error: " + e.getMessage().replace("'", "") + "</td></tr>";
        }
    }

    private static String loadResourceFile(String path) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = RegiomedCheckTemplate.class.getResourceAsStream(path);){
                if (in == null) {
                    return "/* File not found: " + path + " */";
                }
                return new String(in.readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.warn("Could not load resource file: {}", (Object)path, (Object)e);
            return "/* Error loading " + path + ": " + e.getMessage() + " */";
        }
    }

    private static RenderingContext createContext(RegiomedOrderResponse response, boolean isSearchAvailable, Set<String> removed, Map<String, String> replacements, Map<String, String> replacementNames, Set<String> forcedItems) {
        Throwable throwable;
        Map<String, List<RegiomedOrderResponse.AlternativeResult>> altsMap = Collections.emptyMap();
        if (response.getAlternatives() != null && !response.getAlternatives().isEmpty()) {
            altsMap = response.getAlternatives().stream().collect(Collectors.groupingBy(a -> RegiomedCheckTemplate.getKey(a.getPharmaCodeOrg(), a.getEanIDOrg())));
        }
        String imgEdit = null;
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (InputStream in = Images.IMG_EDIT.getImageAsInputStream(ImageSize._16x16_DefaultIconSize);){
                imgEdit = "data:image/png;base64," + Base64.getEncoder().encodeToString(in.readAllBytes());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Exception e) {
            log.debug("Could not load edit icon", (Throwable)e);
        }
        String imgWarning = null;
        try {
            throwable = null;
            Object var10_15 = null;
            try (InputStream in = Images.IMG_AUSRUFEZ.getImageAsInputStream(ImageSize._16x16_DefaultIconSize);){
                imgWarning = "data:image/png;base64," + Base64.getEncoder().encodeToString(in.readAllBytes());
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug("Could not load warning icon", (Throwable)e);
        }
        return new RenderingContext(isSearchAvailable, removed, replacements, replacementNames, forcedItems, altsMap, RegiomedCheckTemplate.loadLogoBase64("rsc/logo/regiomed_logo.png"), imgWarning, imgEdit);
    }

    private static boolean isCalculatedError(RegiomedOrderResponse.ArticleResult a, Map<String, List<RegiomedOrderResponse.AlternativeResult>> alternativesMap) {
        boolean hasAlternatives;
        if (!a.isSuccess()) {
            return true;
        }
        if (a.getAvailableInventory() > 0 && a.getQuantity() > a.getAvailableInventory()) {
            return true;
        }
        String key = RegiomedCheckTemplate.getKey(a.getPharmaCode(), a.getEanID());
        boolean bl = hasAlternatives = alternativesMap.containsKey(key) && !alternativesMap.get(key).isEmpty();
        if (hasAlternatives) {
            return !a.isSuccessAvailability();
        }
        return false;
    }

    private static String getKey(long pharma, long ean) {
        return pharma + ":" + ean;
    }

    private static String loadLogoBase64(String imageUrl) {
        URL url;
        block14: {
            Bundle bundle;
            block13: {
                try {
                    bundle = FrameworkUtil.getBundle(RegiomedCheckTemplate.class);
                    if (bundle != null) break block13;
                    return null;
                }
                catch (Exception e) {
                    log.debug("Could not load logo: {}", (Object)imageUrl, (Object)e);
                    return null;
                }
            }
            url = bundle.getEntry(imageUrl);
            if (url != null) break block14;
            return null;
        }
        Throwable throwable = null;
        Object var4_6 = null;
        try (InputStream in = url.openStream();){
            byte[] imageBytes = in.readAllBytes();
            return "data:image/png;base64," + Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Map<String, String> loadMessagesMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("successApplied", Messages.RegiomedCheckTemplate_SuccessApplied);
        m.put("successAppliedPrefix", Messages.RegiomedCheckTemplate_SuccessAppliedPrefix);
        m.put("orderTitle", Messages.RegiomedCheckTemplate_OrderTitle);
        m.put("checkResult", Messages.RegiomedCheckTemplate_CheckResult);
        m.put("allChecksSuccess", Messages.RegiomedCheckTemplate_AllChecksSuccess);
        m.put("hintText", Messages.RegiomedCheckTemplate_HintText);
        m.put("problematicItems", Messages.RegiomedCheckTemplate_ProblematicItems);
        m.put("correctedItems", Messages.RegiomedCheckTemplate_CorrectedItems);
        m.put("availableItems", Messages.RegiomedCheckTemplate_AvailableItems);
        m.put("colArticle", Messages.RegiomedCheckTemplate_ColArticle);
        m.put("colAmount", Messages.RegiomedCheckTemplate_ColAmount);
        m.put("colInfo", Messages.RegiomedCheckTemplate_ColInfo);
        m.put("colStatus", Messages.RegiomedCheckTemplate_ColStatus);
        m.put("colAction", Messages.RegiomedCheckTemplate_ColAction);
        m.put("colName", Messages.RegiomedCheckTemplate_ColName);
        m.put("colPrice", Messages.RegiomedCheckTemplate_ColPrice);
        m.put("pharmaLabel", Messages.RegiomedCheckTemplate_PharmaLabel);
        m.put("stockLabel", Messages.RegiomedCheckTemplate_StockLabel);
        m.put("availableAlternatives", Messages.RegiomedCheckTemplate_AvailableAlternatives);
        m.put("noAlternativeAvailable", Messages.RegiomedCheckTemplate_NoAlternativeAvailable);
        m.put("btnReset", Messages.Core_Reset);
        m.put("btnForce", Messages.RegiomedCheckTemplate_ForceOrderBtn);
        m.put("btnSearch", Messages.RegiomedCheckTemplate_SearchAltBtn);
        m.put("btnReplace", Messages.RegiomedCheckTemplate_BtnReplace);
        m.put("btnDelete", Messages.RegiomedCheckTemplate_BtnDelete);
        m.put("badgeOk", Messages.RegiomedCheckTemplate_BadgeOk);
        m.put("badgeReplaced", Messages.RegiomedCheckTemplate_BadgeReplaced);
        m.put("badgeOrder", Messages.RegiomedCheckTemplate_BadgeOrder);
        m.put("badgeError", Messages.RegiomedCheckTemplate_BadgeError);
        m.put("clickToEdit", Messages.RegiomedCheckTemplate_ClickToEdit);
        m.put("changeQtyTitle", Messages.RegiomedCheckTemplate_ChangeQtyTitle);
        m.put("enterNewQty", Messages.RegiomedCheckTemplate_EnterNewQty);
        m.put("cancel", Messages.RegiomedCheckTemplate_Cancel);
        m.put("apply", Messages.RegiomedCheckTemplate_Apply);
        m.put("errorTitle", Messages.RegiomedCheckTemplate_ErrorTitle);
        m.put("understood", Messages.RegiomedCheckTemplate_Understood);
        m.put("searchAltTitle", Messages.RegiomedCheckTemplate_SearchAltTitle);
        m.put("searchPlaceholder", Messages.RegiomedCheckTemplate_SearchPlaceholder);
        m.put("searchBtn", Messages.RegiomedCheckTemplate_SearchBtn);
        m.put("searching", Messages.RegiomedCheckTemplate_Searching);
        m.put("close", Messages.RegiomedCheckTemplate_Close);
        m.put("invalidQtyAlert", Messages.RegiomedCheckTemplate_InvalidQtyAlert);
        return m;
    }
}

