/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labor.medics.v2;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.labor.medics.v2.Messages;
import ch.elexis.labor.medics.v2.WebAisMandatorComposite;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MedicsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String DOWNLOAD_DIR = "medics/download";
    public static final String UPLOAD_DIR = "medics/upload";
    public static final String IMED_DIR = "medics/uploadimed";
    public static final String ARCHIV_DIR = "medics/archiv";
    public static final String ERROR_DIR = "medics/error";
    public static final String DOKUMENT_CATEGORY = "medics/extern";
    public static final String DELETE_ARCHIV_DAYS = "medics/del_archiv/days";
    private static final String DEFAULT_DOWNLOAD = "";
    private static final String DEFAULT_UPLOAD = "";
    private static final String DEFAULT_IMED = "";
    private static final String DEFAULT_ARCHIV = "";
    private static final String DEFAULT_DOKUMENT_CATEGORY = Messages.MedicsPreferencePage_documentCategoryName;
    private static final int DEFAULT_DELETE_ARCHIV_DAYS = 30;
    public static final String CFG_MEDICS_ORDER_API = "medics/order_api";
    private List<WebAisMandatorComposite> webaisMandators;
    private Composite mandatorsContainer;

    public MedicsPreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
        this.getPreferenceStore().setDefault(DOWNLOAD_DIR, "");
        this.getPreferenceStore().setDefault(UPLOAD_DIR, "");
        this.getPreferenceStore().setDefault(IMED_DIR, "");
        this.getPreferenceStore().setDefault(ARCHIV_DIR, "");
        this.getPreferenceStore().setDefault(DOKUMENT_CATEGORY, DEFAULT_DOKUMENT_CATEGORY);
        this.getPreferenceStore().setDefault(DELETE_ARCHIV_DAYS, 30);
    }

    protected Control createContents(Composite parent) {
        final Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite fieldEditorContainer = new Composite(container, 0);
        fieldEditorContainer.setLayout((Layout)new GridLayout());
        fieldEditorContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        super.createContents(fieldEditorContainer);
        this.getFieldEditorParent().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Button btnChangeApi = new Button(container, 8);
        btnChangeApi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StringUtils.isEmpty((CharSequence)ConfigServiceHolder.get().get(MedicsPreferencePage.CFG_MEDICS_ORDER_API, ""))) {
                    ConfigServiceHolder.get().set(MedicsPreferencePage.CFG_MEDICS_ORDER_API, "web");
                    btnChangeApi.setText("Wechsel auf HL7 API");
                    MedicsPreferencePage.this.mandatorsContainer.setVisible(true);
                    ((GridData)MedicsPreferencePage.this.mandatorsContainer.getLayoutData()).exclude = false;
                } else {
                    ConfigServiceHolder.get().set(MedicsPreferencePage.CFG_MEDICS_ORDER_API, "");
                    btnChangeApi.setText("Wechsel auf Web API (neu)");
                    MedicsPreferencePage.this.mandatorsContainer.setVisible(false);
                    ((GridData)MedicsPreferencePage.this.mandatorsContainer.getLayoutData()).exclude = true;
                }
                MedicsPreferencePage.layoutParentShell(container);
            }
        });
        btnChangeApi.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.mandatorsContainer = new Composite(container, 0);
        this.mandatorsContainer.setLayout((Layout)new GridLayout());
        this.mandatorsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label separator = new Label(this.mandatorsContainer, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (ContextServiceHolder.get().getActiveUser().isPresent() && ((IUser)ContextServiceHolder.get().getActiveUser().get()).isAdministrator()) {
            Button useTestBtn = new Button(this.mandatorsContainer, 32);
            useTestBtn.setText("Test Portal URL verwenden (nur als Administrator)");
            useTestBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean value = ConfigServiceHolder.get().get("Medics_LaborOrder/testmode", false);
                    ConfigServiceHolder.get().set("Medics_LaborOrder/testmode", !value);
                }
            });
            useTestBtn.setSelection(ConfigServiceHolder.get().get("Medics_LaborOrder/testmode", false));
        }
        List mandators = CoreModelServiceHolder.get().getQuery(IMandator.class).execute();
        mandators.sort((l, r) -> l.getLabel().compareTo(r.getLabel()));
        this.webaisMandators = new ArrayList<WebAisMandatorComposite>();
        for (IMandator mandator : mandators) {
            WebAisMandatorComposite composite = new WebAisMandatorComposite(mandator, this, this.mandatorsContainer, 0);
            composite.setLayoutData(new GridData(4, 0x1000000, true, false));
            this.webaisMandators.add(composite);
        }
        if (StringUtils.isEmpty((CharSequence)ConfigServiceHolder.get().get(CFG_MEDICS_ORDER_API, ""))) {
            btnChangeApi.setText("Wechsel auf Web API (neu)");
            this.mandatorsContainer.setVisible(false);
            ((GridData)this.mandatorsContainer.getLayoutData()).exclude = true;
        } else {
            btnChangeApi.setText("Wechsel auf HL7 API");
            this.mandatorsContainer.setVisible(true);
            ((GridData)this.mandatorsContainer.getLayoutData()).exclude = false;
        }
        return container;
    }

    public void updateMandatorComposites() {
        this.webaisMandators.forEach(w -> w.updateCredentials());
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new DirectoryFieldEditor(DOWNLOAD_DIR, Messages.MedicsPreferencePage_labelDownloadDir, this.getFieldEditorParent()));
        this.addField((FieldEditor)new DirectoryFieldEditor(UPLOAD_DIR, Messages.MedicsPreferencePage_labelUploadDir, this.getFieldEditorParent()));
        this.addField((FieldEditor)new DirectoryFieldEditor(IMED_DIR, Messages.MedicsPreferencePage_labelUploadDirimed, this.getFieldEditorParent()));
        this.addField((FieldEditor)new DirectoryFieldEditor(ARCHIV_DIR, Messages.MedicsPreferencePage_labelArchivDir, this.getFieldEditorParent()));
        this.addField((FieldEditor)new DirectoryFieldEditor(ERROR_DIR, Messages.MedicsPreferencePage_labelErrorDir, this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor(DOKUMENT_CATEGORY, Messages.MedicsPreferencePage_labelDocumentCategory, this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor(DELETE_ARCHIV_DAYS, "Archiv bereinigen (Tage)", this.getFieldEditorParent()));
    }

    public static String getDownloadDir() {
        return CoreHub.localCfg.get(DOWNLOAD_DIR, "");
    }

    public static String getDokumentKategorie() {
        return CoreHub.localCfg.get(DOKUMENT_CATEGORY, DEFAULT_DOKUMENT_CATEGORY);
    }

    public static int getDeleteArchivDays() {
        return CoreHub.localCfg.get(DELETE_ARCHIV_DAYS, 30);
    }

    public static String getUploadDirimed() {
        return CoreHub.localCfg.get(IMED_DIR, "");
    }

    public static String getUploadDir() {
        return CoreHub.localCfg.get(UPLOAD_DIR, "");
    }

    public void init(IWorkbench workbench) {
    }

    public static void layoutParentShell(Composite composite) {
        Composite parent = composite.getParent();
        while (parent != null && !(parent instanceof Shell)) {
            parent = parent.getParent();
        }
        if (parent instanceof Shell) {
            parent.layout(true, true);
        }
    }
}

