/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal.csv;

import ch.elexis.data.Labor;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.core.internal.csv.AbstractCsvImportFile;
import com.opencsv.exceptions.CsvValidationException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.LoggerFactory;

public class LabContactFile
extends AbstractCsvImportFile<Labor>
implements IAeskulapImportFile {
    private File file;

    public LabContactFile(File file) {
        super(file);
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public static boolean canHandleFile(File file) {
        return FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase("csv") && FilenameUtils.getBaseName((String)file.getName()).equalsIgnoreCase("Labor_LabSource");
    }

    @Override
    public IAeskulapImportFile.Type getType() {
        return IAeskulapImportFile.Type.LABORCONTACT;
    }

    @Override
    public boolean doImport(Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles, boolean overwrite, SubMonitor monitor) {
        monitor.beginTask("Aeskuplap Labor Adressen Import", this.getLineCount());
        try {
            String[] line = null;
            while ((line = this.getNextLine()) != null) {
                Labor laboratory = (Labor)this.getExisting(line[0]);
                if (laboratory == null) {
                    laboratory = this.create(line);
                } else if (!overwrite) continue;
                this.setProperties(laboratory, line);
                monitor.worked(1);
            }
            return true;
        }
        catch (CsvValidationException | IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error importing file", e);
        }
        finally {
            this.close();
            monitor.done();
        }
        return false;
    }

    @Override
    public boolean isHeaderLine(String[] line) {
        return line[0].equalsIgnoreCase("LabSource_no");
    }

    @Override
    public String getXidDomain() {
        return "elexis.ch/aeskulap_import/LabContactID";
    }

    @Override
    public Labor create(String[] line) {
        Labor ret = new Labor(line[1], line[2]);
        ret.addXid(this.getXidDomain(), line[0], true);
        return ret;
    }

    @Override
    public void setProperties(Labor contact, String[] line) {
    }
}

