/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.data.Xid;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.core.IAeskulapImporter;
import ch.elexis.importer.aeskulap.core.internal.AeskulapFileFactory;
import ch.elexis.importer.aeskulap.core.internal.DiagDirectory;
import ch.elexis.importer.aeskulap.core.internal.DocumentDirectories;
import ch.elexis.importer.aeskulap.core.internal.FileDirectories;
import ch.elexis.importer.aeskulap.core.internal.LetterDirectories;
import ch.elexis.importer.aeskulap.core.service.DocumentStoreServiceHolder;
import ch.elexis.omnivore.model.IDocumentHandle;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class AeskulapImporter
implements IAeskulapImporter {
    private Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles;
    private LetterDirectories letterDirectories;
    private DocumentDirectories documentDirectories;
    private FileDirectories fileDirectories;
    private DiagDirectory diagDirectory;
    private IModelService omnivoreModelService;

    @Override
    public List<IAeskulapImportFile> setImportDirectory(File directory) {
        this.registerXids();
        ArrayList<IAeskulapImportFile> ret = new ArrayList<IAeskulapImportFile>();
        if (directory != null && directory.exists() && directory.isDirectory()) {
            File[] fileOrDirectory;
            File[] fileArray = fileOrDirectory = directory.listFiles();
            int n = fileOrDirectory.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    if (this.isLetterDirectory(file)) {
                        this.addLetterDirectory(file);
                    } else if (this.isDocumentDirectory(file)) {
                        this.addDocumentDirectory(file);
                    } else if (this.isFileDirectory(file)) {
                        this.addFileDirectory(file);
                    } else if (this.isDiagDirectory(file)) {
                        this.addDiagDirectory(file);
                    } else {
                        ret.addAll(this.getAeskulapFilesFromDirectory(file));
                    }
                } else {
                    AeskulapFileFactory.getAeskulapFile(file).ifPresent(af -> {
                        boolean bl = ret.add((IAeskulapImportFile)af);
                    });
                }
                ++n2;
            }
        }
        if (this.letterDirectories != null) {
            ret.add(this.letterDirectories);
        }
        if (this.documentDirectories != null) {
            ret.add(this.documentDirectories);
        }
        if (this.fileDirectories != null) {
            ret.add(this.fileDirectories);
        }
        if (this.diagDirectory != null) {
            ret.add(this.diagDirectory);
        }
        return ret;
    }

    private void addLetterDirectory(File file) {
        if (this.letterDirectories == null) {
            this.letterDirectories = new LetterDirectories();
        }
        this.letterDirectories.add(file);
    }

    private void addDocumentDirectory(File file) {
        if (this.documentDirectories == null) {
            this.documentDirectories = new DocumentDirectories();
        }
        this.documentDirectories.add(file);
    }

    private void addFileDirectory(File file) {
        if (this.fileDirectories == null) {
            this.fileDirectories = new FileDirectories();
        }
        this.fileDirectories.add(file);
    }

    private void addDiagDirectory(File file) {
        if (this.diagDirectory == null) {
            this.diagDirectory = new DiagDirectory();
        }
        this.diagDirectory.add(file);
    }

    private boolean isLetterDirectory(File directory) {
        if (directory.isDirectory()) {
            File[] docFiles = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("!") && name.contains("_");
                }
            });
            return docFiles.length > 0;
        }
        return false;
    }

    private boolean isDocumentDirectory(File directory) {
        if (directory.isDirectory()) {
            File[] docFiles = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("Doc_") && name.contains("_");
                }
            });
            return docFiles.length > 0;
        }
        return false;
    }

    private boolean isFileDirectory(File directory) {
        if (directory.isDirectory()) {
            File[] docFiles = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("PF_") && name.contains("_");
                }
            });
            return docFiles.length > 0;
        }
        return false;
    }

    private boolean isDiagDirectory(File directory) {
        if (directory.isDirectory() && directory.getName().equalsIgnoreCase("diag")) {
            File[] diagFiles = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches("[0-9]+.txt");
                }
            });
            return diagFiles.length > 0;
        }
        return false;
    }

    private List<IAeskulapImportFile> getAeskulapFilesFromDirectory(File directory) {
        File[] fileOrDirectory;
        ArrayList<IAeskulapImportFile> ret = new ArrayList<IAeskulapImportFile>();
        File[] fileArray = fileOrDirectory = directory.listFiles();
        int n = fileOrDirectory.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (this.isLetterDirectory(file)) {
                    this.addLetterDirectory(file);
                } else if (this.isDocumentDirectory(file)) {
                    this.addDocumentDirectory(file);
                } else if (this.isFileDirectory(file)) {
                    this.addFileDirectory(file);
                } else if (this.isDiagDirectory(file)) {
                    this.addDiagDirectory(file);
                } else {
                    ret.addAll(this.getAeskulapFilesFromDirectory(file));
                }
            } else {
                AeskulapFileFactory.getAeskulapFile(file).ifPresent(af -> {
                    boolean bl = ret.add((IAeskulapImportFile)af);
                });
            }
            ++n2;
        }
        return ret;
    }

    public void registerXids() {
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/AddrID", (String)"Alte Adress-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/LabContactID", (String)"Alte Labor Kontakt-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/LabItemID", (String)"Alte Labor Typ-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/LabResultID", (String)"Alte Labor Resultat-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/PatID", (String)"Alte KG-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/garantID", (String)"Alte Garant-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/LetterID", (String)"Alte Brief-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/DocumentID", (String)"Alte Dokument-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/FileID", (String)"Alte Datei-ID", (int)1);
    }

    @Override
    public List<IAeskulapImportFile> importFiles(List<IAeskulapImportFile> files, boolean overwrite, SubMonitor monitor) {
        ElexisEventDispatcher.getInstance().setBlockEventTypes(Arrays.asList(1, 2, 16, 32, 8, 4));
        this.transientFiles = new HashMap<IAeskulapImportFile.Type, IAeskulapImportFile>();
        ArrayList<IAeskulapImportFile> ret = new ArrayList<IAeskulapImportFile>();
        Map<IAeskulapImportFile.Type, List<IAeskulapImportFile>> typedMap = this.getTypedMap(files);
        for (IAeskulapImportFile.Type type : IAeskulapImportFile.Type.getSequenced()) {
            files = typedMap.get((Object)type);
            if (files == null) continue;
            for (IAeskulapImportFile iAeskulapImportFile : files) {
                boolean success = iAeskulapImportFile.doImport(this.transientFiles, overwrite, monitor.newChild(1));
                if (!success) {
                    ret.add(iAeskulapImportFile);
                    continue;
                }
                if (!iAeskulapImportFile.isTransient()) continue;
                this.transientFiles.put(iAeskulapImportFile.getType(), iAeskulapImportFile);
            }
        }
        ElexisEventDispatcher.getInstance().setBlockEventTypes(null);
        return ret;
    }

    private Map<IAeskulapImportFile.Type, List<IAeskulapImportFile>> getTypedMap(List<IAeskulapImportFile> files) {
        HashMap<IAeskulapImportFile.Type, List<IAeskulapImportFile>> ret = new HashMap<IAeskulapImportFile.Type, List<IAeskulapImportFile>>();
        for (IAeskulapImportFile iAeskulapImportFile : files) {
            ArrayList<IAeskulapImportFile> list = (ArrayList<IAeskulapImportFile>)ret.get((Object)iAeskulapImportFile.getType());
            if (list == null) {
                list = new ArrayList<IAeskulapImportFile>();
            }
            list.add(iAeskulapImportFile);
            ret.put(iAeskulapImportFile.getType(), list);
        }
        return ret;
    }

    @Override
    public void removePatientDuplicates(IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CSVWriter csvWriter = this.initCsvWriter();){
                IQuery xidQuery = CoreModelServiceHolder.get().getQuery(IXid.class);
                xidQuery.and((EStructuralFeature)ModelPackage.Literals.IXID__DOMAIN, IQuery.COMPARATOR.EQUALS, (Object)"elexis.ch/aeskulap_import/PatID");
                List importedXids = xidQuery.execute();
                monitor.beginTask("Patienten Duplikate entfernen", importedXids.size());
                for (IXid importedXid : importedXids) {
                    IPatient importedPatient = (IPatient)importedXid.getObject(IPatient.class);
                    if (importedPatient != null) {
                        IPatient existingPatient = this.findExistingPatient(importedPatient);
                        if (existingPatient != null) {
                            if (importedPatient.getCoverages().isEmpty()) {
                                this.transferImportedData(importedPatient, existingPatient);
                                existingPatient.addXid(importedXid.getDomain(), importedXid.getDomainId(), true);
                                CoreModelServiceHolder.get().delete((Deleteable)importedPatient);
                                csvWriter.writeNext(new String[]{importedPatient.getPatientNr(), existingPatient.getPatientNr(), "OK"});
                            } else {
                                csvWriter.writeNext(new String[]{importedPatient.getPatientNr(), existingPatient.getPatientNr(), "HASCOVERAGE"});
                            }
                        } else {
                            csvWriter.writeNext(new String[]{importedPatient.getPatientNr(), "", "NOEXISTING"});
                        }
                    }
                    monitor.worked(1);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error creating csv writer", (Throwable)e);
        }
    }

    private CSVWriter initCsvWriter() throws IOException {
        File file = new File(CoreUtil.getWritableUserDir(), "RemoveDuplicatePatients.csv");
        FileWriter fw = new FileWriter(file);
        CSVWriter csv = new CSVWriter((Writer)fw);
        String[] header = new String[]{"ImportPatNr", "ExistingPatNr", "Action"};
        csv.writeNext(header);
        return csv;
    }

    private void transferImportedData(IPatient importedPatient, IPatient existingPatient) {
        if (this.omnivoreModelService == null) {
            this.omnivoreModelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.omnivore.data.model)").get();
        }
        IQuery documentQuery = this.omnivoreModelService.getQuery(IDocumentHandle.class);
        documentQuery.and("kontakt", IQuery.COMPARATOR.EQUALS, (Object)importedPatient);
        List importedDocuments = documentQuery.execute();
        for (IDocumentHandle importedDocument : importedDocuments) {
            IDocument document = DocumentStoreServiceHolder.get().createDocument(existingPatient.getId(), importedDocument.getTitle(), importedDocument.getCategory().getName());
            document.setCreated(importedDocument.getCreated());
            document.setLastchanged(importedDocument.getLastchanged());
            document.setExtension(importedDocument.getExtension());
            document.setMimeType(importedDocument.getMimeType());
            try {
                Object object = null;
                Object var9_11 = null;
                try (InputStream fin = importedDocument.getContent();){
                    DocumentStoreServiceHolder.get().saveDocument(document, fin);
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (ElexisException | IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error transfer of document [" + importedDocument.getId() + "]", e);
            }
            importedDocument.setDeleted(true);
        }
        this.omnivoreModelService.save(importedDocuments);
        IQuery query = CoreModelServiceHolder.get().getQuery(ILabResult.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)importedPatient);
        List importedLaboratory = query.execute();
        for (ILabResult importedResult : importedLaboratory) {
            importedResult.setPatient(existingPatient);
        }
        CoreModelServiceHolder.get().save(importedLaboratory);
    }

    private IPatient findExistingPatient(IPatient importedPatient) {
        List patientsWithAhv;
        IXid importedAhv = importedPatient.getXid("www.ahv.ch/xid");
        if (importedAhv != null && StringUtils.isNotEmpty((CharSequence)importedAhv.getDomainId()) && (patientsWithAhv = XidServiceHolder.get().findObjects("www.ahv.ch/xid", importedAhv.getDomainId(), IPatient.class)).size() > 1) {
            return patientsWithAhv.stream().filter(p -> !p.getId().equals(importedPatient.getId())).findFirst().get();
        }
        IQuery query = CoreModelServiceHolder.get().getQuery(IPatient.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__FIRST_NAME, IQuery.COMPARATOR.EQUALS, (Object)importedPatient.getFirstName());
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__LAST_NAME, IQuery.COMPARATOR.EQUALS, (Object)importedPatient.getLastName());
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__DATE_OF_BIRTH, IQuery.COMPARATOR.EQUALS, (Object)importedPatient.getDateOfBirth().toLocalDate());
        query.and((EStructuralFeature)ModelPackage.Literals.IPERSON__GENDER, IQuery.COMPARATOR.EQUALS, (Object)importedPatient.getGender());
        List patientsMatching = query.execute();
        if (patientsMatching.size() > 1) {
            return patientsMatching.stream().filter(p -> !p.getId().equals(importedPatient.getId())).findFirst().get();
        }
        return null;
    }
}

