/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.estudio.clustertec;

import ch.clustertec.estudio.schemas.prescription.AddressComplexType;
import ch.clustertec.estudio.schemas.prescription.DeliveryAddress;
import ch.clustertec.estudio.schemas.prescription.Insurance;
import ch.clustertec.estudio.schemas.prescription.ObjectFactory;
import ch.clustertec.estudio.schemas.prescription.PatientAddress;
import ch.clustertec.estudio.schemas.prescription.Posology;
import ch.clustertec.estudio.schemas.prescription.Prescription;
import ch.clustertec.estudio.schemas.prescription.PrescriptorAddress;
import ch.clustertec.estudio.schemas.prescription.Product;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IXid;
import ch.elexis.core.types.Country;
import ch.elexis.core.types.Gender;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ClustertecPrescriptionFactory {
    private static final String DOMAIN_COVERCARD = "www.covercard.ch/xid";

    public static Prescription createPrescription(String user, String password) {
        Prescription ret = new ObjectFactory().createPrescription();
        ret.setUser(user);
        ret.setPassword(password);
        return ret;
    }

    public static PrescriptorAddress createPrescriptorAddress(String clientNrClustertec, IMandator mandator) {
        PrescriptorAddress ret = new ObjectFactory().createPrescriptorAddress();
        ClustertecPrescriptionFactory.setAddress(ret, (IContact)mandator);
        ret.setClientNrClustertec(clientNrClustertec);
        ret.setZsrId(ClustertecPrescriptionFactory.getZsrId(mandator));
        ret.setEanId(ClustertecPrescriptionFactory.getEanId((IContact)mandator));
        ret.setLangCode(1);
        return ret;
    }

    public static PatientAddress createPatientAddress(IPatient patient) {
        PatientAddress ret = new ObjectFactory().createPatientAddress();
        ClustertecPrescriptionFactory.setAddress(ret, (IContact)patient);
        if (patient.getDateOfBirth() != null) {
            ret.setBirthday(DateTimeFormatter.ofPattern("yyyy-MM-dd").format(patient.getDateOfBirth()));
        }
        ret.setLangCode(1);
        ret.setSex(patient.getGender() == Gender.MALE ? 1 : 2);
        ret.setPatientNr(patient.getCode());
        ret.setCoverCardId(ClustertecPrescriptionFactory.getCovercardId(patient));
        return ret;
    }

    public static DeliveryAddress createDeliveryAddress(IContact contact) {
        DeliveryAddress ret = new ObjectFactory().createDeliveryAddress();
        ClustertecPrescriptionFactory.setAddress(ret, contact);
        return ret;
    }

    public static Product createProduct(IPrescription prescription, Integer quantity, Integer numberOfRepetitions, LocalDate validityRepetition, IContact insurance, int billingType, String insuranceNumber) {
        Product ret = new ObjectFactory().createProduct();
        ret.setPharmacode(ClustertecPrescriptionFactory.getPharmaCode(prescription.getArticle()));
        ret.setEanId(ClustertecPrescriptionFactory.getEan(prescription.getArticle()));
        ret.setDescription(StringUtils.abbreviate((String)prescription.getArticle().getName(), (String)"", (int)49));
        String dosage = prescription.getDosageInstruction();
        Posology posology = new ObjectFactory().createPosology();
        posology.setLabel(false);
        if (StringUtils.isNotBlank((CharSequence)dosage)) {
            String[] dos = dosage.split("\\s*-\\s*");
            if (dos.length > 1) {
                if (ClustertecPrescriptionFactory.getInt(dos[0]).isPresent()) {
                    posology.setQtyMorning(ClustertecPrescriptionFactory.getInt(dos[0]).get());
                } else {
                    posology.setQtyMorningString(dos[0]);
                }
                if (ClustertecPrescriptionFactory.getInt(dos[1]).isPresent()) {
                    posology.setQtyMidday(ClustertecPrescriptionFactory.getInt(dos[1]).get());
                } else {
                    posology.setQtyMiddayString(dos[1]);
                }
                if (dos.length > 2) {
                    if (ClustertecPrescriptionFactory.getInt(dos[2]).isPresent()) {
                        posology.setQtyEvening(ClustertecPrescriptionFactory.getInt(dos[2]).get());
                    } else {
                        posology.setQtyEveningString(dos[2]);
                    }
                }
                if (dos.length > 3) {
                    if (ClustertecPrescriptionFactory.getInt(dos[3]).isPresent()) {
                        posology.setQtyNight(ClustertecPrescriptionFactory.getInt(dos[3]).get());
                    } else {
                        posology.setQtyNightString(dos[3]);
                    }
                }
            } else {
                posology.setPosologyText(dosage);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)prescription.getRemark())) {
            posology.setPosologyText(StringUtils.abbreviate((String)prescription.getRemark(), (String)"", (int)79));
            posology.setLabel(true);
        }
        if (quantity != null) {
            ret.setQuantity(quantity);
        }
        ret.setRepetition(false);
        if (numberOfRepetitions != null) {
            ret.setNrOfRepetitions(numberOfRepetitions);
            ret.setRepetition(numberOfRepetitions > 0);
        }
        if (validityRepetition != null) {
            ret.setValidityRepetition(DateTimeFormatter.ofPattern("yyyy-MM-dd").format(validityRepetition));
            ret.setRepetition(true);
        }
        Insurance clustertecInsurance = new ObjectFactory().createInsurance();
        if (insurance != null) {
            clustertecInsurance.setEanId(ClustertecPrescriptionFactory.getEanId(insurance));
            clustertecInsurance.setInsuranceName(StringUtils.abbreviate((String)insurance.getLabel(), (String)"", (int)30));
            clustertecInsurance.setBillingType(billingType);
            clustertecInsurance.setInsureeNr(insuranceNumber);
        } else {
            clustertecInsurance.setBillingType(2);
        }
        ret.setInsurance(clustertecInsurance);
        return ret;
    }

    private static Optional<Integer> getInt(String string) {
        try {
            return Optional.of(Integer.valueOf(string));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private static String getCovercardId(IPatient patient) {
        IXid patientCovercard = patient.getXid(DOMAIN_COVERCARD);
        if (patientCovercard != null && patientCovercard.getDomainId() != null && !patientCovercard.getDomainId().isEmpty()) {
            return patientCovercard.getDomainId().trim();
        }
        return null;
    }

    private static Long getEanId(IContact contact) {
        IXid mandatorEan = contact.getXid("www.xid.ch/id/ean");
        if (mandatorEan != null && mandatorEan.getDomainId() != null && !mandatorEan.getDomainId().isEmpty()) {
            return Long.valueOf(mandatorEan.getDomainId().trim());
        }
        return null;
    }

    private static String getZsrId(IMandator mandator) {
        IXid mandantZSR = mandator.getXid("www.xid.ch/id/ksk");
        if (mandantZSR != null && mandantZSR.getDomainId() != null) {
            return mandantZSR.getDomainId().replaceAll("[\\s\\.\\-]", "").trim();
        }
        return null;
    }

    private static void setAddress(AddressComplexType ret, IContact contact) {
        if (contact.isPerson()) {
            IPerson person = contact.asIPerson();
            ret.setTitleCode(person.getGender() == Gender.MALE ? 1 : 2);
            ret.setTitle(person.getTitel());
        } else {
            ret.setTitle("Firma");
            ret.setTitleCode(0);
        }
        ret.setLastName(contact.getDescription1());
        ret.setFirstName(contact.getDescription2());
        ret.setStreet(contact.getStreet());
        ret.setZipCode(contact.getZip());
        ret.setCity(contact.getCity());
        ret.setKanton("ch");
        Country country = contact.getCountry();
        if (Country.NDF == country) {
            country = Country.CH;
        }
        ret.setCountry(StringUtils.abbreviate((String)country.toString(), (String)"", (int)2));
        ret.setPhoneNrBusiness(contact.getPhone1());
        ret.setPhoneNrHome(contact.getPhone2());
        ret.setFaxNr(contact.getFax());
        ret.setEmail(contact.getEmail());
    }

    private static Long getEan(IArticle article) {
        Object value;
        String ret = article.getGtin();
        if (StringUtils.isBlank((CharSequence)ret) && (value = article.getExtInfo((Object)"EAN")) instanceof String && ((String)value).length() > 11) {
            return Long.valueOf((String)value);
        }
        return null;
    }

    private static String getPharmaCode(IArticle article) {
        Object value;
        String ret = "";
        try {
            Method method = article.getClass().getMethod("getPHAR", new Class[0]);
            ret = (String)method.invoke((Object)article, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException method) {
            // empty catch block
        }
        if (StringUtils.isBlank((CharSequence)ret) && (value = article.getExtInfo((Object)"Pharmacode")) instanceof String && ((String)value).length() == 7) {
            ret = (String)value;
        }
        return StringUtils.leftPad((String)StringUtils.defaultString((String)ret), (int)7, (String)"0");
    }
}

