/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.base.ch.arzttarife.importer.TrustCenters;
import ch.elexis.base.ch.arzttarife.rfe.IReasonForEncounter;
import ch.elexis.base.ch.arzttarife.service.ArzttarifeModelServiceHolder;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.model.format.PostalAddress;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.types.Country;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Verifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLExporterUtil {
    private static Logger logger = LoggerFactory.getLogger(XMLExporterUtil.class);
    private static final String ELEMENT_EMAIL = "email";
    private static final String ELEMENT_ONLINE = "online";

    public static Element buildRechnungsstellerAdressElement(IContact k) {
        return XMLExporterUtil.buildAdressElement(k, false, true);
    }

    public static Element buildAdressElement(IContact contact) {
        return XMLExporterUtil.buildAdressElement(contact, false, false);
    }

    public static Element buildAdressElement(IContact contact, boolean useAnschrift) {
        return XMLExporterUtil.buildAdressElement(contact, useAnschrift, false);
    }

    public static Element buildAdressElement(IContact contact, boolean useAnschrift, boolean checkAnrede) {
        Element ret;
        boolean anredeOrganization = false;
        if (checkAnrede) {
            String anrede = (String)contact.getExtInfo((Object)"Anrede");
            boolean bl = anredeOrganization = anrede == null || anrede.isEmpty();
        }
        if (!contact.isPerson() || anredeOrganization) {
            Element onlineElement;
            ret = new Element("company", XMLExporter.nsinvoice);
            Element companyname = new Element("companyname", XMLExporter.nsinvoice);
            companyname.setText(StringTool.limitLength((String)contact.getDescription1(), (int)35));
            ret.addContent((Content)companyname);
            ret.addContent((Content)XMLExporterUtil.buildPostalElement(contact));
            Element telcom = XMLExporterUtil.buildTelekomElement(contact);
            if (telcom != null && !telcom.getChildren().isEmpty()) {
                ret.addContent((Content)telcom);
            }
            if ((onlineElement = XMLExporterUtil.buildOnlineElement(contact)) != null) {
                ret.addContent((Content)onlineElement);
            }
        } else {
            Element onlineElement;
            ret = new Element("person", XMLExporter.nsinvoice);
            Element familyname = new Element("familyname", XMLExporter.nsinvoice);
            Element givenname = new Element("givenname", XMLExporter.nsinvoice);
            if (!useAnschrift) {
                XMLExporterUtil.setAttributeIfNotEmptyWithLimit(ret, "salutation", (String)contact.getExtInfo((Object)"Anrede"), 35);
                if (contact.isPerson()) {
                    IPerson person = (IPerson)CoreModelServiceHolder.get().load(contact.getId(), IPerson.class).get();
                    XMLExporterUtil.setAttributeIfNotEmptyWithLimit(ret, "title", person.getTitel(), 35);
                    if (StringUtils.isEmpty((CharSequence)((String)contact.getExtInfo((Object)"Anrede")))) {
                        XMLExporterUtil.setAttributeIfNotEmptyWithLimit(ret, "salutation", PersonFormatUtil.getSalutation((IPerson)person), 35);
                    }
                }
                familyname.setText(StringTool.limitLength((String)contact.getDescription1(), (int)35));
                String gn = StringTool.limitLength((String)contact.getDescription2(), (int)35);
                if (StringTool.isNothing((Object)gn)) {
                    gn = "Unbekannt";
                }
                givenname.setText(gn);
                ret.addContent((Content)familyname);
                ret.addContent((Content)givenname);
                ret.addContent((Content)XMLExporterUtil.buildPostalElement(contact));
            } else {
                PostalAddress postAnschrift = PostalAddress.ofText((String)contact.getPostalAddress());
                familyname.setText(StringTool.limitLength((String)postAnschrift.getLastName(), (int)35));
                givenname.setText(StringTool.limitLength((String)postAnschrift.getFirstName(), (int)35));
                XMLExporterUtil.setAttributeIfNotEmptyWithLimit(ret, "salutation", postAnschrift.getSalutation(), 35);
                ret.addContent((Content)familyname);
                ret.addContent((Content)givenname);
                ret.addContent((Content)XMLExporterUtil.buildPostalElement(postAnschrift));
            }
            Element telcom = XMLExporterUtil.buildTelekomElement(contact);
            if (telcom != null && !telcom.getChildren().isEmpty()) {
                ret.addContent((Content)telcom);
            }
            if ((onlineElement = XMLExporterUtil.buildOnlineElement(contact)) != null) {
                ret.addContent((Content)onlineElement);
            }
        }
        return ret;
    }

    public static Element buildPostalElement(IContact contact) {
        Element ret = new Element("postal", XMLExporter.nsinvoice);
        XMLExporterUtil.addElementIfExists(ret, "pobox", null, StringTool.limitLength((String)((String)contact.getExtInfo((Object)"Postfach")), (int)35), null);
        XMLExporterUtil.addElementIfExists(ret, "street", null, StringTool.limitLength((String)contact.getStreet(), (int)35), null);
        Element zip = XMLExporterUtil.addElementIfExists(ret, "zip", null, StringTool.limitLength((String)contact.getZip(), (int)9), "0000");
        Country country = contact.getCountry();
        if (Country.NDF == country) {
            logger.info("IContact [] Country not set, defaulting to CH", (Object)contact.getId());
            country = Country.CH;
        }
        XMLExporterUtil.setAttributeIfNotEmpty(zip, "countrycode", StringTool.limitLength((String)country.toString(), (int)3));
        XMLExporterUtil.addElementIfExists(ret, "city", null, StringTool.limitLength((String)contact.getCity(), (int)35), Messages.XMLExporter_Unknown);
        return ret;
    }

    public static Element buildPostalElement(PostalAddress postalAddress) {
        Element ret = new Element("postal", XMLExporter.nsinvoice);
        XMLExporterUtil.addElementIfExists(ret, "pobox", null, StringTool.limitLength((String)postalAddress.getAddress2(), (int)35), null);
        XMLExporterUtil.addElementIfExists(ret, "street", null, StringTool.limitLength((String)postalAddress.getAddress1(), (int)35), null);
        Element zip = XMLExporterUtil.addElementIfExists(ret, "zip", null, StringTool.limitLength((String)postalAddress.getZip(), (int)9), "0000");
        XMLExporterUtil.setAttributeIfNotEmpty(zip, "countrycode", StringTool.limitLength((String)postalAddress.getCountry(), (int)3));
        XMLExporterUtil.addElementIfExists(ret, "city", null, StringTool.limitLength((String)postalAddress.getCity(), (int)35), Messages.XMLExporter_unknown);
        return ret;
    }

    public static Element buildOnlineElement(IContact k) {
        Element ret = null;
        String value = XMLExporterUtil.getValidXMLString(StringTool.limitLength((String)k.getEmail(), (int)70));
        if (!value.equals("")) {
            if (!value.matches(".+@.+")) {
                value = "mail@invalid.invalid";
            }
            if (ret == null) {
                ret = new Element(ELEMENT_ONLINE, XMLExporter.nsinvoice);
            }
            XMLExporterUtil.addElementIfExists(ret, ELEMENT_EMAIL, null, value, null);
        }
        if (!(value = XMLExporterUtil.getValidXMLString(StringTool.limitLength((String)k.getWebsite(), (int)100))).equals("")) {
            if (ret == null) {
                ret = new Element(ELEMENT_ONLINE, XMLExporter.nsinvoice);
                XMLExporterUtil.addElementIfExists(ret, ELEMENT_EMAIL, null, "mail@invalid.invalid", null);
            }
            XMLExporterUtil.addElementIfExists(ret, "url", null, value, null);
        }
        return ret;
    }

    public static Element buildTelekomElement(IContact k) {
        Element ret = new Element("telecom", XMLExporter.nsinvoice);
        Element phoneElement = XMLExporterUtil.addElementIfExists(ret, "phone", null, StringTool.limitLength((String)k.getPhone1(), (int)25), null);
        if (phoneElement != null) {
            XMLExporterUtil.addElementIfExists(ret, "fax", null, StringTool.limitLength((String)k.getFax(), (int)25), null);
        }
        return ret;
    }

    public static boolean setAttributeIfNotEmpty(Element element, String name, String value) {
        if (element == null) {
            return false;
        }
        if (StringTool.isNothing((Object)name)) {
            return false;
        }
        if (StringTool.isNothing((Object)value)) {
            return false;
        }
        element.setAttribute(name, value);
        return true;
    }

    public static boolean setAttributeIfNotEmptyWithLimit(Element element, String name, String value, int len) {
        if (value != null && value.length() >= len) {
            value = value.substring(0, len - 1);
        }
        return XMLExporterUtil.setAttributeIfNotEmpty(element, name, value);
    }

    public static String makeTarmedDatum(String datum) {
        return new TimeTool(datum).toString(6) + "T00:00:00";
    }

    public static String makeTarmedDatum(LocalDate datum) {
        return datum.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "T00:00:00";
    }

    private static Element addElementIfExists(Element parent, String name, String attr, String val, String defValue) {
        if (StringTool.isNothing((Object)val)) {
            val = defValue;
        }
        if (!StringTool.isNothing((Object)val)) {
            Element ret = new Element(name, XMLExporter.nsinvoice);
            if (attr == null) {
                ret.setText(val.replaceAll("\u001f", ""));
            } else {
                ret.setAttribute(attr, val);
            }
            parent.addContent((Content)ret);
            return ret;
        }
        return null;
    }

    public static void setAttributeWithDefault(Element element, String name, String value, String def) {
        if (element != null && !StringTool.isNothing((Object)name)) {
            if (StringTool.isNothing((Object)value)) {
                value = def;
            }
            element.setAttribute(name, value);
        }
    }

    public static void setVatAttribute(IBilled billed, Money amount, Element el, XMLExporter.VatRateSum vatsum) {
        double value = 0.0;
        String vatScale = (String)billed.getExtInfo((Object)"vat_scale");
        if (vatScale != null && vatScale.length() > 0) {
            value = Double.parseDouble(vatScale);
        }
        el.setAttribute("vat_rate", Double.toString(value));
        vatsum.add(value, amount.doubleValue());
    }

    public static String getResponsibleEAN(IEncounter encounter) {
        IContact rechnungssteller;
        String anrede;
        Object responsibleKontakt = null;
        String responsibleId = (String)encounter.getMandator().getExtInfo((Object)"ch.elexis.tarmedprefs.responsible");
        responsibleKontakt = responsibleId != null && !responsibleId.isEmpty() ? (IContact)CoreModelServiceHolder.get().load(responsibleId, IMandator.class).orElse(null) : ((anrede = (String)(rechnungssteller = encounter.getMandator().getBiller()).getExtInfo((Object)"Anrede")) != null && !anrede.isEmpty() ? rechnungssteller : encounter.getMandator());
        return TarmedRequirements.getEAN(responsibleKontakt);
    }

    public static void negate(Element el, String attr) {
        Object v = el.getAttributeValue(attr);
        if (!StringTool.isNothing((Object)v) && !((String)v).equals("0.00")) {
            v = ((String)v).startsWith("-") ? ((String)v).substring(1) : "-" + (String)v;
            el.setAttribute(attr, (String)v);
        }
    }

    public static String getValidXMLString(String source) {
        StringBuilder ret = new StringBuilder();
        int i = 0;
        int len = source.length();
        while (i < len) {
            if (Verifier.isXMLCharacter((int)source.charAt(i))) {
                ret.append(source.charAt(i));
            }
            ++i;
        }
        return ret.toString();
    }

    public static String getIntermediateEAN(IInvoice invoice) {
        String trustCenter;
        String kEAN = XMLExporterUtil.getCostBearerEAN(invoice);
        String rEAN = XMLExporterUtil.getRecipientEAN(invoice);
        String iEAN = TarmedRequirements.getIntermediateEAN(invoice.getCoverage());
        if (iEAN.length() == 0 && TarmedRequirements.hasTCContract((IContact)invoice.getMandator()) && (trustCenter = TarmedRequirements.getTCName((IContact)invoice.getMandator())) != null && trustCenter.length() > 0) {
            iEAN = TrustCenters.getTCEAN(trustCenter);
        }
        logger.info("Intermediate EAN [" + iEAN + "]");
        if (StringTool.isNothing((Object)iEAN)) {
            iEAN = !rEAN.matches("(20[0-9]{11}|76[0-9]{11})") ? (kEAN.matches("(20[0-9]{11}|76[0-9]{11})") ? kEAN : "2000000000000") : rEAN;
        }
        return iEAN;
    }

    private static IContact getCostBearer(ICoverage invoiceCoverage) {
        IContact kostentraeger = invoiceCoverage.getCostBearer();
        if (kostentraeger == null) {
            kostentraeger = invoiceCoverage.getPatient();
        }
        return kostentraeger;
    }

    public static String getRecipientEAN(IInvoice invoice) {
        String rEAN = TarmedRequirements.getRecipientEAN(XMLExporterUtil.getCostBearer(invoice.getCoverage()));
        logger.info("Recipient EAN [" + rEAN + "]");
        if (rEAN.equals("unknown")) {
            rEAN = XMLExporterUtil.getCostBearerEAN(invoice);
        }
        return rEAN;
    }

    public static String getCostBearerEAN(IInvoice invoice) {
        String kEAN = TarmedRequirements.getEAN(XMLExporterUtil.getCostBearer(invoice.getCoverage()));
        logger.info("Costbearer EAN [" + kEAN + "]");
        return kEAN;
    }

    public static XMLGregorianCalendar makeXMLDate(TimeTool date) throws DatatypeConfigurationException {
        if (date != null) {
            return XMLExporterUtil.makeXMLDate(date.toLocalDate());
        }
        return null;
    }

    public static XMLGregorianCalendar makeXMLDate(LocalDate date) throws DatatypeConfigurationException {
        ZonedDateTime zonedDateTime = date.atStartOfDay().atZone(ZoneId.systemDefault());
        GregorianCalendar gregorianCalendar = GregorianCalendar.from(zonedDateTime);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
    }

    public static XMLGregorianCalendar makeXMLDateTime(LocalDateTime dateTime) throws DatatypeConfigurationException {
        ZonedDateTime zonedDateTime = dateTime.atZone(ZoneId.systemDefault());
        GregorianCalendar gregorianCalendar = GregorianCalendar.from(zonedDateTime);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
    }

    public static XMLGregorianCalendar makeTarmedDate(String dateString) throws DatatypeConfigurationException {
        TimeTool timetool = new TimeTool(dateString);
        GregorianCalendar gregorianCalendar = GregorianCalendar.from(timetool.toZonedDateTime());
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
    }

    public static LocalDate getAsLocalDate(XMLGregorianCalendar xmlDate) {
        return LocalDate.of(xmlDate.getYear(), xmlDate.getMonth(), xmlDate.getDay());
    }

    public static Optional<Double> getALScalingFactor(IBilled billed) {
        String scalingFactor = (String)billed.getExtInfo((Object)"AL_SCALINGFACTOR");
        if (scalingFactor != null && !scalingFactor.isEmpty()) {
            try {
                return Optional.of(Double.parseDouble(scalingFactor));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static Optional<Double> getALNotScaled(IBilled billed) {
        String notScaled = (String)billed.getExtInfo((Object)"AL_NOTSCALED");
        if (notScaled != null && !notScaled.isEmpty()) {
            try {
                return Optional.of(Double.parseDouble(notScaled));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static List<IReasonForEncounter> getReasonsForEncounter(IEncounter encounter) {
        IQuery query = ArzttarifeModelServiceHolder.get().getQuery(IReasonForEncounter.class);
        query.and("konsID", IQuery.COMPARATOR.EQUALS, (Object)encounter.getId());
        return query.execute();
    }

    public static IContact getGuarantor(String paymentMode, IPatient patient, ICoverage coverage) {
        IContact legalGuardian;
        IContact invoiceReceiver;
        if (paymentMode.equals("TP")) {
            IContact legalGuardian2 = patient.getLegalGuardian();
            if (legalGuardian2 != null) {
                return legalGuardian2;
            }
            return patient;
        }
        Object ret = paymentMode.equals("TG") ? ((invoiceReceiver = coverage.getGuarantor()).equals(patient) ? ((legalGuardian = patient.getLegalGuardian()) != null ? legalGuardian : patient) : invoiceReceiver) : coverage.getGuarantor();
        ret.getPostalAddress();
        return ret;
    }

    public static void addSSNAttribute(Element element, IPatient actPatient, ICoverage coverage, IInvoice invoice, boolean isOptional) {
        String ahv = TarmedRequirements.getAHV((IPerson)actPatient).replaceAll("[^0-9]", "");
        if (ahv.length() == 0) {
            ahv = CoverageServiceHolder.get().getRequiredString(coverage, TarmedRequirements.SSN).replaceAll("[^0-9]", "");
        }
        boolean ahvValid = ahv.matches("[0-9]{4,10}|[1-9][0-9]{10}|756[0-9]{10}|438[0-9]{10}");
        if (!isOptional && ConfigServiceHolder.getUser((String)"billing/strict", (boolean)true) && !ahvValid) {
            invoice.reject(InvoiceState.REJECTCODE.VALIDATION_ERROR, Messages.XMLExporter_AHVInvalid);
            CoreModelServiceHolder.get().save((Identifiable)invoice);
        } else if (ahvValid) {
            element.setAttribute("ssn", ahv);
        }
    }

    public static List<String> splitStringEqually(String text, int size) {
        ArrayList<String> ret = new ArrayList<String>((text.length() + size - 1) / size);
        int start = 0;
        while (start < text.length()) {
            ret.add(text.substring(start, Math.min(text.length(), start + size)));
            start += size;
        }
        return ret;
    }
}

