/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmed.model.importer;

import ch.elexis.base.ch.arzttarife.tarmed.model.importer.EntityUtil;
import ch.elexis.base.ch.arzttarife.tarmed.model.importer.ServiceImporter;
import ch.elexis.core.jpa.entities.TarmedKumulation;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockImporter {
    private static final Logger logger = LoggerFactory.getLogger(ServiceImporter.class);
    private JdbcLink cacheDb;
    private String lang;
    private String law;

    public BlockImporter(JdbcLink cacheDb, String lang, String law) {
        this.cacheDb = cacheDb;
        this.lang = lang;
        this.law = law;
    }

    public IStatus doImport(IProgressMonitor ipm) throws SQLException, IOException {
        JdbcLink.Stm servicesStm = null;
        try {
            ipm.subTask("Importiere Bl\u00f6cke");
            servicesStm = this.cacheDb.getStatement();
            ResultSet res = servicesStm.query(String.format("SELECT DISTINCT BLOCK FROM %sLEISTUNG_BLOECKE", "TARMED_IMPORT_"));
            while (res.next()) {
                String blockName = res.getString("BLOCK");
                this.importKumulations(blockName);
                logger.debug("Imported block " + blockName);
            }
        }
        finally {
            if (servicesStm != null) {
                this.cacheDb.releaseStatement(servicesStm);
            }
        }
        return Status.OK_STATUS;
    }

    private void importKumulations(String blockName) throws SQLException {
        JdbcLink.Stm subStm = this.cacheDb.getStatement();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (ResultSet res = subStm.query(String.format("SELECT * FROM %sLEISTUNG_KUMULATION WHERE LNR_MASTER='%s' AND ART_MASTER='B'", "TARMED_IMPORT_", blockName));){
                TimeTool fromTime = new TimeTool();
                TimeTool toTime = new TimeTool();
                ArrayList<Object> kumulations = new ArrayList<Object>();
                while (res != null && res.next()) {
                    fromTime.set(res.getString("GUELTIG_VON"));
                    toTime.set(res.getString("GUELTIG_BIS"));
                    TarmedKumulation kumulation = new TarmedKumulation();
                    kumulation.setMasterCode(blockName);
                    kumulation.setMasterArt(res.getString("ART_MASTER"));
                    kumulation.setSlaveCode(res.getString("LNR_SLAVE"));
                    kumulation.setSlaveArt(res.getString("ART_SLAVE"));
                    kumulation.setTyp(res.getString("TYP"));
                    kumulation.setView(res.getString("ANZEIGE"));
                    kumulation.setValidSide(res.getString("GUELTIG_SEITE"));
                    kumulation.setValidFrom(fromTime.toLocalDate());
                    kumulation.setValidTo(toTime.toLocalDate());
                    kumulation.setLaw(this.law);
                    kumulations.add(kumulation);
                }
                EntityUtil.save(kumulations);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (subStm != null) {
                this.cacheDb.releaseStatement(subStm);
            }
        }
    }
}

