/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.dialogs;

import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.text.AgendaTextTemplateRequirement;
import ch.elexis.agenda.util.Plannables;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.rgw.tools.TimeTool;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TermineDruckenDialog
extends TitleAreaDialog
implements ITextPlugin.ICallback {
    Termin[] liste;
    private TextContainer text = null;

    public TermineDruckenDialog(Shell shell, List<IAppointment> appointments) {
        this(shell, appointments.stream().map(a -> (Termin)NoPoUtil.loadAsPersistentObject((Identifiable)a)).toList().toArray(new Termin[appointments.size()]));
    }

    public TermineDruckenDialog(Shell shell, Termin[] liste) {
        super(shell);
        this.liste = liste;
        Arrays.sort(this.liste, new Comparator<Termin>(){
            private TimeTool lDay = new TimeTool();
            private TimeTool rDay = new TimeTool();

            @Override
            public int compare(Termin l, Termin r) {
                int dayRes = 0;
                if (l.getDay() != null && l.getDay().length() > 3 && r.getDay() != null && r.getDay().length() > 3) {
                    this.lDay.set(l.getDay());
                    this.rDay.set(r.getDay());
                    dayRes = this.lDay.compareTo((Calendar)this.rDay);
                }
                if (dayRes == 0) {
                    return Integer.compare(l.getStartMinute(), r.getStartMinute());
                }
                return dayRes;
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new FillLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.text = new TextContainer(this.getShell());
        this.text.getPlugin().createContainer(ret, (ITextPlugin.ICallback)this);
        this.text.getPlugin().showMenu(true);
        this.text.getPlugin().showToolbar(true);
        this.text.createFromTemplateName(null, AgendaTextTemplateRequirement.TT_APPOINTMENT_CARD, "Allg.", (Kontakt)CoreHub.getLoggedInContact(), "Agenda");
        StringBuilder sb = new StringBuilder();
        Termin[] terminArray = this.liste;
        int n = this.liste.length;
        int n2 = 0;
        while (n2 < n) {
            Termin t = terminArray[n2];
            TimeTool day = new TimeTool(t.getDay());
            sb.append(day.toString(12)).append(", ").append(day.toString(4)).append(" - ").append(Plannables.getStartTimeAsString(t)).append("\n");
            ++n2;
        }
        this.text.replace("\\[Termine\\]", sb.toString());
        if (this.text.getPlugin().isDirectOutput()) {
            this.text.getPlugin().print(null, null, true);
            this.okPressed();
        }
        return ret;
    }

    public void create() {
        super.create();
        this.setMessage("Terminliste ausdrucken");
        this.setTitle("Terminliste");
        this.getShell().setText("Agenda");
        this.getShell().setSize(800, 700);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public void save() {
    }

    public boolean saveAs() {
        return false;
    }

    public boolean doPrint() {
        if (this.text == null) {
            return false;
        }
        String printer = CoreHub.localCfg.get("agenda/print/appointmentcard_printer_name", "");
        String tray = CoreHub.localCfg.get("agenda/print/appointmentcard_printer_tray", null);
        return this.text.getPlugin().print(printer, tray, false);
    }
}

