/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.dialogs;

import ch.elexis.agenda.Messages;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.time.TimeUtil;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class AppointmentLinkOptionsDialog {
    public static MoveActionType showMoveDialog(Shell shell, List<IAppointment> linkedAppointments) {
        StringBuilder message = new StringBuilder(Messages.AppointmentLinkOptionsDialogDescription);
        message.append(Messages.AppointmentLinkOptionsDialogTitel);
        AppointmentLinkOptionsDialog.appendAppointmentDetails(message, linkedAppointments);
        String[] options = new String[]{Messages.AppointmentLinkOptionsDialogMainAppointmentButton, Messages.AppointmentLinkOptionsDialogAllButton, Messages.AppointmentLinkOptionsDialogAbortButton};
        MessageDialog dialog = new MessageDialog(shell, Messages.AppointmentLinkOptionsDialogMove, null, message.toString(), 3, options, 0);
        int result = dialog.open();
        return AppointmentLinkOptionsDialog.getMoveActionType(result);
    }

    public static CopyActionType showCopyDialog(Shell shell, List<IAppointment> linkedAppointments) {
        StringBuilder message = new StringBuilder(Messages.AppointmentLinkOptionsDialogDescription);
        message.append(Messages.AppointmentLinkOptionsDialogTitel);
        AppointmentLinkOptionsDialog.appendAppointmentDetails(message, linkedAppointments);
        String[] options = new String[]{Messages.AppointmentLinkOptionsDialogMainAppointmentButton, Messages.AppointmentLinkOptionsDialogAllButton, Messages.AppointmentLinkOptionsDialogAbortButton};
        MessageDialog dialog = new MessageDialog(shell, Messages.AppointmentLinkOptionsDialogCopy, null, message.toString(), 3, options, 0);
        int result = dialog.open();
        return AppointmentLinkOptionsDialog.getCopyActionType(result);
    }

    public static DeleteActionType showDeleteDialog(Shell shell, List<IAppointment> linkedAppointments) {
        StringBuilder message = new StringBuilder(Messages.AppointmentLinkOptionsDialogDescription);
        message.append(Messages.AppointmentLinkOptionsDialogTitel);
        AppointmentLinkOptionsDialog.appendAppointmentDetails(message, linkedAppointments);
        String[] options = new String[]{Messages.AppointmentLinkOptionsDialogKeepButton, Messages.AppointmentLinkOptionsDialogDeleteButton};
        MessageDialog dialog = new MessageDialog(shell, Messages.AppointmentLinkOptionsDialogDelete, null, message.toString(), 3, options, 0);
        int result = dialog.open();
        return AppointmentLinkOptionsDialog.getDeleteActionType(result);
    }

    private static void appendAppointmentDetails(StringBuilder message, List<IAppointment> appointments) {
        for (IAppointment appt : appointments) {
            message.append(String.format("- %s, %s, %s\n", appt.getStartTime().format(TimeUtil.FULL_GER), appt.getSchedule(), appt.getType()));
        }
    }

    private static MoveActionType getMoveActionType(int result) {
        if (result == -1 || result == 2) {
            return MoveActionType.CANCEL;
        }
        if (result == 0) {
            return MoveActionType.KEEP_MAIN_ONLY;
        }
        if (result == 1) {
            return MoveActionType.MOVE_ALL;
        }
        return MoveActionType.CANCEL;
    }

    private static CopyActionType getCopyActionType(int result) {
        if (result == -1) {
            return CopyActionType.CANCEL;
        }
        return result == 0 ? CopyActionType.KEEP_MAIN_ONLY : CopyActionType.COPY_ALL;
    }

    private static DeleteActionType getDeleteActionType(int result) {
        if (result == -1) {
            return null;
        }
        return result == 0 ? DeleteActionType.KEEP_LINKS : DeleteActionType.DELETE_ALL;
    }

    public static enum CopyActionType {
        KEEP_MAIN_ONLY,
        COPY_ALL,
        CANCEL;

    }

    public static enum DeleteActionType {
        KEEP_LINKS,
        DELETE_ALL;

    }

    public static enum MoveActionType {
        KEEP_MAIN_ONLY,
        MOVE_ALL,
        CANCEL;

    }
}

