/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.agenda.ui.provider;

import ch.elexis.agenda.data.Termin;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import java.time.format.TextStyle;
import java.util.Locale;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TermineLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof Termin) {
            Termin termin = (Termin)element;
            StringBuilder sbLabel = new StringBuilder();
            TimeSpan ts = termin.getTimeSpan();
            TimeTool tt = new TimeTool();
            tt.setDate(termin.getDay());
            sbLabel.append(tt.toString(4));
            String dayShort = tt.toLocalDate().getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.getDefault());
            if (dayShort != null) {
                sbLabel.append(" (" + dayShort + ")");
            }
            sbLabel.append(", ");
            tt.setTime(ts.from);
            sbLabel.append(tt.toString(3));
            sbLabel.append(" - ");
            tt.setTime(ts.until);
            sbLabel.append(tt.toString(3));
            sbLabel.append(" (");
            sbLabel.append(termin.getType());
            sbLabel.append(", ");
            sbLabel.append(termin.getStatus());
            sbLabel.append("), ");
            sbLabel.append(termin.getBereich());
            if (termin.getGrund() != null && !termin.getGrund().isEmpty()) {
                sbLabel.append(" (");
                sbLabel.append(termin.getGrund());
                sbLabel.append(")");
            }
            return sbLabel.toString();
        }
        return element.toString();
    }
}

