/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.impfplan.ui.handlers;

import at.medevit.elexis.impfplan.ui.VaccinationComposite;
import at.medevit.elexis.impfplan.ui.VaccinationCompositePaintListener;
import at.medevit.elexis.impfplan.ui.VaccinationView;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Person;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class PrintVaccinationEntriesHandler
extends AbstractHandler {
    private SimpleDateFormat sdf = new SimpleDateFormat("dd.MMMM yyyy");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Patient patient = ElexisEventDispatcher.getSelectedPatient();
        VaccinationView vaccView = (VaccinationView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("at.medevit.elexis.impfplan.ui.ImpfplanViewPart");
        VaccinationComposite vaccinationComposite = vaccView.getVaccinationComposite();
        VaccinationCompositePaintListener vcpl = vaccinationComposite.getVaccinationCompositePaintListener();
        int dim = 800;
        Rectangle a4Rectangle = new Rectangle(0, 0, 800, 1128);
        Display display = vaccinationComposite.getDisplay();
        ArrayList<Image> images = new ArrayList<Image>();
        int i = 0;
        while (i < vcpl.getPageTotalSize()) {
            Image image = new Image((Device)display, a4Rectangle);
            GC gc = new GC((Drawable)image);
            vcpl.paintControl(gc, display, a4Rectangle.width, a4Rectangle.height, true, i);
            images.add(image);
            gc.dispose();
            ++i;
        }
        try {
            this.createPDF(patient, images);
            images.clear();
        }
        catch (IOException e) {
            MessageEvent.fireError((String)"Fehler beim Erstellen des PDF", (String)e.getMessage(), (Exception)e);
        }
        vcpl.restorePrePrintSettting();
        return null;
    }

    private void createPDF(Patient patient, List<Image> images) throws IOException {
        PDDocumentInformation pdi = new PDDocumentInformation();
        Mandant mandant = (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
        pdi.setAuthor(mandant.getName() + " " + mandant.getVorname());
        pdi.setCreationDate((Calendar)new GregorianCalendar());
        pdi.setTitle("Impfausweis " + patient.getLabel());
        PDDocument document = new PDDocument();
        document.setDocumentInformation(pdi);
        int i = 0;
        for (Image image : images) {
            ++i;
            PDPage page = new PDPage();
            page.setMediaBox(PDRectangle.A4);
            document.addPage(page);
            PDRectangle pageSize = page.getMediaBox();
            PDType1Font font = PDType1Font.HELVETICA_BOLD;
            PDType1Font subFont = PDType1Font.HELVETICA;
            PDPageContentStream contentStream = new PDPageContentStream(document, page);
            contentStream.beginText();
            contentStream.setFont((PDFont)font, 14.0f);
            contentStream.moveTextPositionByAmount(40.0f, pageSize.getUpperRightY() - 40.0f);
            contentStream.drawString(patient.getLabel());
            contentStream.endText();
            String dateLabel = this.sdf.format(Calendar.getInstance().getTime());
            String title = Person.load((String)mandant.getId()).get("Titel");
            String mandantLabel = title + " " + mandant.getName() + " " + mandant.getVorname();
            contentStream.beginText();
            contentStream.setFont((PDFont)subFont, 10.0f);
            contentStream.moveTextPositionByAmount(40.0f, pageSize.getUpperRightY() - 55.0f);
            contentStream.drawString("Ausstellung " + dateLabel + ", " + mandantLabel);
            contentStream.endText();
            BufferedImage imageAwt = PrintVaccinationEntriesHandler.convertToAWT(image.getImageData());
            PDImageXObject pdPixelMap = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)imageAwt);
            contentStream.drawXObject((PDXObject)pdPixelMap, 40.0f, 30.0f, pageSize.getWidth() - 80.0f, pageSize.getHeight() - 100.0f);
            contentStream.beginText();
            contentStream.setFont((PDFont)subFont, 8.0f);
            contentStream.moveTextPositionByAmount(PDRectangle.A4.getUpperRightX() / 2.0f - 20.0f, PDRectangle.A4.getLowerLeftY() + 15.0f);
            contentStream.drawString("Seite " + i + " von " + images.size());
            contentStream.endText();
            contentStream.close();
        }
        String outputPath = ConfigServiceHolder.getUser((String)"plugins/impfplan/outputdir", (String)CoreHub.getWritableUserDir().getAbsolutePath());
        if (outputPath.equals(CoreHub.getWritableUserDir().getAbsolutePath())) {
            SWTHelper.showInfo((String)"Kein Ausgabeverzeichnis definiert", (String)("Ausgabe erfolgt in: " + outputPath + "\nDas Ausgabeverzeichnis kann unter Einstellungen\\Klinische Hilfsmittel\\Impfplan definiert werden."));
        }
        File outputDir = new File(outputPath);
        File pdf = new File(outputDir, "impfplan_" + patient.getPatCode() + ".pdf");
        document.save(pdf);
        document.close();
        Program.launch((String)pdf.getAbsolutePath());
    }

    static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    bufferedImage.setRGB(x, y, rgb.red << 16 | rgb.green << 8 | rgb.blue);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }
}

