/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.hin.sign.core.internal;

import at.medevit.elexis.emediplan.core.EMediplanUtil;
import at.medevit.elexis.emediplan.core.model.print.Medication;
import at.medevit.elexis.hin.auth.core.GetAuthCodeWithStateSupplier;
import at.medevit.elexis.hin.auth.core.IHinAuthService;
import at.medevit.elexis.hin.auth.core.IHinAuthUi;
import at.medevit.elexis.hin.sign.core.IHinSignService;
import at.medevit.elexis.hin.sign.core.internal.CliProcess;
import ch.elexis.core.model.IBlob;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IRecipe;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IFormattedOutput;
import ch.elexis.core.services.IFormattedOutputFactory;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.status.ObjectStatus;
import com.google.gson.Gson;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class HINSignService
implements IHinSignService {
    private static Logger logger = LoggerFactory.getLogger(HINSignService.class);
    private IHinSignService.Mode mode;
    @Reference
    private IConfigService configService;
    @Reference
    private IHinAuthService hinAuthService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private IHinAuthUi authUi;
    @Reference
    private Gson gson;
    private String currentState;

    @Activate
    public void activate() {
        if (StringUtils.isNotBlank((CharSequence)System.getProperty("hinsign.test"))) {
            this.setMode(IHinSignService.Mode.TEST);
        } else {
            this.setMode(IHinSignService.Mode.PROD);
        }
    }

    @Override
    public void setMode(IHinSignService.Mode mode) {
        this.mode = mode;
    }

    @Override
    public ObjectStatus<?> createPrescription(String chmed) {
        Optional<String> authHandle;
        Optional<String> adSwissAuthToken = this.getADSwissAuthToken();
        if (adSwissAuthToken.isPresent() && (authHandle = this.getEPDAuthHandle(adSwissAuthToken.get())).isPresent()) {
            CliProcess cliProcess = CliProcess.createPrescription(authHandle.get(), chmed, this.mode);
            if (cliProcess.execute()) {
                if (cliProcess.getOutput() != null && !cliProcess.getOutput().isEmpty() && cliProcess.getOutput().get(0).startsWith("https://eprescription.hin.ch")) {
                    return ObjectStatus.OK((Object)cliProcess.getOutput().get(0));
                }
            } else {
                logger.error("Error executing cli\n[" + cliProcess.getOutput().stream().collect(Collectors.joining("\n")) + "]");
                Map<?, ?> map = cliProcess.getOutputAsMap();
                if (map != null) {
                    return ObjectStatus.ERROR(map);
                }
                return ObjectStatus.ERROR((String)"Authentication failed");
            }
        }
        return ObjectStatus.ERROR((String)"Authentication failed");
    }

    @Override
    public ObjectStatus<?> verifyPrescription(String chmedUrl) {
        CliProcess cliProcess = CliProcess.verifyPrescription(chmedUrl, this.mode);
        if (cliProcess.execute()) {
            Map<?, ?> map = cliProcess.getOutputAsMap();
            if (map != null) {
                return ObjectStatus.OK(map);
            }
        } else {
            logger.error("Error executing cli\n[" + cliProcess.getOutput().stream().collect(Collectors.joining("\n")) + "]");
            Map<?, ?> map = cliProcess.getOutputAsMap();
            if (map != null) {
                return ObjectStatus.ERROR(map);
            }
        }
        return ObjectStatus.ERROR((String)"Verification failed");
    }

    @Override
    public ObjectStatus<?> revokePrescription(String chmedId) {
        Optional<String> authHandle;
        Optional<String> adSwissAuthToken = this.getADSwissAuthToken();
        if (adSwissAuthToken.isPresent() && (authHandle = this.getEPDAuthHandle(adSwissAuthToken.get())).isPresent()) {
            CliProcess cliProcess = CliProcess.revokePrescription(authHandle.get(), chmedId, this.mode);
            if (cliProcess.execute()) {
                Map<?, ?> map = cliProcess.getOutputAsMap();
                return ObjectStatus.OK(map);
            }
            logger.error("Error executing cli\n[" + cliProcess.getOutput().stream().collect(Collectors.joining("\n")) + "]");
            Map<?, ?> map = cliProcess.getOutputAsMap();
            if (map != null) {
                return ObjectStatus.ERROR(map);
            }
            return ObjectStatus.ERROR((String)"Authentication failed");
        }
        return ObjectStatus.ERROR((String)"Authentication failed");
    }

    protected Optional<String> getADSwissAuthToken() {
        if (this.hinAuthService != null) {
            return this.hinAuthService.getToken(Collections.singletonMap("token_group", this.mode == IHinSignService.Mode.TEST ? "ADSwiss_CI-Test" : "ADSwiss_CI"));
        }
        logger.error("No HIN auth service");
        return Optional.empty();
    }

    protected Optional<String> getEPDAuthHandle(String bearerToken) {
        Optional<String> existingHandle = this.validateEPDAuthHandle(this.configService.getActiveMandator("epd/auth/handle/", null));
        if (existingHandle.isEmpty() && (existingHandle = this.getEPDAuthHandle(bearerToken, this.authUi)).isPresent()) {
            Long expires = System.currentTimeMillis() + 43200000L;
            this.configService.setActiveMandator("epd/auth/handle/", existingHandle.get());
            this.configService.setActiveMandator("epd/auth/handleexpires/", Long.toString(expires));
        }
        return existingHandle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<String> validateEPDAuthHandle(String existingHandle) {
        if (!StringUtils.isNotBlank((CharSequence)existingHandle)) return Optional.empty();
        String tokenExpires = this.configService.getActiveMandator("epd/auth/handleexpires/", null);
        if (!StringUtils.isNotBlank((CharSequence)tokenExpires)) return Optional.of(existingHandle);
        Long expires = Long.parseLong(tokenExpires);
        if (System.currentTimeMillis() <= expires) return Optional.of(existingHandle);
        this.configService.setActiveMandator("epd/auth/handle/", null);
        this.configService.setActiveMandator("epd/auth/handleexpires/", null);
        return Optional.empty();
    }

    protected Optional<String> getEPDAuthHandle(String bearerToken, IHinAuthUi authUi) {
        block9: {
            try {
                URL serverURL = this.getEPDAuthServiceAuthCodeUrl();
                logger.info("Using EPD auth code url [" + String.valueOf(serverURL) + "]");
                HttpURLConnection httpConnection = (HttpURLConnection)serverURL.openConnection();
                httpConnection.setRequestMethod("POST");
                httpConnection.setDoOutput(false);
                httpConnection.setDoInput(true);
                httpConnection.setUseCaches(false);
                httpConnection.setRequestProperty("accept", "application/json");
                httpConnection.setRequestProperty("Authorization", "Bearer " + bearerToken);
                int responseCode = httpConnection.getResponseCode();
                if (responseCode >= 200 && responseCode < 300) {
                    InputStream in = httpConnection.getInputStream();
                    String encoding = httpConnection.getContentEncoding();
                    encoding = encoding == null ? "UTF-8" : encoding;
                    String body = IOUtils.toString((InputStream)in, (String)encoding);
                    Map map = (Map)this.gson.fromJson(body, Map.class);
                    String epdAuthUrl = (String)map.get("epdAuthUrl");
                    logger.info("Got EPD auth url [" + epdAuthUrl + "]");
                    if (StringUtils.isNotBlank((CharSequence)epdAuthUrl)) {
                        Optional<String> epdAuthCode = this.getEpdAuthCode(epdAuthUrl, authUi);
                        if (epdAuthCode.isPresent()) {
                            Map respondeMap;
                            String line;
                            serverURL = this.getEPDAuthServiceAuthHandleUrl();
                            logger.info("Using EPD auth handle url [" + String.valueOf(serverURL) + "]");
                            httpConnection = (HttpURLConnection)serverURL.openConnection();
                            httpConnection.setRequestMethod("POST");
                            httpConnection.setDoOutput(true);
                            httpConnection.setDoInput(true);
                            httpConnection.setUseCaches(false);
                            httpConnection.setRequestProperty("accept", "application/json");
                            httpConnection.setRequestProperty("Content-Type", "application/json");
                            httpConnection.setRequestProperty("Authorization", "Bearer " + bearerToken);
                            PrintWriter out = new PrintWriter(httpConnection.getOutputStream());
                            out.println(this.gson.toJson(Collections.singletonMap("authCode", epdAuthCode.get())));
                            out.close();
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream()));
                            StringBuffer responseMessage = new StringBuffer();
                            while ((line = bufferedReader.readLine()) != null) {
                                responseMessage.append(line);
                            }
                            bufferedReader.close();
                            if (StringUtils.isNotBlank((CharSequence)responseMessage) && (respondeMap = (Map)this.gson.fromJson(responseMessage.toString(), Map.class)).containsKey("authHandle")) {
                                return Optional.ofNullable((String)respondeMap.get("authHandle"));
                            }
                        } else {
                            logger.warn("Failed to get EPD auth code");
                        }
                    }
                } else {
                    logger.warn("Failed to get EPD auth handle response code [" + responseCode + "]");
                }
            }
            catch (Exception e) {
                Optional message;
                logger.warn("Failed to get EPD auth handle", (Throwable)e);
                if (this.hinAuthService == null || !(message = this.hinAuthService.handleException(e, Collections.singletonMap("token_group", this.mode == IHinSignService.Mode.TEST ? "ADSwiss_CI-Test" : "ADSwiss_CI"))).isPresent()) break block9;
                logger.warn("HIN Auth message", message.get());
            }
        }
        return Optional.empty();
    }

    private URL getEPDAuthServiceAuthCodeUrl() throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getADSwissAuthServiceBaseUrl() + "EPDAuth");
        sb.append("?targetUrl=");
        sb.append(URLEncoder.encode(this.getRedirectUri() + "/" + this.getCurrentState(true), StandardCharsets.UTF_8));
        sb.append("&style=redirect");
        return new URL(sb.toString());
    }

    private URL getEPDAuthServiceAuthHandleUrl() throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getADSwissAuthServiceBaseUrl() + "EPDAuth/auth_handle");
        return new URL(sb.toString());
    }

    private String getADSwissAuthServiceBaseUrl() {
        return this.mode == IHinSignService.Mode.TEST ? "https://oauth2.ci-prep.adswiss.hin.ch/authService/" : "https://oauth2.ci.adswiss.hin.ch/authService/";
    }

    private Optional<String> getEpdAuthCode(String epdAuthUrl, IHinAuthUi iHinAuthUi) {
        iHinAuthUi.openBrowser(epdAuthUrl);
        Object value = iHinAuthUi.getWithCancelableProgress("HIN Berechtigung im Browser best\u00e4tigen.", (Supplier)new GetAuthCodeWithStateSupplier(this.getCurrentState(false)));
        if (value instanceof String) {
            return Optional.of((String)value);
        }
        return Optional.empty();
    }

    private String getCurrentState(boolean refresh) {
        if (refresh) {
            this.currentState = UUID.randomUUID().toString();
        }
        return this.currentState;
    }

    private String getRedirectUri() {
        return "https://tools.medelexis.ch/hin/ac";
    }

    public Optional<String> getChmedId(String encodedChmed) {
        String decodedChmed;
        Map chmedMap;
        if (StringUtils.isNotBlank((CharSequence)encodedChmed) && (chmedMap = (Map)this.gson.fromJson(decodedChmed = EMediplanUtil.getDecodedJsonString((String)encodedChmed), Map.class)) != null) {
            return Optional.ofNullable((String)chmedMap.get("Id"));
        }
        return Optional.empty();
    }

    public boolean isPrescriptionExists(ObjectStatus<?> status) {
        if (status.get() instanceof Map) {
            Map statusMap = (Map)status.get();
            return statusMap.get("error_code") != null && statusMap.get("error_code").equals("prescription_already_exists");
        }
        return false;
    }

    @Override
    public void setPrescriptionUrl(IRecipe iRecipe, String url) {
        IBlob blob = this.getOrCreateBlob(iRecipe);
        Hashtable<String, String> map = blob.getMapContent();
        if (map.isEmpty()) {
            map = new Hashtable<String, String>();
        }
        map.put("url", url);
        blob.setMapContent(map);
        CoreModelServiceHolder.get().save((Identifiable)blob);
    }

    @Override
    public Optional<String> getPrescriptionUrl(IRecipe iRecipe) {
        IBlob blob = this.getBlob(iRecipe);
        if (blob != null) {
            return Optional.ofNullable((String)blob.getMapContent().get("url"));
        }
        return Optional.empty();
    }

    private IBlob getBlob(IRecipe iRecipe) {
        return CoreModelServiceHolder.get().load(iRecipe.getId(), IBlob.class).orElse(null);
    }

    private IBlob getOrCreateBlob(IRecipe iRecipe) {
        IBlob blob = CoreModelServiceHolder.get().load(iRecipe.getId(), IBlob.class).orElse(null);
        if (blob == null) {
            blob = (IBlob)CoreModelServiceHolder.get().create(IBlob.class);
            blob.setId(iRecipe.getId());
        }
        CoreModelServiceHolder.get().save((Identifiable)blob);
        return blob;
    }

    @Override
    public ObjectStatus<?> exportPrescriptionPdf(IRecipe iRecipe, OutputStream output) {
        Optional<String> url = this.getPrescriptionUrl(iRecipe);
        if (url.isPresent()) {
            Optional<Image> qrCode = this.getQrCode(url.get());
            Medication medication = Medication.fromPrescriptions((IMandator)iRecipe.getMandator(), (IPatient)iRecipe.getPatient(), (List)iRecipe.getPrescriptions());
            try {
                this.createPdf(qrCode, medication, output);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("Failed to create eprescription pdf", (Throwable)e);
                return ObjectStatus.ERROR((String)"Failed to create eprescription pdf");
            }
            return ObjectStatus.OK((String)"Created eprescription to output", (Object)url.get());
        }
        return ObjectStatus.ERROR((String)"No eprescription url set");
    }

    private void createPdf(Optional<Image> qrCode, Medication medication, OutputStream output) {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference fopFactoryRef = bundleContext.getServiceReference(IFormattedOutputFactory.class);
        if (fopFactoryRef == null) {
            throw new IllegalStateException("No IFormattedOutputFactory available");
        }
        IFormattedOutputFactory fopFactory = (IFormattedOutputFactory)bundleContext.getService(fopFactoryRef);
        IFormattedOutput foOutput = fopFactory.getFormattedOutputImplementation(IFormattedOutputFactory.ObjectType.JAXB, IFormattedOutputFactory.OutputType.PDF);
        HashMap parameters = new HashMap();
        qrCode.ifPresent(qr -> parameters.put("qrJpeg", this.getEncodedQr((Image)qr)));
        foOutput.transform((Object)medication, HINSignService.class.getResourceAsStream("/rsc/xslt/eprescription.xslt"), output, parameters);
        bundleContext.ungetService(fopFactoryRef);
    }

    private String getEncodedQr(Image qr) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{qr.getImageData()};
                imageLoader.compression = 100;
                imageLoader.save((OutputStream)output, 4);
                return "data:image/jpg;base64," + Base64.getEncoder().encodeToString(output.toByteArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error encoding QR", (Throwable)e);
            return "";
        }
    }

    protected Optional<Image> getQrCode(String prescriptionUrl) {
        Hashtable<EncodeHintType, ErrorCorrectionLevel> hintMap = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        try {
            BitMatrix bitMatrix = qrCodeWriter.encode(prescriptionUrl, BarcodeFormat.QR_CODE, 470, 470, hintMap);
            int width = bitMatrix.getWidth();
            int height = bitMatrix.getHeight();
            ImageData data = new ImageData(width, height, 24, new PaletteData(255, 65280, 0xFF0000));
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    data.setPixel(x, y, bitMatrix.get(x, y) ? 0 : 0xFFFFFF);
                    ++x;
                }
                ++y;
            }
            return Optional.of(new Image((Device)Display.getDefault(), data));
        }
        catch (WriterException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error creating QR", (Throwable)e);
            return Optional.empty();
        }
    }
}

