/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.vacdoc.service.internal;

import at.medevit.elexis.ehc.core.EhcCoreMapper;
import at.medevit.elexis.ehc.core.EhcCoreService;
import at.medevit.elexis.ehc.vacdoc.service.VacdocService;
import at.medevit.elexis.impfplan.model.po.Vaccination;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.IFhirTransformerRegistry;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IVaccination;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class VacdocServiceImpl
implements VacdocService {
    private static Logger logger = LoggerFactory.getLogger(VacdocServiceImpl.class);
    @org.osgi.service.component.annotations.Reference
    private EhcCoreService ehcCoreService;
    @org.osgi.service.component.annotations.Reference
    private IFhirTransformerRegistry transformerRegistry;

    @Override
    public InputStream getXdmAsStream(Bundle document) throws Exception {
        return this.ehcCoreService.getXdmAsStream(document);
    }

    @Override
    public Bundle getVacdocDocument(Patient patient, Mandant mandant) {
        Bundle bundle = new Bundle();
        String bundleUuid = UUID.randomUUID().toString();
        bundle.setId(bundleUuid);
        bundle.getMeta().addProfile("http://fhir.ch/ig/ch-vacd/StructureDefinition/ch-vacd-document-immunization-administration");
        bundle.setIdentifier(new Identifier().setSystem("urn:ietf:rfc:3986").setValue(bundleUuid));
        bundle.setType(Bundle.BundleType.DOCUMENT);
        bundle.setTimestamp(new Date());
        IFhirTransformer patientTransformer = this.transformerRegistry.getTransformerFor(org.hl7.fhir.r4.model.Patient.class, IPatient.class);
        org.hl7.fhir.r4.model.Patient fhirPatient = (org.hl7.fhir.r4.model.Patient)patientTransformer.getFhirObject((Object)patient.toIPatient()).orElseThrow(() -> new IllegalStateException("Coult not create FHIR patient"));
        bundle.addEntry().setResource((Resource)fhirPatient);
        IFhirTransformer practitionerTransformer = this.transformerRegistry.getTransformerFor(Practitioner.class, IMandator.class);
        Practitioner fhirPractitioner = (Practitioner)practitionerTransformer.getFhirObject((Object)((IMandator)CoreModelServiceHolder.get().load(mandant.getId(), IMandator.class).get())).orElseThrow(() -> new IllegalStateException("Coult not create FHIR practitioner"));
        bundle.addEntry().setResource((Resource)fhirPractitioner);
        Organization fhirCustodian = null;
        if (mandant.getRechnungssteller().istOrganisation()) {
            IFhirTransformer organizationTransformer = this.transformerRegistry.getTransformerFor(Organization.class, IOrganization.class);
            fhirCustodian = (Organization)organizationTransformer.getFhirObject((Object)((IOrganization)CoreModelServiceHolder.get().load(mandant.getRechnungssteller().getId(), IOrganization.class).get())).orElseThrow(() -> new IllegalStateException("Coult not create FHIR organization"));
            bundle.addEntry().setResource((Resource)fhirCustodian);
        }
        Composition composition = new Composition();
        String compositionUuid = UUID.randomUUID().toString();
        composition.setId(compositionUuid);
        composition.getMeta().addProfile("http://fhir.ch/ig/ch-vacd/StructureDefinition/ch-vacd-composition-immunization-administration");
        composition.setLanguage(Locale.getDefault().getLanguage());
        composition.setIdentifier(new Identifier().setSystem("urn:ietf:rfc:3986").setValue(compositionUuid));
        composition.setStatus(Composition.CompositionStatus.FINAL);
        composition.setType(new CodeableConcept(new Coding("http://snomed.info/sct", "41000179103", "Immunization record")));
        composition.setConfidentiality(Composition.DocumentConfidentiality.N);
        composition.setTitle("Immunization Administration");
        composition.setDate(new Date());
        composition.setSubject(new Reference((IAnyResource)fhirPatient));
        composition.addAuthor(new Reference((IAnyResource)fhirPractitioner));
        if (fhirCustodian != null) {
            composition.setCustodian(new Reference((IAnyResource)fhirCustodian));
        }
        Bundle.BundleEntryComponent compositionEntry = bundle.addEntry();
        compositionEntry.setResource((Resource)composition);
        return bundle;
    }

    @Override
    public void addAllVaccinations(Bundle bundle) {
        Patient elexisPatient = EhcCoreMapper.getElexisPatient((Bundle)bundle, (boolean)false);
        if (elexisPatient != null) {
            Query query = new Query(Vaccination.class);
            query.add("Patient_ID", "=", elexisPatient.getId());
            List vaccinations = query.execute();
            this.addVaccinations(bundle, vaccinations);
        }
    }

    @Override
    public void addVaccinations(Bundle bundle, List<Vaccination> vaccinations) {
        if (!vaccinations.isEmpty()) {
            IFhirTransformer immunizationTransformer = this.transformerRegistry.getTransformerFor(Immunization.class, IVaccination.class);
            for (Vaccination vaccination : vaccinations) {
                Optional<Composition> composition;
                Optional fhirImmunization = immunizationTransformer.getFhirObject((Object)((IVaccination)CoreModelServiceHolder.get().load(vaccination.getId(), IVaccination.class).get()));
                if (!fhirImmunization.isPresent() || !(composition = bundle.getEntry().stream().filter(e -> e.getResource() instanceof Composition).map(e -> (Composition)e.getResource()).findFirst()).isPresent()) continue;
                Composition.SectionComponent section = composition.get().getSectionFirstRep();
                if (!section.hasId()) {
                    this.initImmunizationAdministrationSection(section);
                }
                Bundle.BundleEntryComponent immunizationEntry = bundle.addEntry();
                immunizationEntry.setResource((Resource)fhirImmunization.get());
                section.addEntry(new Reference((IAnyResource)fhirImmunization.get()));
            }
        }
    }

    private void initImmunizationAdministrationSection(Composition.SectionComponent section) {
        section.setId("administration");
        section.setTitle("Immunization Administration");
        section.setCode(new CodeableConcept(new Coding("http://loinc.org", "11369-6", "Hx of Immunization")));
    }

    @Override
    public Optional<Bundle> loadVacdocDocument(InputStream document) throws Exception {
        try {
            String jsonString = IOUtils.toString((InputStream)document, (String)"UTF-8");
            IBaseResource bundleResource = ModelUtil.getAsResource((String)jsonString);
            if (bundleResource != null && bundleResource instanceof Bundle) {
                return Optional.of((Bundle)bundleResource);
            }
            logger.error("Provided json is not a bundle");
        }
        catch (Exception e) {
            logger.error("problem loading json bundle", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public void importImmunizations(Patient elexisPatient, List<Immunization> immunizations) {
        for (Immunization immunization : immunizations) {
            IFhirTransformer immunizationTransformer = this.transformerRegistry.getTransformerFor(Immunization.class, Vaccination.class);
            Optional localObject = immunizationTransformer.createLocalObject((Object)immunization);
            if (!localObject.isEmpty()) continue;
            logger.error("Could not create local vaccintion object");
        }
    }

    @Override
    public List<Immunization> getImmunizations(Bundle bundle) {
        Optional<Composition> composition = bundle.getEntry().stream().filter(e -> e.getResource() instanceof Composition).map(e -> (Composition)e.getResource()).findFirst();
        if (composition.isPresent()) {
            return bundle.getEntry().stream().filter(e -> e.getResource() instanceof Immunization).map(e -> (Immunization)e.getResource()).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public Optional<Medication> getMedication(Immunization immunization) {
        IBaseResource resource;
        Extension extension;
        if (immunization.hasExtension("http://fhir.ch/ig/ch-vacd/StructureDefinition/ch-vacd-ext-immunization-medication-reference") && (extension = immunization.getExtensionByUrl("http://fhir.ch/ig/ch-vacd/StructureDefinition/ch-vacd-ext-immunization-medication-reference")).hasValue() && extension.getValue() instanceof Reference && (resource = ((Reference)extension.getValue()).getResource()) instanceof Medication) {
            return Optional.of((Medication)resource);
        }
        return Optional.empty();
    }
}

