/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.aerztekasse.ui.outputter;

import at.medevit.elexis.tarmed.model.TarmedJaxbUtil;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.fd.invoice450.request.GuarantorAddressType;
import ch.fd.invoice450.request.OnlineAddressType;
import ch.fd.invoice450.request.TransportType;
import ch.fd.invoice500.request.DebitorAddressType;
import ch.fd.invoice500.request.PatientAddressType;
import ch.fd.invoice500.request.RequestType;
import ch.fd.invoice500.request.TelecomAddressType;
import ch.fd.invoice500.request.TransportType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.LoggerFactory;

public class TarmedXmlUtil {
    public static Optional<Document> updateAerztekasseInfo(IInvoice invoice, Document document) {
        String version = TarmedJaxbUtil.getXMLVersion((Document)document);
        if ("4.5".equals(version)) {
            ch.fd.invoice450.request.RequestType invoiceRequest = TarmedJaxbUtil.unmarshalInvoiceRequest450((Document)document);
            ((TransportType.Via)invoiceRequest.getProcessing().getTransport().getVia().get(0)).setVia("7611910000009");
            if (TarmedXmlUtil.isBillingLaw(invoice, BillingLaw.KVG) && TarmedXmlUtil.isCopyToPatient(invoiceRequest) && TarmedXmlUtil.isNoElectronicDelivery(invoice)) {
                TarmedXmlUtil.setElectronicDelivery(invoiceRequest, false);
            } else if (TarmedXmlUtil.isGuarantorLegalGuardian(invoice)) {
                TarmedXmlUtil.updateFieldsIfMissingGuarantor(invoice, invoiceRequest, (IContact)invoice.getCoverage().getPatient());
            }
            ByteArrayOutputStream xmlOutput = new ByteArrayOutputStream();
            if (TarmedJaxbUtil.marshallInvoiceRequest((ch.fd.invoice450.request.RequestType)invoiceRequest, (OutputStream)xmlOutput)) {
                SAXBuilder builder = new SAXBuilder();
                try {
                    return Optional.of(builder.build((Reader)new StringReader(xmlOutput.toString())));
                }
                catch (IOException | JDOMException e) {
                    LoggerFactory.getLogger(TarmedXmlUtil.class).error("Error loading existing xml document", e);
                }
            }
        } else if ("5.0".equals(version)) {
            RequestType invoiceRequest = TarmedJaxbUtil.unmarshalInvoiceRequest500((Document)document);
            ((TransportType.Via)invoiceRequest.getProcessing().getTransport().getVia().get(0)).setVia("7611910000009");
            if (TarmedXmlUtil.isBillingLaw(invoice, BillingLaw.KVG) && TarmedXmlUtil.isCopyToPatient(invoiceRequest) && TarmedXmlUtil.isNoElectronicDelivery(invoice)) {
                TarmedXmlUtil.setElectronicDelivery(invoiceRequest, false);
            } else if (TarmedXmlUtil.isGuarantorLegalGuardian(invoice)) {
                TarmedXmlUtil.updateFieldsIfMissingGuarantor(invoice, invoiceRequest, (IContact)invoice.getCoverage().getPatient());
            }
            ByteArrayOutputStream xmlOutput = new ByteArrayOutputStream();
            if (TarmedJaxbUtil.marshallInvoiceRequest((RequestType)invoiceRequest, (OutputStream)xmlOutput)) {
                SAXBuilder builder = new SAXBuilder();
                try {
                    return Optional.of(builder.build((Reader)new StringReader(xmlOutput.toString())));
                }
                catch (IOException | JDOMException e) {
                    LoggerFactory.getLogger(TarmedXmlUtil.class).error("Error loading existing xml document", e);
                }
            }
        }
        return Optional.empty();
    }

    private static void updateFieldsIfMissingGuarantor(IInvoice invoice, RequestType invoiceRequest, IContact contact) {
        ch.fd.invoice500.request.GuarantorAddressType guarantor = null;
        if (invoiceRequest.getPayload().getBody().getTiersGarant() != null) {
            guarantor = invoiceRequest.getPayload().getBody().getTiersGarant().getGuarantor();
        } else if (invoiceRequest.getPayload().getBody().getTiersPayant() != null) {
            guarantor = invoiceRequest.getPayload().getBody().getTiersPayant().getGuarantor();
        }
        if (guarantor != null && guarantor.getPerson() != null) {
            TelecomAddressType guarantorTelcom = guarantor.getPerson().getTelecom();
            if (StringUtils.isNotBlank((CharSequence)contact.getMobile()) && (guarantorTelcom == null || guarantorTelcom.getPhone().isEmpty())) {
                if (guarantorTelcom == null) {
                    guarantorTelcom = new TelecomAddressType();
                    guarantor.getPerson().setTelecom(guarantorTelcom);
                }
                guarantorTelcom.getPhone().add(StringUtils.abbreviate((String)contact.getMobile(), (int)25));
            }
            ch.fd.invoice500.request.OnlineAddressType guarantorOnline = guarantor.getPerson().getOnline();
            if (StringUtils.isNotBlank((CharSequence)contact.getEmail()) && (guarantorOnline == null || guarantorOnline.getEmail().isEmpty())) {
                String email;
                if (guarantorOnline == null) {
                    guarantorOnline = new ch.fd.invoice500.request.OnlineAddressType();
                    guarantor.getPerson().setOnline(guarantorOnline);
                }
                if (!(email = XMLExporterUtil.getValidXMLString((String)StringUtils.left((String)contact.getEmail(), (int)70))).matches(".+@.+")) {
                    email = "mail@invalid.invalid";
                }
                guarantorOnline.getEmail().add(email);
            }
        }
    }

    private static void updateFieldsIfMissingGuarantor(IInvoice invoice, ch.fd.invoice450.request.RequestType invoiceRequest, IContact contact) {
        GuarantorAddressType guarantor = null;
        if (invoiceRequest.getPayload().getBody().getTiersGarant() != null) {
            guarantor = invoiceRequest.getPayload().getBody().getTiersGarant().getGuarantor();
        } else if (invoiceRequest.getPayload().getBody().getTiersPayant() != null) {
            guarantor = invoiceRequest.getPayload().getBody().getTiersPayant().getGuarantor();
        }
        if (guarantor != null && guarantor.getPerson() != null) {
            ch.fd.invoice450.request.TelecomAddressType guarantorTelcom = guarantor.getPerson().getTelecom();
            if (StringUtils.isNotBlank((CharSequence)contact.getMobile()) && (guarantorTelcom == null || guarantorTelcom.getPhone().isEmpty())) {
                if (guarantorTelcom == null) {
                    guarantorTelcom = new ch.fd.invoice450.request.TelecomAddressType();
                    guarantor.getPerson().setTelecom(guarantorTelcom);
                }
                guarantorTelcom.getPhone().add(StringUtils.abbreviate((String)contact.getMobile(), (int)25));
            }
            OnlineAddressType guarantorOnline = guarantor.getPerson().getOnline();
            if (StringUtils.isNotBlank((CharSequence)contact.getEmail()) && (guarantorOnline == null || guarantorOnline.getEmail().isEmpty())) {
                String email;
                if (guarantorOnline == null) {
                    guarantorOnline = new OnlineAddressType();
                    guarantor.getPerson().setOnline(guarantorOnline);
                }
                if (!(email = XMLExporterUtil.getValidXMLString((String)StringUtils.left((String)contact.getEmail(), (int)70))).matches(".+@.+")) {
                    email = "mail@invalid.invalid";
                }
                guarantorOnline.getEmail().add(email);
            }
        }
    }

    private static boolean isCopyToPatient(ch.fd.invoice450.request.RequestType invoiceRequest) {
        if (invoiceRequest.getProcessing() != null) {
            return invoiceRequest.getProcessing().isPrintCopyToGuarantor();
        }
        return false;
    }

    private static boolean isCopyToPatient(RequestType invoiceRequest) {
        if (invoiceRequest.getProcessing() != null) {
            return invoiceRequest.getProcessing().isPrintCopyToGuarantor();
        }
        return false;
    }

    private static void setElectronicDelivery(ch.fd.invoice450.request.RequestType invoiceRequest, boolean value) {
        if (!value) {
            if (invoiceRequest.getPayload().getBody().getTiersGarant() != null) {
                if (invoiceRequest.getPayload().getBody().getTiersGarant().getDebitor() != null) {
                    ch.fd.invoice450.request.DebitorAddressType debitor = invoiceRequest.getPayload().getBody().getTiersGarant().getDebitor();
                    TarmedXmlUtil.setTelcomNull(debitor);
                    TarmedXmlUtil.setOnlineNull(debitor);
                }
                if (invoiceRequest.getPayload().getBody().getTiersGarant().getPatient() != null) {
                    ch.fd.invoice450.request.PatientAddressType patient = invoiceRequest.getPayload().getBody().getTiersGarant().getPatient();
                    TarmedXmlUtil.setTelcomNull(patient);
                    TarmedXmlUtil.setOnlineNull(patient);
                }
                if (invoiceRequest.getPayload().getBody().getTiersGarant().getGuarantor() != null) {
                    GuarantorAddressType guarantor = invoiceRequest.getPayload().getBody().getTiersGarant().getGuarantor();
                    TarmedXmlUtil.setTelcomNull(guarantor);
                    TarmedXmlUtil.setOnlineNull(guarantor);
                }
            } else if (invoiceRequest.getPayload().getBody().getTiersPayant() != null) {
                if (invoiceRequest.getPayload().getBody().getTiersPayant().getDebitor() != null) {
                    ch.fd.invoice450.request.DebitorAddressType debitor = invoiceRequest.getPayload().getBody().getTiersPayant().getDebitor();
                    TarmedXmlUtil.setTelcomNull(debitor);
                    TarmedXmlUtil.setOnlineNull(debitor);
                }
                if (invoiceRequest.getPayload().getBody().getTiersPayant().getPatient() != null) {
                    ch.fd.invoice450.request.PatientAddressType patient = invoiceRequest.getPayload().getBody().getTiersPayant().getPatient();
                    TarmedXmlUtil.setTelcomNull(patient);
                    TarmedXmlUtil.setOnlineNull(patient);
                }
                if (invoiceRequest.getPayload().getBody().getTiersPayant().getGuarantor() != null) {
                    GuarantorAddressType guarantor = invoiceRequest.getPayload().getBody().getTiersPayant().getGuarantor();
                    TarmedXmlUtil.setTelcomNull(guarantor);
                    TarmedXmlUtil.setOnlineNull(guarantor);
                }
            }
        }
    }

    private static void setElectronicDelivery(RequestType invoiceRequest, boolean value) {
        if (!value) {
            if (invoiceRequest.getPayload().getBody().getTiersGarant() != null) {
                if (invoiceRequest.getPayload().getBody().getTiersGarant().getDebitor() != null) {
                    DebitorAddressType debitor = invoiceRequest.getPayload().getBody().getTiersGarant().getDebitor();
                    TarmedXmlUtil.setTelcomNull(debitor);
                    TarmedXmlUtil.setOnlineNull(debitor);
                }
                if (invoiceRequest.getPayload().getBody().getTiersGarant().getPatient() != null) {
                    PatientAddressType patient = invoiceRequest.getPayload().getBody().getTiersGarant().getPatient();
                    TarmedXmlUtil.setTelcomNull(patient);
                    TarmedXmlUtil.setOnlineNull(patient);
                }
                if (invoiceRequest.getPayload().getBody().getTiersGarant().getGuarantor() != null) {
                    ch.fd.invoice500.request.GuarantorAddressType guarantor = invoiceRequest.getPayload().getBody().getTiersGarant().getGuarantor();
                    TarmedXmlUtil.setTelcomNull(guarantor);
                    TarmedXmlUtil.setOnlineNull(guarantor);
                }
            } else if (invoiceRequest.getPayload().getBody().getTiersPayant() != null) {
                if (invoiceRequest.getPayload().getBody().getTiersPayant().getDebitor() != null) {
                    DebitorAddressType debitor = invoiceRequest.getPayload().getBody().getTiersPayant().getDebitor();
                    TarmedXmlUtil.setTelcomNull(debitor);
                    TarmedXmlUtil.setOnlineNull(debitor);
                }
                if (invoiceRequest.getPayload().getBody().getTiersPayant().getPatient() != null) {
                    PatientAddressType patient = invoiceRequest.getPayload().getBody().getTiersPayant().getPatient();
                    TarmedXmlUtil.setTelcomNull(patient);
                    TarmedXmlUtil.setOnlineNull(patient);
                }
                if (invoiceRequest.getPayload().getBody().getTiersPayant().getGuarantor() != null) {
                    ch.fd.invoice500.request.GuarantorAddressType guarantor = invoiceRequest.getPayload().getBody().getTiersPayant().getGuarantor();
                    TarmedXmlUtil.setTelcomNull(guarantor);
                    TarmedXmlUtil.setOnlineNull(guarantor);
                }
            }
        }
    }

    private static void setOnlineNull(ch.fd.invoice500.request.GuarantorAddressType guarantor) {
        if (guarantor.getPerson() != null) {
            guarantor.getPerson().setOnline(null);
        }
    }

    private static void setTelcomNull(ch.fd.invoice500.request.GuarantorAddressType guarantor) {
        if (guarantor.getPerson() != null) {
            guarantor.getPerson().setTelecom(null);
        }
    }

    private static void setOnlineNull(PatientAddressType patient) {
        if (patient.getPerson() != null) {
            patient.getPerson().setOnline(null);
        }
    }

    private static void setTelcomNull(PatientAddressType patient) {
        if (patient.getPerson() != null) {
            patient.getPerson().setTelecom(null);
        }
    }

    private static void setOnlineNull(DebitorAddressType debitor) {
        if (debitor.getCompany() != null) {
            debitor.getCompany().setOnline(null);
        } else if (debitor.getPerson() != null) {
            debitor.getPerson().setOnline(null);
        }
    }

    private static void setTelcomNull(DebitorAddressType debitor) {
        if (debitor.getCompany() != null) {
            debitor.getCompany().setTelecom(null);
        } else if (debitor.getPerson() != null) {
            debitor.getPerson().setTelecom(null);
        }
    }

    private static void setOnlineNull(GuarantorAddressType guarantor) {
        if (guarantor.getPerson() != null) {
            guarantor.getPerson().setOnline(null);
        }
    }

    private static void setTelcomNull(GuarantorAddressType guarantor) {
        if (guarantor.getPerson() != null) {
            guarantor.getPerson().setTelecom(null);
        }
    }

    private static void setOnlineNull(ch.fd.invoice450.request.PatientAddressType patient) {
        if (patient.getPerson() != null) {
            patient.getPerson().setOnline(null);
        }
    }

    private static void setTelcomNull(ch.fd.invoice450.request.PatientAddressType patient) {
        if (patient.getPerson() != null) {
            patient.getPerson().setTelecom(null);
        }
    }

    private static void setOnlineNull(ch.fd.invoice450.request.DebitorAddressType debitor) {
        if (debitor.getCompany() != null) {
            debitor.getCompany().setOnline(null);
        } else if (debitor.getPerson() != null) {
            debitor.getPerson().setOnline(null);
        }
    }

    private static void setTelcomNull(ch.fd.invoice450.request.DebitorAddressType debitor) {
        if (debitor.getCompany() != null) {
            debitor.getCompany().setTelecom(null);
        } else if (debitor.getPerson() != null) {
            debitor.getPerson().setTelecom(null);
        }
    }

    private static boolean isBillingLaw(IInvoice invoice, BillingLaw law) {
        if (invoice.getCoverage() != null && invoice.getCoverage().getBillingSystem() != null && invoice.getCoverage().getBillingSystem().getLaw() != null) {
            return invoice.getCoverage().getBillingSystem().getLaw() == law;
        }
        return false;
    }

    private static boolean isNoElectronicDelivery(IInvoice invoice) {
        if (invoice.getCoverage() != null) {
            return "1".equals(invoice.getCoverage().getExtInfo((Object)"NoElectronicDelivery"));
        }
        return false;
    }

    private static boolean isGuarantorLegalGuardian(IInvoice invoice) {
        if (invoice.getCoverage().getPatient().getLegalGuardian() != null) {
            IContact guardian = invoice.getCoverage().getPatient().getLegalGuardian();
            ICoverageService.Tiers tiersType = CoverageServiceHolder.get().getTiersType(invoice.getCoverage());
            IContact guarantor = XMLExporterUtil.getGuarantor((String)tiersType.getShortName(), (IPatient)invoice.getCoverage().getPatient(), (ICoverage)invoice.getCoverage());
            return guarantor != null && guarantor.getId().equals(guardian.getId());
        }
        return false;
    }
}

