/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.aerztekasse.ui.outputter;

import at.medevit.elexis.aerztekasse.core.IAerztekasseService;
import at.medevit.elexis.aerztekasse.ui.outputter.TarmedXmlUtil;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLFileUtil;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.RnOutputDialog;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import jakarta.inject.Inject;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.jdom2.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AerztekasseOutputter
extends XMLExporter {
    private static Logger logger = LoggerFactory.getLogger(AerztekasseOutputter.class);
    private String outputDir;
    @Inject
    private IAerztekasseService service;

    public AerztekasseOutputter() {
        CoreUiUtil.injectServices((Object)((Object)this));
    }

    public String getDescription() {
        return Messages.InvoiceOutputter_TransmisionAK;
    }

    public Result<Rechnung> doOutput(final IRnOutputter.TYPE type, final Collection<Rechnung> rnn, Properties props) {
        final Result result = new Result();
        if (!this.hasCredentialsSet()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.MissingSettingsDlg_Title, (String)"Es sind nicht alle notwendgen Einstellungen gesetzt um \u00c4rztekasse ausf\u00fchren zu k\u00f6nnen.\nBitte unter Datei > Einstellungen > Abrechnungssystem > \u00c4rztekasse einstellen.");
            result.add(Result.SEVERITY.ERROR, 1, Messages.Outputter_NoCredentialsSet, null, true);
            return result;
        }
        try {
            IProgressService progService = PlatformUI.getWorkbench().getProgressService();
            progService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.Invoices_export, rnn.size());
                    for (Rechnung rn : rnn) {
                        Document doc;
                        IInvoice invoice = (IInvoice)CoreModelServiceHolder.get().load(rn.getId(), IInvoice.class).get();
                        if (CoverageServiceHolder.get().getTiersType(invoice.getCoverage()) == ICoverageService.Tiers.PAYANT) {
                            AerztekasseOutputter.this.setPrintAtIntermediate(false);
                        }
                        if ((doc = AerztekasseOutputter.this.doExport(invoice, null, type, true)) == null) {
                            logger.error("Error exporting invoice #" + invoice.getNumber());
                            result.add(Result.SEVERITY.ERROR, 1, "Fehler beim Export der Rechnung Nr.: " + rn.getNr(), (Object)rn, true);
                        }
                        if (invoice.getState() == InvoiceState.DEFECTIVE) {
                            logger.error("Error in invoice #" + invoice.getNumber());
                            result.add(Result.SEVERITY.ERROR, 1, "Fehler beim Export der Rechnung Nr.: " + rn.getNr(), (Object)rn, true);
                        } else {
                            try {
                                Optional<Document> updatedDocument = TarmedXmlUtil.updateAerztekasseInfo(invoice, doc);
                                if (updatedDocument.isPresent()) {
                                    doc = updatedDocument.get();
                                    AerztekasseOutputter.this.setExistingXml(invoice, doc);
                                    AerztekasseOutputter.this.writeToOutputDirectory(invoice, doc);
                                    AerztekasseOutputter.this.updateInvoiceState(invoice);
                                }
                            }
                            catch (Exception e) {
                                logger.error("Error in invoice #" + invoice.getNumber(), (Throwable)e);
                                result.add(Result.SEVERITY.ERROR, 1, "Fehler beim Export der Rechnung Nr.: " + rn.getNr(), (Object)rn, true);
                            }
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) break;
                    }
                    monitor.done();
                }
            }, null);
            Result sendResult = this.service.sendFiles(new File(this.outputDir));
            if (!sendResult.isOK()) {
                logger.error("Error occured during aerztekasse transfer");
                Display.getDefault().syncExec(() -> ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler bei der Ausgabe", (String)"Konnte Rechnungen nicht \u00fcbermitteln", (IStatus)ResultAdapter.getResultAsStatus((Result)sendResult)));
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            logger.error("aerztekasse invoice transfer aborted");
            ExHandler.handle((Throwable)e);
            result.add(Result.SEVERITY.ERROR, 2, e.getMessage(), null, true);
        }
        catch (Exception ex) {
            logger.error("aerztekasse invoice delivery failed");
            ExHandler.handle((Throwable)ex);
            result.add(Result.SEVERITY.ERROR, 2, ex.getMessage(), null, true);
        }
        return result;
    }

    private void writeToOutputDirectory(IInvoice invoice, Document document) {
        XMLFileUtil.getFileName((IInvoice)invoice, (String)this.outputDir).ifPresent(filename -> XMLFileUtil.writeToFile((String)filename, (Document)document));
    }

    public Control createSettingsControl(Object parent) {
        Composite parentInc = (Composite)parent;
        return this.createSettingsControl(parentInc);
    }

    public Control createSettingsControl(final Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Label lblOutput = new Label(ret, 0);
        lblOutput.setText(Messages.Outputter_InvoiceOutputDirectory);
        lblOutput.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        Button b = new Button(ret, 8);
        b.setText(ch.elexis.TarmedRechnung.Messages.XMLExporter_Change);
        GridData buttonData = new GridData();
        buttonData.widthHint = 75;
        b.setLayoutData((Object)buttonData);
        final Text text = new Text(ret, 2056);
        text.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AerztekasseOutputter.this.outputDir = new DirectoryDialog(parent.getShell(), 4096).open();
                LocalConfigService.set((String)"aerztekasse/outputdir", (String)AerztekasseOutputter.this.outputDir);
                text.setText(AerztekasseOutputter.this.outputDir);
            }
        });
        this.outputDir = LocalConfigService.get((String)"aerztekasse/outputdir", (String)CoreUtil.getDefaultDBPath());
        text.setText(this.outputDir);
        return ret;
    }

    private boolean hasCredentialsSet() {
        return this.service.hasClientId() && this.service.hasCredentials();
    }

    public void openOutput(IInvoice invoice, LocalDateTime timestamp, InvoiceState invoiceState) {
        String archiveDir = this.service.getGlobalArchiveDir().orElse("");
        XMLFileUtil.lookupFile((String)archiveDir, (IInvoice)invoice, (LocalDateTime)timestamp, (InvoiceState)invoiceState).ifPresent(xmlFile -> {
            if (xmlFile.exists()) {
                Program.launch((String)xmlFile.getAbsolutePath());
            } else {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("File [" + xmlFile.getAbsolutePath() + "] does not exist");
            }
        });
    }

    private void updateInvoiceState(IInvoice invoice) {
        InvoiceState previousState = invoice.getState();
        if (previousState == InvoiceState.OPEN || previousState == InvoiceState.DEMAND_NOTE_1 || previousState == InvoiceState.DEMAND_NOTE_2 || previousState == InvoiceState.DEMAND_NOTE_3) {
            InvoiceState newState = InvoiceState.fromState((int)(previousState.numericValue() + 1));
            invoice.setState(newState);
        }
        invoice.addTrace("Ausgegeben", this.getDescription() + ": " + invoice.getState().getLocaleText());
        CoreModelServiceHolder.get().save((Identifiable)invoice);
    }

    public void customizeDialog(Object rnOutputDialog) {
        if (rnOutputDialog instanceof RnOutputDialog) {
            ((RnOutputDialog)rnOutputDialog).setOkButtonText("Senden");
        }
    }
}

