/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.model.service;

import at.medevit.atc_codes.ATCCode;
import at.medevit.atc_codes.ATCCodeService;
import at.medevit.ch.artikelstamm.model.importer.VersionUtil;
import at.medevit.ch.artikelstamm.model.service.CoreModelServiceHolder;
import at.medevit.ch.artikelstamm.model.service.ModelServiceHolder;
import ch.elexis.core.model.IBlobSecondary;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IQuery;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ATCCodeCacheUtil {
    protected static final String NAMED_BLOB_PREFIX = "ATC_ARTSTAMM_CACHE";
    private Logger log = LoggerFactory.getLogger(this.getClass());

    private String determineBlobId(IElexisEntityManager elexisEntityManager) {
        return "ATC_ARTSTAMM_CACHE_" + new VersionUtil(elexisEntityManager).getCurrentVersion();
    }

    public HashMap<String, Integer> rebuildCache(IElexisEntityManager elexisEntityManager, ATCCodeService atcCodeService, IProgressMonitor monitor) {
        HashMap<String, Integer> cache = new HashMap<String, Integer>();
        this.log.info("Start rebuilding ATCCodeCache ...");
        List allATCCodes = atcCodeService.getAllATCCodes();
        int numberOfATCCodes = allATCCodes.size();
        monitor.beginTask("Rebuilding index of available articles per ATC Code", numberOfATCCodes + 1);
        cache = new HashMap(numberOfATCCodes);
        TreeMap tm = new TreeMap();
        String queryString = "SELECT DISTINCT(atc) FROM artikelstamm_ch";
        this.log.debug("ArtikelstammImporter {} numberOfATCCodes using query {}:", (Object)numberOfATCCodes, (Object)queryString);
        ModelServiceHolder.get().executeNativeQuery(queryString).forEach(o -> {
            String atc;
            if (o instanceof String && (atc = (String)o) != null) {
                if (!tm.containsKey(atc)) {
                    tm.put(atc, 0);
                }
                Integer integer = (Integer)tm.get(atc);
                tm.put(atc, integer + 1);
            }
        });
        for (ATCCode atcCode : allATCCodes) {
            int foundElements = 0;
            ATCCode next = atcCodeService.getNextInHierarchy(atcCode);
            SortedMap subMap = next != null ? tm.subMap(atcCode.atcCode, next.atcCode) : tm.tailMap(atcCode.atcCode);
            for (String val : subMap.keySet()) {
                foundElements += ((Integer)tm.get(val)).intValue();
            }
            cache.put(atcCode.atcCode, foundElements);
            monitor.worked(1);
        }
        monitor.subTask("Persisting ATC Code product cache to database");
        IQuery query = CoreModelServiceHolder.get().getQuery(IBlobSecondary.class);
        query.and("id", IQuery.COMPARATOR.LIKE, (Object)"ATC_ARTSTAMM_CACHE%");
        query.and((EStructuralFeature)ModelPackage.Literals.IBLOB__DATE, IQuery.COMPARATOR.LESS, (Object)LocalDate.now());
        for (IBlobSecondary oldCache : query.execute()) {
            CoreModelServiceHolder.get().remove((Identifiable)oldCache);
        }
        try {
            String id = this.determineBlobId(elexisEntityManager);
            IBlobSecondary cacheStorage = CoreModelServiceHolder.get().load(id, IBlobSecondary.class).orElse(null);
            if (cacheStorage == null) {
                cacheStorage = (IBlobSecondary)CoreModelServiceHolder.get().create(IBlobSecondary.class);
                cacheStorage.setId(this.determineBlobId(elexisEntityManager));
                cacheStorage.setDate(LocalDate.now());
            }
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ObjectOutputStream oba = new ObjectOutputStream(ba);
            oba.writeObject(cache);
            oba.close();
            cacheStorage.setContent(ba.toByteArray());
            ba.close();
            CoreModelServiceHolder.get().save((Identifiable)cacheStorage);
            monitor.worked(1);
        }
        catch (IOException e) {
            this.log.error("Error on cache generation", (Throwable)e);
        }
        this.log.info("Rebuilding ATCCodeCache finished");
        monitor.done();
        return cache;
    }
}

