/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui.provider;

import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.ui.ArtikelstammLabelProvider;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.StockServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

public class LagerhaltungArtikelstammLabelProvider
extends ArtikelstammLabelProvider
implements IColorProvider {
    @Inject
    private IEclipseContext eclipseContext;
    private Image blackBoxedImage = ResourceManager.getPluginImage((String)"at.medevit.ch.artikelstamm.ui", (String)"/rsc/icons/flag-black.png");

    public LagerhaltungArtikelstammLabelProvider() {
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
    }

    public Image getImage(Object element) {
        IArtikelstammItem ai = (IArtikelstammItem)element;
        if (ai.isBlackBoxed()) {
            return this.blackBoxedImage;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        MPart mPart;
        Long availability = null;
        IArtikelstammItem ai = (IArtikelstammItem)element;
        availability = this.eclipseContext != null ? ((mPart = (MPart)this.eclipseContext.getActive(MPart.class)) != null && "ch.elexis.LeistungenView".equals(mPart.getElementId()) && ContextServiceHolder.get().getTyped(IEncounter.class).isPresent() ? this.getAvailability(ai, Optional.of(((IEncounter)ContextServiceHolder.get().getTyped(IEncounter.class).get()).getMandator())) : this.getAvailability(ai, ContextServiceHolder.get().getActiveMandator())) : StockServiceHolder.get().getCumulatedStockForArticle((IArticle)ai);
        if (availability != null) {
            return ai.getLabel() + " (LB: " + String.valueOf(availability) + ")";
        }
        return ai.getLabel();
    }

    private Long getAvailability(IArtikelstammItem ai, Optional<IMandator> mandator) {
        List stockEntries = StockServiceHolder.get().findAllStockEntriesForArticle(StoreToStringServiceHolder.getStoreToString((Object)ai));
        if (!stockEntries.isEmpty()) {
            if (mandator.isPresent()) {
                return stockEntries.stream().filter(se -> se.getStock().getOwner() == null || se.getStock().getOwner().getId().equals(((IMandator)mandator.get()).getId())).mapToInt(se -> se.getCurrentStock()).sum();
            }
            return stockEntries.stream().mapToInt(se -> se.getCurrentStock()).sum();
        }
        return null;
    }

    public Color getForeground(Object element) {
        IArtikelstammItem ai = (IArtikelstammItem)element;
        IStockService.Availability availability = StockServiceHolder.get().getCumulatedAvailabilityForArticle((IArticle)ai);
        if (availability != null) {
            switch (availability) {
                case CRITICAL_STOCK: 
                case OUT_OF_STOCK: {
                    return UiDesk.getColor((String)"rot");
                }
            }
            return UiDesk.getColor((String)"blau");
        }
        return null;
    }

    public Color getBackground(Object element) {
        IArtikelstammItem ai = (IArtikelstammItem)element;
        if (ai.isBlackBoxed()) {
            return UiDesk.getColor((String)"grau60");
        }
        return super.getBackground(element);
    }
}

