/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.po.service.internal;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.parser.DataFormatException;
import ch.elexis.core.findings.IFindingsService;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.INarrative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.AlwaysValidCacheEntryValidity;
import org.thymeleaf.cache.ICacheEntryValidity;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.DefaultTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.StringTemplateResource;

public class CustomNarrativeGenerator
implements INarrativeGenerator {
    private static final Logger logger = LoggerFactory.getLogger(CustomNarrativeGenerator.class);
    private boolean initialized;
    private HashMap<Class<?>, String> classToName;
    private HashMap<String, String> nameToNarrativeTemplate;
    private TemplateEngine profileTemplateEngine;

    public void generateNarrative(FhirContext theContext, IBaseResource theResource, INarrative theNarrative) {
        String name;
        if (!this.initialized) {
            this.initialize(theContext);
        }
        if ((name = null) == null) {
            name = this.classToName.get(theResource.getClass());
        }
        if (name == null) {
            name = theContext.getResourceDefinition(theResource).getName().toLowerCase();
        }
        if (name == null || !this.nameToNarrativeTemplate.containsKey(name)) {
            logger.debug("No narrative template available for resorce: {}", (Object)name);
            return;
        }
        try {
            Context context = new Context();
            context.setVariable("resource", (Object)theResource);
            context.setVariable("fhirVersion", (Object)theContext.getVersion().getVersion().name());
            String result = this.profileTemplateEngine.process(name, (IContext)context);
            if (result == null || result.trim().isEmpty()) {
                return;
            }
            theNarrative.setDivAsString(result);
            theNarrative.setStatusAsString("generated");
            return;
        }
        catch (Exception e) {
            logger.error("Failed to generate narrative", (Throwable)e);
            return;
        }
    }

    private synchronized void initialize(final FhirContext theContext) {
        if (this.initialized) {
            return;
        }
        logger.info("Initializing narrative generator");
        this.classToName = new HashMap();
        this.nameToNarrativeTemplate = new HashMap();
        try {
            this.loadProperties("/rsc/narrative/custom.properties");
        }
        catch (IOException e) {
            logger.info("Failed to load property file.", (Throwable)e);
        }
        this.profileTemplateEngine = new TemplateEngine();
        ProfileResourceResolver resolver = new ProfileResourceResolver();
        this.profileTemplateEngine.setTemplateResolver((ITemplateResolver)resolver);
        StandardDialect dialect = new StandardDialect(){

            public Set<IProcessor> getProcessors(String theDialectPrefix) {
                Set retVal = super.getProcessors(theDialectPrefix);
                retVal.add(new NarrativeAttributeProcessor(theContext, theDialectPrefix));
                return retVal;
            }
        };
        this.profileTemplateEngine.setDialect((IDialect)dialect);
        this.initialized = true;
    }

    private InputStream loadResource(String name) {
        return IFindingsService.class.getResourceAsStream(name);
    }

    private void loadProperties(String propFileName) throws IOException {
        Properties file = new Properties();
        InputStream resource = IFindingsService.class.getResourceAsStream(propFileName);
        file.load(resource);
        for (Object nextKeyObj : file.keySet()) {
            String narrative;
            String narrativePropName;
            String narrativeName;
            String name;
            String nextKey = (String)nextKeyObj;
            if (nextKey.endsWith(".profile")) {
                name = nextKey.substring(0, nextKey.indexOf(".profile"));
                if (name == null || name.trim().isEmpty() || (narrativeName = file.getProperty(narrativePropName = String.valueOf(name) + ".narrative")) == null || narrativeName.trim().isEmpty()) continue;
                narrative = IOUtils.toString((InputStream)this.loadResource(narrativeName), (String)"UTF-8");
                this.nameToNarrativeTemplate.put(name, narrative);
                continue;
            }
            if (nextKey.endsWith(".class")) {
                Class<?> clazz;
                name = nextKey.substring(0, nextKey.indexOf(".class"));
                if (name == null || name.trim().isEmpty()) continue;
                String className = file.getProperty(nextKey);
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    logger.debug("Unknown datatype class '{}' identified in narrative file {}", (Object)name, (Object)propFileName);
                    clazz = null;
                }
                if (clazz == null) continue;
                this.classToName.put(clazz, name);
                continue;
            }
            if (nextKey.endsWith(".narrative")) {
                name = nextKey.substring(0, nextKey.indexOf(".narrative"));
                if (name == null || name.trim().isEmpty() || (narrativeName = file.getProperty(narrativePropName = String.valueOf(name) + ".narrative")) == null || narrativeName.trim().isEmpty()) continue;
                narrative = IOUtils.toString((InputStream)this.loadResource(narrativeName), (String)"UTF-8");
                this.nameToNarrativeTemplate.put(name, narrative);
                continue;
            }
            throw new ConfigurationException("Invalid property name: " + nextKey);
        }
    }

    public class NarrativeAttributeProcessor
    extends AbstractAttributeTagProcessor {
        private FhirContext fhirContext;

        protected NarrativeAttributeProcessor(FhirContext theContext, String theDialectPrefix) {
            super(TemplateMode.XML, theDialectPrefix, null, false, "narrative", true, 0, true);
            this.fhirContext = theContext;
        }

        protected void doProcess(ITemplateContext theContext, IProcessableElementTag theTag, AttributeName theAttributeName, String theAttributeValue, IElementTagStructureHandler theStructureHandler) {
            IEngineConfiguration configuration = theContext.getConfiguration();
            IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
            IStandardExpression expression = expressionParser.parseExpression((IExpressionContext)theContext, theAttributeValue);
            Object value = expression.execute((IExpressionContext)theContext);
            if (value == null) {
                return;
            }
            Context context = new Context();
            context.setVariable("fhirVersion", (Object)this.fhirContext.getVersion().getVersion().name());
            context.setVariable("resource", value);
            String name = null;
            if (value != null) {
                Class<?> nextClass = value.getClass();
                do {
                    name = (String)CustomNarrativeGenerator.this.classToName.get(nextClass);
                    nextClass = nextClass.getSuperclass();
                } while (name == null && !nextClass.equals(Object.class));
                if (name == null) {
                    if (value instanceof IBaseResource) {
                        name = this.fhirContext.getResourceDefinition((Class)value).getName();
                    } else if (value instanceof IDatatype) {
                        name = value.getClass().getSimpleName();
                        name = name.substring(0, name.length() - 2);
                    } else if (value instanceof IBaseDatatype) {
                        name = value.getClass().getSimpleName();
                        if (name.endsWith("Type")) {
                            name = name.substring(0, name.length() - 4);
                        }
                    } else {
                        throw new DataFormatException("Don't know how to determine name for type: " + value.getClass());
                    }
                    name = name.toLowerCase();
                    if (!CustomNarrativeGenerator.this.nameToNarrativeTemplate.containsKey(name)) {
                        name = null;
                    }
                }
            }
            if (name == null) {
                logger.debug("No narrative template available for type: {}", value.getClass());
                return;
            }
            String result = CustomNarrativeGenerator.this.profileTemplateEngine.process(name, (IContext)context);
            String trim = result.trim();
            theStructureHandler.setBody((CharSequence)trim, true);
        }
    }

    private final class ProfileResourceResolver
    extends DefaultTemplateResolver {
        private ProfileResourceResolver() {
        }

        protected boolean computeResolvable(IEngineConfiguration theConfiguration, String theOwnerTemplate, String theTemplate, Map<String, Object> theTemplateResolutionAttributes) {
            String template = (String)CustomNarrativeGenerator.this.nameToNarrativeTemplate.get(theTemplate);
            return template != null;
        }

        protected TemplateMode computeTemplateMode(IEngineConfiguration theConfiguration, String theOwnerTemplate, String theTemplate, Map<String, Object> theTemplateResolutionAttributes) {
            return TemplateMode.XML;
        }

        protected ITemplateResource computeTemplateResource(IEngineConfiguration theConfiguration, String theOwnerTemplate, String theTemplate, Map<String, Object> theTemplateResolutionAttributes) {
            String template = (String)CustomNarrativeGenerator.this.nameToNarrativeTemplate.get(theTemplate);
            return new StringTemplateResource(template);
        }

        protected ICacheEntryValidity computeValidity(IEngineConfiguration theConfiguration, String theOwnerTemplate, String theTemplate, Map<String, Object> theTemplateResolutionAttributes) {
            return AlwaysValidCacheEntryValidity.INSTANCE;
        }
    }
}

