/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.po.service;

import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.IClinicalImpression;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFamilyMemberHistory;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IProcedureRequest;
import ch.elexis.core.findings.fhir.po.model.AbstractFhirPersistentObject;
import ch.elexis.core.findings.fhir.po.model.ClinicalImpression;
import ch.elexis.core.findings.fhir.po.model.Encounter;
import ch.elexis.core.findings.fhir.po.model.Observation;
import ch.elexis.core.findings.fhir.po.model.ProcedureRequest;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.dstu3.model.AllergyIntolerance;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.FamilyMemberHistory;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class FindingsService
implements IFindingsService {
    private Logger logger = LoggerFactory.getLogger(FindingsService.class);

    public <T extends IFinding> List<T> getPatientsFindings(String patientId, Class<T> filter) {
        ArrayList<AbstractFhirPersistentObject> ret = new ArrayList<AbstractFhirPersistentObject>();
        if (patientId != null && !patientId.isEmpty()) {
            if (filter.isAssignableFrom(IEncounter.class)) {
                ret.addAll(this.getEncounters(patientId));
            }
            if (filter.isAssignableFrom(ICondition.class)) {
                ret.addAll(this.getConditions(patientId));
            }
            if (filter.isAssignableFrom(IClinicalImpression.class)) {
                ret.addAll(this.getClinicalImpressions(patientId, null));
            }
            if (filter.isAssignableFrom(IObservation.class)) {
                ret.addAll(this.getObservations(patientId, null));
            }
            if (filter.isAssignableFrom(IProcedureRequest.class)) {
                ret.addAll(this.getProcedureRequests(patientId, null));
            }
            if (filter.isAssignableFrom(IFamilyMemberHistory.class)) {
                ret.addAll(this.getFamilyMemberHistory(patientId));
            }
            if (filter.isAssignableFrom(IAllergyIntolerance.class)) {
                ret.addAll(this.getAllergyIntolerance(patientId));
            }
        }
        return ret;
    }

    private List<ProcedureRequest> getProcedureRequests(String patientId, String encounterId) {
        Query query = new Query(ProcedureRequest.class);
        if (patientId != null) {
            query.add("patientid", "=", patientId);
        }
        if (encounterId != null) {
            query.add("encounterid", "=", encounterId);
        }
        return query.execute();
    }

    private List<ClinicalImpression> getClinicalImpressions(String patientId, String encounterId) {
        Query query = new Query(ClinicalImpression.class);
        if (patientId != null) {
            query.add("patientid", "=", patientId);
        }
        if (encounterId != null) {
            query.add("encounterid", "=", encounterId);
        }
        return query.execute();
    }

    private List<ch.elexis.core.findings.fhir.po.model.Condition> getConditions(String patientId) {
        Query query = new Query(ch.elexis.core.findings.fhir.po.model.Condition.class);
        if (patientId != null) {
            query.add("patientid", "=", patientId);
        }
        return query.execute();
    }

    private List<ch.elexis.core.findings.fhir.po.model.FamilyMemberHistory> getFamilyMemberHistory(String patientId) {
        Query query = new Query(ch.elexis.core.findings.fhir.po.model.FamilyMemberHistory.class);
        if (patientId != null) {
            query.add("patientid", "=", patientId);
        }
        return query.execute();
    }

    private List<ch.elexis.core.findings.fhir.po.model.AllergyIntolerance> getAllergyIntolerance(String patientId) {
        Query query = new Query(ch.elexis.core.findings.fhir.po.model.AllergyIntolerance.class);
        if (patientId != null) {
            query.add("patientid", "=", patientId);
        }
        return query.execute();
    }

    private List<Observation> getObservations(String patientId, String encounterId) {
        Query query = new Query(Observation.class);
        if (patientId != null) {
            query.add("patientid", "=", patientId);
        }
        if (encounterId != null) {
            query.add("encounterid", "=", encounterId);
        }
        return query.execute();
    }

    private List<Encounter> getEncounters(String patientId) {
        Query query = new Query(Encounter.class);
        if (patientId != null) {
            query.add("patientid", "=", patientId);
        }
        return query.execute();
    }

    public <T extends IFinding> List<T> getConsultationsFindings(String consultationId, Class<T> filter) {
        Optional<IEncounter> encounter;
        ArrayList<IFinding> ret = new ArrayList<IFinding>();
        if (consultationId != null && !consultationId.isEmpty() && (encounter = this.getEncounter(consultationId)).isPresent()) {
            if (filter.isAssignableFrom(IEncounter.class)) {
                ret.add((IFinding)encounter.get());
            }
            if (filter.isAssignableFrom(IClinicalImpression.class)) {
                ret.addAll(this.getClinicalImpressions(null, encounter.get().getId()));
            }
            if (filter.isAssignableFrom(IObservation.class)) {
                ret.addAll(this.getObservations(null, encounter.get().getId()));
            }
            if (filter.isAssignableFrom(IProcedureRequest.class)) {
                ret.addAll(this.getProcedureRequests(null, encounter.get().getId()));
            }
        }
        return ret;
    }

    private Optional<IEncounter> getEncounter(String consultationId) {
        Query query = new Query(Encounter.class);
        query.add("consultationid", "=", consultationId);
        List encounters = query.execute();
        if (encounters != null && !encounters.isEmpty()) {
            if (encounters.size() > 1) {
                this.logger.warn("Too many encounters [" + encounters.size() + "] found for consultation [" + consultationId + "] using first.");
            }
            return Optional.of((IEncounter)encounters.get(0));
        }
        return Optional.empty();
    }

    public void saveFinding(IFinding finding) {
        if (!(finding instanceof IPersistentObject)) {
            this.logger.error("Can not save IFinding which is not an IPersistentObject [" + finding + "]");
        } else if (!((IPersistentObject)finding).exists()) {
            this.logger.error("Can not save IFinding which does not exist in database [" + finding + "]");
        }
    }

    public void deleteFinding(IFinding finding) {
        if (!(finding instanceof IPersistentObject)) {
            this.logger.error("Can not delete IFinding which is not an IPersistentObject [" + finding + "]");
        } else if (!((IPersistentObject)finding).exists()) {
            this.logger.error("Can not delete IFinding which does not exist in database [" + finding + "]");
        } else {
            ((PersistentObject)finding).delete();
        }
    }

    public <T extends IFinding> Optional<T> findById(String id, Class<T> clazz, boolean skipChecks) {
        AbstractFhirPersistentObject loadedObj = null;
        if (clazz.isAssignableFrom(ICondition.class)) {
            loadedObj = ch.elexis.core.findings.fhir.po.model.Condition.load(id);
        } else if (clazz.isAssignableFrom(IObservation.class)) {
            loadedObj = Observation.load(id);
        }
        if (loadedObj != null) {
            if (!skipChecks) {
                if (((IPersistentObject)loadedObj).exists()) {
                    return Optional.of((IFinding)clazz.cast((Object)loadedObj));
                }
            } else {
                return Optional.of((IFinding)clazz.cast((Object)loadedObj));
            }
        }
        return Optional.empty();
    }

    public <T extends IFinding> T create(Class<T> type) {
        if (type.equals(IEncounter.class)) {
            Encounter ret = (Encounter)new Encounter().create();
            org.hl7.fhir.dstu3.model.Encounter fhirEncounter = new org.hl7.fhir.dstu3.model.Encounter();
            fhirEncounter.setId((IIdType)new IdType("Encounter", ret.getId()));
            ModelUtil.saveResource((IBaseResource)fhirEncounter, (IFinding)ret);
            return (T)((IFinding)type.cast((Object)ret));
        }
        if (type.equals(IObservation.class)) {
            Observation ret = (Observation)new Observation().create();
            org.hl7.fhir.dstu3.model.Observation fhirOberservation = new org.hl7.fhir.dstu3.model.Observation();
            fhirOberservation.setId((IIdType)new IdType("Observation", ret.getId()));
            ModelUtil.saveResource((IBaseResource)fhirOberservation, (IFinding)ret);
            return (T)((IFinding)type.cast((Object)ret));
        }
        if (type.equals(ICondition.class)) {
            ch.elexis.core.findings.fhir.po.model.Condition ret = (ch.elexis.core.findings.fhir.po.model.Condition)new ch.elexis.core.findings.fhir.po.model.Condition().create();
            Condition fhirCondition = new Condition();
            fhirCondition.setId((IIdType)new IdType("Condition", ret.getId()));
            fhirCondition.setAssertedDate(new Date());
            ModelUtil.saveResource((IBaseResource)fhirCondition, (IFinding)ret);
            return (T)((IFinding)type.cast((Object)ret));
        }
        if (type.equals(IClinicalImpression.class)) {
            ClinicalImpression ret = new ClinicalImpression();
            return (T)((IFinding)type.cast((IClinicalImpression)ret.create()));
        }
        if (type.equals(IProcedureRequest.class)) {
            ProcedureRequest ret = new ProcedureRequest();
            return (T)((IFinding)type.cast((IProcedureRequest)ret.create()));
        }
        if (type.equals(IFamilyMemberHistory.class)) {
            ch.elexis.core.findings.fhir.po.model.FamilyMemberHistory ret = (ch.elexis.core.findings.fhir.po.model.FamilyMemberHistory)new ch.elexis.core.findings.fhir.po.model.FamilyMemberHistory().create();
            FamilyMemberHistory fhFamilyMemberHistory = new FamilyMemberHistory();
            fhFamilyMemberHistory.setId((IIdType)new IdType("FamilyMemberHistory", ret.getId()));
            ModelUtil.saveResource((IBaseResource)fhFamilyMemberHistory, (IFinding)ret);
            return (T)((IFinding)type.cast((Object)ret));
        }
        if (type.equals(IAllergyIntolerance.class)) {
            ch.elexis.core.findings.fhir.po.model.AllergyIntolerance ret = (ch.elexis.core.findings.fhir.po.model.AllergyIntolerance)new ch.elexis.core.findings.fhir.po.model.AllergyIntolerance().create();
            AllergyIntolerance fhAllergyIntolerance = new AllergyIntolerance();
            fhAllergyIntolerance.setId((IIdType)new IdType("AllergyIntolerance", ret.getId()));
            ModelUtil.saveResource((IBaseResource)fhAllergyIntolerance, (IFinding)ret);
            return (T)((IFinding)type.cast((Object)ret));
        }
        return null;
    }
}

