/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.po.model;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.fhir.po.model.AbstractFhirPersistentObject;
import ch.elexis.core.findings.fhir.po.service.FindingsService;
import ch.elexis.core.findings.util.fhir.accessor.EncounterAccessor;
import ch.rgw.tools.VersionInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class Encounter
extends AbstractFhirPersistentObject
implements IEncounter {
    protected static final String TABLENAME = "CH_ELEXIS_CORE_FINDINGS_ENCOUNTER";
    protected static final String VERSION = "1.0.0";
    public static final String FLD_PATIENTID = "patientid";
    public static final String FLD_MANDATORID = "mandatorid";
    public static final String FLD_CONSULTATIONID = "consultationid";
    private EncounterAccessor accessor = new EncounterAccessor();
    protected static final String createDB = "CREATE TABLE CH_ELEXIS_CORE_FINDINGS_ENCOUNTER(ID\t\t\t\t\tVARCHAR(25) PRIMARY KEY,lastupdate \t\tBIGINT,deleted\t\t\tCHAR(1) default '0',patientid\t        VARCHAR(80),mandatorid         VARCHAR(80),consultationid     VARCHAR(80),content      \t\tTEXT);CREATE INDEX CH_ELEXIS_CORE_FINDINGS_ENCOUNTER_IDX1 ON CH_ELEXIS_CORE_FINDINGS_ENCOUNTER (patientid);CREATE INDEX CH_ELEXIS_CORE_FINDINGS_ENCOUNTER_IDX2 ON CH_ELEXIS_CORE_FINDINGS_ENCOUNTER (consultationid);INSERT INTO CH_ELEXIS_CORE_FINDINGS_ENCOUNTER (ID, patientid) VALUES ('VERSION','1.0.0');";

    static {
        Encounter.addMapping((String)TABLENAME, (String[])new String[]{FLD_PATIENTID, FLD_MANDATORID, FLD_CONSULTATIONID, "content"});
        Encounter version = Encounter.load("VERSION");
        if (version.state() < 2) {
            Encounter.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(version.get(FLD_PATIENTID));
            if (vi.isOlder(VERSION)) {
                version.set(FLD_PATIENTID, VERSION);
            }
        }
    }

    public static Encounter load(String id) {
        return new Encounter(id);
    }

    protected Encounter(String id) {
        super(id);
    }

    public Encounter() {
    }

    public String getLabel() {
        return null;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getPatientId() {
        return this.get(FLD_PATIENTID);
    }

    public void setPatientId(String patientId) {
        this.set(FLD_PATIENTID, patientId);
    }

    public String getConsultationId() {
        return this.get(FLD_CONSULTATIONID);
    }

    public void setConsultationId(String consultationId) {
        this.set(FLD_CONSULTATIONID, consultationId);
    }

    public String getMandatorId() {
        return this.get(FLD_MANDATORID);
    }

    public void setMandatorId(String serviceProviderId) {
        this.set(FLD_MANDATORID, serviceProviderId);
    }

    public Optional<LocalDateTime> getStartTime() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getStartTime((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setStartTime(LocalDateTime time) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setStartTime((DomainResource)resource.get(), time);
            this.saveResource(resource.get());
        }
    }

    public Optional<LocalDateTime> getEndTime() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getEndTime((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setEndTime(LocalDateTime time) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setEndTime((DomainResource)resource.get(), time);
            this.saveResource(resource.get());
        }
    }

    public List<ICondition> getIndication() {
        ArrayList<ICondition> indication = new ArrayList<ICondition>();
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getIndication((DomainResource)resource.get(), (IFindingsService)new FindingsService());
        }
        return indication;
    }

    public void setIndication(List<ICondition> indication) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setIndication((DomainResource)resource.get(), indication);
            this.saveResource(resource.get());
        }
    }

    public List<ICoding> getType() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getType((DomainResource)resource.get());
        }
        return Collections.emptyList();
    }

    public void setType(List<ICoding> coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setType((DomainResource)resource.get(), coding);
            this.saveResource(resource.get());
        }
    }
}

