/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.po.model;

import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.fhir.po.model.AbstractFhirPersistentObject;
import ch.elexis.core.findings.util.fhir.accessor.AllergyIntoleranceAccessor;
import ch.rgw.tools.VersionInfo;
import java.util.Optional;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class AllergyIntolerance
extends AbstractFhirPersistentObject
implements IAllergyIntolerance {
    protected static final String TABLENAME = "CH_ELEXIS_CORE_FINDINGS_ALLERGYINTOLERANCE";
    protected static final String VERSION = "1.0.0";
    public static final String FLD_PATIENTID = "patientid";
    private AllergyIntoleranceAccessor accessor = new AllergyIntoleranceAccessor();
    protected static final String createDB = "CREATE TABLE CH_ELEXIS_CORE_FINDINGS_ALLERGYINTOLERANCE(ID\t\t\t\t\tVARCHAR(25) PRIMARY KEY,lastupdate \t\tBIGINT,deleted\t\t\tCHAR(1) default '0',patientid\t        VARCHAR(80),content      \t\tTEXT);CREATE INDEX CH_ELEXIS_CORE_FINDINGS_ALLERGYINTOLERANCE_IDX1 ON CH_ELEXIS_CORE_FINDINGS_ALLERGYINTOLERANCE (patientid);INSERT INTO CH_ELEXIS_CORE_FINDINGS_ALLERGYINTOLERANCE (ID, patientid) VALUES ('VERSION','1.0.0');";

    static {
        AllergyIntolerance.addMapping((String)TABLENAME, (String[])new String[]{FLD_PATIENTID, "content"});
        AllergyIntolerance version = AllergyIntolerance.load("VERSION");
        if (version.state() < 2) {
            AllergyIntolerance.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(version.get(FLD_PATIENTID));
            if (vi.isOlder(VERSION)) {
                version.set(FLD_PATIENTID, VERSION);
            }
        }
    }

    public static AllergyIntolerance load(String id) {
        return new AllergyIntolerance(id);
    }

    protected AllergyIntolerance(String id) {
        super(id);
    }

    public AllergyIntolerance() {
    }

    public String getLabel() {
        return null;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getPatientId() {
        return this.get(FLD_PATIENTID);
    }

    public void setPatientId(String patientId) {
        this.set(FLD_PATIENTID, patientId);
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setPatientId((DomainResource)resource.get(), patientId);
            this.saveResource(resource.get());
        }
    }
}

