/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.po.codes;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.codes.ICodingContribution;
import ch.elexis.core.findings.codes.ILocalCodingContribution;
import ch.elexis.core.findings.fhir.po.codes.LocalCoding;
import ch.elexis.data.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;

@Component
public class LocalCodingContribution
implements ICodingContribution,
ILocalCodingContribution {
    public String getCodeSystem() {
        return CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem();
    }

    public List<ICoding> getCodes() {
        Query query = new Query(LocalCoding.class);
        query.add("id", "<>", "VERSION");
        return new ArrayList<ICoding>(query.execute());
    }

    public void addCoding(ICoding coding) {
        Optional<ICoding> exists;
        if (coding.getSystem().equals(this.getCodeSystem()) && !(exists = this.getCodingByCode(coding.getCode())).isPresent()) {
            new LocalCoding(coding);
        }
    }

    private Optional<ICoding> getCodingByCode(String code) {
        Query query = new Query(LocalCoding.class);
        query.add("id", "<>", "1.0.0");
        if (code != null && code.isEmpty()) {
            query.startGroup();
            query.add("code", "=", code);
            query.or();
            query.add("code", "=", null);
            query.endGroup();
        } else {
            query.add("code", "=", code);
        }
        List existing = query.execute();
        if (!existing.isEmpty()) {
            return Optional.of((ICoding)existing.get(0));
        }
        return Optional.empty();
    }

    public void removeCoding(ICoding coding) {
        if (coding.getSystem().equals(this.getCodeSystem())) {
            Optional<ICoding> exists = this.getCodingByCode(coding.getCode());
            exists.ifPresent(existing -> {
                boolean bl = ((LocalCoding)((Object)existing)).delete();
            });
        }
    }

    public Optional<ICoding> getCode(String code) {
        return this.getCodingByCode(code);
    }
}

