/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.viollier.v2.util;

import ch.rgw.io.FileTool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

public class ViollierLogger {
    private final String LOG_FILENAMEPATH = String.valueOf(System.getProperty("user.home")) + File.separator + "elexis" + File.separator + "Viollier.log";
    private final String LOG_BACKUP_FILENAME = "Viollier_%1$tY%1$tm%1$td%1$tH%1$tM%1$tS.log";
    private PrintStream log;
    private static ViollierLogger logger = null;
    private String insetStr = "";

    public static ViollierLogger getLogger() {
        if (logger == null) {
            logger = new ViollierLogger();
        }
        return logger;
    }

    public ViollierLogger() {
        this.initLogger();
    }

    private void initLogger() {
        try {
            this.log = new PrintStream(new FileOutputStream(this.LOG_FILENAMEPATH, true));
        }
        catch (FileNotFoundException e) {
            this.log = System.out;
        }
    }

    public String getLocation() {
        return this.LOG_FILENAMEPATH;
    }

    public void println(String s) {
        this.log.println(String.valueOf(this.insetStr) + s);
    }

    public void print(String s) {
        this.log.print(String.valueOf(this.insetStr) + s);
    }

    public void addInset() {
        this.insetStr = String.valueOf(this.insetStr) + "   ";
    }

    public void removeInset() {
        if (this.insetStr.length() > 0) {
            this.insetStr = this.insetStr.substring(0, this.insetStr.length() - 3);
        }
    }

    public String getContent() {
        String content = "-";
        try {
            content = FileTool.readTextFile((File)new File(this.LOG_FILENAMEPATH));
        }
        catch (IOException e) {
            content = e.getMessage();
        }
        return content;
    }

    public void deleteLog() throws IOException {
        this.log.close();
        new File(this.LOG_FILENAMEPATH).delete();
        new File(this.LOG_FILENAMEPATH).createNewFile();
        this.initLogger();
    }

    public void backupLog(String backupDir) throws IOException {
        this.log.close();
        new File(this.LOG_FILENAMEPATH).renameTo(new File(String.valueOf(backupDir) + File.separator + String.format("Viollier_%1$tY%1$tm%1$td%1$tH%1$tM%1$tS.log", new Date())));
        new File(this.LOG_FILENAMEPATH).createNewFile();
        this.initLogger();
    }

    protected void finalize() throws Throwable {
        if (this.log != null) {
            this.log.close();
        }
    }
}

