/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.viollier.v2.data;

import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import java.util.List;

public class LaborwerteOrderManagement
extends PersistentObject {
    public static final String TABLENAME = "LABORWERTE_ORDER_JOINT";
    public static final String FLD_LABRESULT_ID = "LABRESULT_ID";
    public static final String FLD_ORDER_ID = "ORDER_ID";
    private static final String FLD_VERSION = "LABRESULT_ID";
    private static final String VERSION = "1";
    private static final String index1SQL = "CREATE INDEX LABORWERTE_ORDER_JOINT_idx_labresult on LABORWERTE_ORDER_JOINT(LABRESULT_ID);";
    private static final String index2SQL = "CREATE INDEX LABORWERTE_ORDER_JOINT_idx_order on LABORWERTE_ORDER_JOINT(ORDER_ID);";
    private static final String index3SQL = "CREATE UNIQUE INDEX LABORWERTE_ORDER_JOINT_idx_joint on LABORWERTE_ORDER_JOINT(LABRESULT_ID, ORDER_ID);";
    private static final String createDB = "CREATE TABLE LABORWERTE_ORDER_JOINT(ID VARCHAR(25) primary key,LABRESULT_ID VARCHAR(25),ORDER_ID VARCHAR(25),lastupdate BIGINT,deleted CHAR(1) default '0');CREATE INDEX LABORWERTE_ORDER_JOINT_idx_labresult on LABORWERTE_ORDER_JOINT(LABRESULT_ID);CREATE INDEX LABORWERTE_ORDER_JOINT_idx_order on LABORWERTE_ORDER_JOINT(ORDER_ID);CREATE UNIQUE INDEX LABORWERTE_ORDER_JOINT_idx_joint on LABORWERTE_ORDER_JOINT(LABRESULT_ID, ORDER_ID);";
    private static final String insertVersion = "insert into LABORWERTE_ORDER_JOINT (ID,LABRESULT_ID) VALUES ('VERSION', " + JdbcLink.wrap((String)"1") + ");";

    static {
        LaborwerteOrderManagement.addMapping((String)TABLENAME, (String[])new String[]{"LABRESULT_ID", FLD_ORDER_ID});
        LaborwerteOrderManagement.checkTable();
    }

    private static void checkTable() {
        LaborwerteOrderManagement check = LaborwerteOrderManagement.load("VERSION");
        if (!check.exists()) {
            LaborwerteOrderManagement.createOrModifyTable((String)(createDB + insertVersion));
        }
    }

    public LaborwerteOrderManagement(String laborwertID, String orderNrString) {
        this.create(null);
        this.set(new String[]{"LABRESULT_ID", FLD_ORDER_ID}, new String[]{laborwertID, orderNrString});
    }

    public static String findOrderId(String labResultId) {
        Query qbe = new Query(LaborwerteOrderManagement.class);
        qbe.add("LABRESULT_ID", "=", labResultId);
        List ret = qbe.execute();
        if (ret.size() > 0) {
            LaborwerteOrderManagement result = (LaborwerteOrderManagement)((Object)ret.get(0));
            return result.getOrderId();
        }
        return null;
    }

    private LaborwerteOrderManagement(String id) {
        super(id);
    }

    public LaborwerteOrderManagement() {
    }

    public static LaborwerteOrderManagement load(String id) {
        return new LaborwerteOrderManagement(id);
    }

    public String getOrderId() {
        return this.get(FLD_ORDER_ID);
    }

    public String getLabel() {
        return this.getId();
    }

    protected String getTableName() {
        return TABLENAME;
    }
}

