/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.eurolyser;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.beans.ContactBean;
import ch.elexis.core.importer.div.importers.ILabImportUtil;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.importer.div.importers.LabImportUtil;
import ch.elexis.core.ui.laboratory.dialogs.LabItemSelektor;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabMapping;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurolyserLine {
    private static Logger logger = LoggerFactory.getLogger(EurolyserLine.class);
    private Labor labor;
    private String line;
    private String mandantId;
    private String patientId;
    private String patientName;
    private String resultItemName;
    private String resultValue;
    private String resultUnit;
    private String resultObservationTime;

    public EurolyserLine(Labor labor, String line) {
        this.labor = labor;
        this.line = line;
        this.parseLine();
    }

    private void parseLine() {
        String[] parts = this.line.split(";");
        if (parts.length != 5) {
            throw new IllegalStateException("Result line [" + this.line + "] is not valid");
        }
        this.mandantId = this.getMandantId(parts[0]);
        this.patientId = this.getPatientId(parts[0]);
        this.patientName = parts[1];
        this.resultItemName = parts[2];
        this.resultValue = this.getResultValue(parts[3]);
        this.resultUnit = this.getResultUnit(parts[3]);
        this.resultObservationTime = parts[4];
    }

    private String getResultUnit(String string) {
        String[] parts = string.split(" ");
        if (parts.length > 1) {
            return parts[1].trim();
        }
        return "";
    }

    private String getResultValue(String string) {
        String[] parts = string.split(" ");
        if (parts.length > 0) {
            return parts[0].trim();
        }
        throw new IllegalStateException("Result line [" + this.line + "] has no result");
    }

    private String getPatientId(String string) {
        char[] chars = string.toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean notNullFound = false;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isDigit(c)) {
                if (c != '0') {
                    notNullFound = true;
                }
                if (notNullFound) {
                    sb.append(c);
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    private String getMandantId(String string) {
        char[] chars = string.toCharArray();
        StringBuilder sb = new StringBuilder();
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isDigit(c)) {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public boolean isRelevant() {
        String confMandantId = CoreHub.mandantCfg.get("eurolyser/import/mandantonly", "").trim();
        if (!confMandantId.isEmpty()) {
            return confMandantId.equalsIgnoreCase(this.mandantId);
        }
        return true;
    }

    public TransientLabResult createResult(HashMap<String, Patient> filePatientMap) {
        Patient patient = this.resolvePatient(filePatientMap);
        if (patient == null) {
            AskAbortRunnable askAbort = new AskAbortRunnable();
            Display.getDefault().syncExec((Runnable)askAbort);
            if (askAbort.getResult()) {
                throw new RuntimeException("Import aborted");
            }
        }
        filePatientMap.put(this.patientId, patient);
        LabItem labItem = this.resolveLabItem();
        if (labItem == null) {
            AskCreateItemRunnable askCreate = new AskCreateItemRunnable();
            Display.getDefault().syncExec((Runnable)askCreate);
            if (askCreate.getResult()) {
                labItem = new LabItem(this.resultItemName, this.resultItemName, null, null, null, this.resultUnit, LabItemTyp.NUMERIC, "Eurolyser", "0");
                new LabMapping(this.labor.getId(), this.resultItemName, labItem.getId(), false);
            }
        }
        if (labItem != null && patient != null) {
            TimeTool analyseTime = new TimeTool(this.resultObservationTime);
            TransientLabResult result = new TransientLabResult.Builder((IPatient)new ContactBean((Kontakt)patient), (IContact)new ContactBean((Kontakt)this.labor), (ILabItem)labItem, this.resultValue).unit(this.resultUnit).analyseTime(analyseTime).build((ILabImportUtil)new LabImportUtil());
            return result;
        }
        return null;
    }

    private LabItem resolveLabItem() {
        LabItem item = LabImportUtil.getLabItem((String)this.resultItemName, (Labor)this.labor);
        if (item == null) {
            Display display = Display.getDefault();
            LabItemSelectionRunnable runnable = new LabItemSelectionRunnable(this.resultItemName);
            display.syncExec((Runnable)runnable);
            item = runnable.getLabItem();
        }
        return item;
    }

    private Patient resolvePatient(HashMap<String, Patient> filePatientMap) {
        Patient p;
        String lastname = "";
        String firstname = "";
        String[] nameParts = this.patientName.split(" ");
        if (nameParts.length > 0) {
            lastname = nameParts[0];
        }
        if (nameParts.length > 1) {
            firstname = nameParts[1];
        }
        if ((p = Patient.loadByPatientID((String)this.patientId)) != null && p.isValid() && p.getVorname().equalsIgnoreCase(firstname) && p.getName().equalsIgnoreCase(lastname)) {
            logger.info("Patient " + p.getLabel() + " found by PracitceID [" + this.patientId + "]");
            return p;
        }
        p = filePatientMap.get(this.patientId);
        if (p != null) {
            return p;
        }
        return (Patient)KontaktSelektor.showInSync(Patient.class, (String)"Patient ausw\u00e4hlen", (String)("Wer ist " + lastname + " " + firstname + "?"));
    }

    private class AskAbortRunnable
    implements Runnable {
        private boolean result;

        private AskAbortRunnable() {
        }

        @Override
        public void run() {
            this.result = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Abbrechen", (String)"Kein Patient ausgew\u00e4hlt. Soll der gesamte Import abgerochen werden?");
        }

        public boolean getResult() {
            return this.result;
        }
    }

    private class AskCreateItemRunnable
    implements Runnable {
        private boolean result;

        private AskCreateItemRunnable() {
        }

        @Override
        public void run() {
            this.result = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Labor Parameter", (String)"Kein Labor Parameter ausgew\u00e4hlt. Soll ein neuer angelegt werden?");
        }

        public boolean getResult() {
            return this.result;
        }
    }

    private class LabItemSelectionRunnable
    implements Runnable {
        private LabItem labItem;
        private String labItemName;

        public LabItemSelectionRunnable(String labItemName) {
            this.labItemName = labItemName;
        }

        public LabItem getLabItem() {
            return this.labItem;
        }

        @Override
        public void run() {
            List items;
            LabItemSelektor selektor = new LabItemSelektor(Display.getDefault().getActiveShell());
            selektor.create();
            selektor.setMessage("Labor Parameter [" + this.labItemName + "] ausw\u00e4hlen.");
            if (selektor.open() == 0 && !(items = selektor.getSelection()).isEmpty()) {
                new LabMapping(EurolyserLine.this.labor.getId(), this.labItemName, ((LabItem)items.get(0)).getId(), false);
                this.labItem = (LabItem)items.get(0);
                logger.info("Item mapping created for " + this.labItem.getLabel());
            }
        }
    }
}

