/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.docbox.ws.client;

import ch.docbox.ws.cdachservicesv2.CDACHServicesV2;
import ch.elexis.docbox.ws.client.WsClientConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsClientUtil {
    private static Logger logger = LoggerFactory.getLogger(WsClientUtil.class);
    private static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final String toHex(byte[] v) {
        String out = "";
        int i = 0;
        while (i < v.length) {
            out = String.valueOf(out) + hex[v[i] >> 4 & 0xF] + hex[v[i] & 0xF];
            ++i;
        }
        return out;
    }

    public static String getSHA1(String password) {
        if (password == null || "".equals(password)) {
            return "";
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
            md.update(password.getBytes("UTF-8"));
            byte[] digest = md.digest();
            return WsClientUtil.toHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            logger.error("Error", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            logger.error("Error", (Throwable)e);
        }
        return "";
    }

    public static boolean checkAccess(CDACHServicesV2 port) {
        Holder _checkAccess_success = new Holder();
        Holder _checkAccess_message = new Holder();
        port.checkAccess((Holder<Boolean>)_checkAccess_success, (Holder<String>)_checkAccess_message);
        logger.debug("checkAccess._checkAccess_success=" + _checkAccess_success.value);
        logger.debug("checkAccess._checkAccess_message=" + (String)_checkAccess_message.value);
        return (Boolean)_checkAccess_success.value;
    }

    public static void addWsSecurityAndHttpConfigWithClientCert(Service ss, final String username, final String password, final String p12, final String jks, final String passwordP12, final String passwordJks) {
        String url = WsClientConfig.getDocboxServiceUrl();
        final boolean clientcert = url.contains("ihe");
        ss.setHandlerResolver(new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo portInfo) {
                ArrayList<Handler> handlerList = new ArrayList<Handler>();
                handlerList.add((Handler)new SecurityHandler(username, password, clientcert, p12, jks, passwordP12, passwordJks));
                return handlerList;
            }
        });
    }

    public static boolean isMedelexisCertAvailable() {
        InputStream keyInputStream = null;
        InputStream certInputStream = null;
        try {
            certInputStream = WsClientUtil.class.getResourceAsStream("/cert/MedElexis_MedElexis.p12");
            keyInputStream = WsClientUtil.class.getResourceAsStream("/cert/cert.key");
            boolean bl = certInputStream != null && keyInputStream != null;
            return bl;
        }
        finally {
            if (keyInputStream != null) {
                try {
                    keyInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (certInputStream != null) {
                try {
                    certInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class SecurityHandler
    implements SOAPHandler<SOAPMessageContext> {
        private String username;
        private String password;
        private boolean clientcert;
        private String p12;
        private String jks;
        private String passwordP12;
        private String passwordJks;

        public SecurityHandler(String username, String password, boolean clientcert, String p12, String jks, String passwordP12, String passwordJks) {
            this.username = username;
            this.password = password;
            this.clientcert = clientcert;
            this.p12 = p12;
            this.jks = jks;
            this.passwordP12 = passwordP12;
            this.passwordJks = passwordJks;
        }

        public Set<QName> getHeaders() {
            return new TreeSet<QName>();
        }

        /*
         * Exception decompiling
         */
        public boolean handleMessage(SOAPMessageContext context) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private InputStream getCertInputStream() {
            InputStream certInputStream = WsClientUtil.class.getResourceAsStream("/cert/MedElexis_MedElexis.p12");
            if (certInputStream != null) {
                logger.info("Using fragment Cert.");
                return certInputStream;
            }
            try {
                File keystore = new File(this.p12);
                logger.info("Using configured Cert.");
                return new FileInputStream(keystore);
            }
            catch (FileNotFoundException e) {
                logger.warn("Could not load cert." + e);
                return null;
            }
        }

        private char[] getCertPass() {
            InputStream keyInputStream = WsClientUtil.class.getResourceAsStream("/cert/cert.key");
            if (keyInputStream != null) {
                char[] chars = new char[1024];
                InputStreamReader reader = new InputStreamReader(keyInputStream);
                try {
                    int len = reader.read(chars);
                    byte[] decoded = Base64.decodeBase64((String)new String(chars, 0, len));
                    char[] cArray = new String(decoded, "UTF-8").toCharArray();
                    return cArray;
                }
                catch (IOException e) {
                    logger.warn("Could not load cert." + e);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        if (keyInputStream != null) {
                            keyInputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            return this.passwordP12.toCharArray();
        }

        public boolean handleFault(SOAPMessageContext context) {
            return true;
        }

        public void close(MessageContext context) {
        }
    }
}

