/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.docbox.ws.client;

import ch.docbox.ws.cdachservicesv2.CDACHServicesV2;
import ch.docbox.ws.cdachservicesv2.CDACHServicesV2_Service;
import ch.elexis.docbox.ws.client.CdaUtil;
import ch.elexis.docbox.ws.client.WsClientConfig;
import ch.elexis.docbox.ws.client.WsClientUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBException;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import org.hl7.v3.ClinicalDocumentType;
import org.hl7.v3.POCDMT000040ClinicalDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendClinicalDocumentClient {
    private static Logger logger = LoggerFactory.getLogger(SendClinicalDocumentClient.class);
    private CDACHServicesV2_Service service;
    private CDACHServicesV2 port;
    private Holder<Boolean> success = new Holder();
    private Holder<String> message = new Holder();
    private Holder<String> documentId = new Holder();

    public SendClinicalDocumentClient() {
        this.service = new CDACHServicesV2_Service();
        WsClientUtil.addWsSecurityAndHttpConfigWithClientCert(this.service, String.valueOf(WsClientConfig.getSecretkey()) + WsClientConfig.getUsername(), WsClientConfig.getPassword(), WsClientConfig.getP12Path(), null, WsClientConfig.getP12Password(), null);
    }

    public boolean hasAccess() {
        if (this.port == null) {
            this.port = this.service.getCDACHServicesV2();
            ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", WsClientConfig.getDocboxServiceUrl());
        }
        return WsClientUtil.checkAccess(this.port);
    }

    public boolean sendClinicalDocument(InputStream xmlFile, InputStream pdfFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException("XML input is null.");
        }
        if (this.port == null) {
            this.port = this.service.getCDACHServicesV2();
            ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", WsClientConfig.getDocboxServiceUrl());
        }
        POCDMT000040ClinicalDocument clinicalDocument = null;
        try {
            clinicalDocument = CdaUtil.unmarshall(xmlFile);
            ClinicalDocumentType clinicalDocumentType = new ClinicalDocumentType();
            clinicalDocumentType.setClinicalDocument(clinicalDocument);
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (pdfFile != null) {
                try {
                    int len;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    ZipOutputStream out = new ZipOutputStream(byteArrayOutputStream);
                    out.putNextEntry(new ZipEntry("file.pdf"));
                    byte[] buffer = new byte[1024];
                    while ((len = pdfFile.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.closeEntry();
                    out.close();
                }
                catch (IOException e) {
                    logger.error("Could not attach pdf.", (Throwable)e);
                    byteArrayOutputStream = null;
                }
            }
            this.port.sendClinicalDocument(clinicalDocumentType, byteArrayOutputStream != null ? byteArrayOutputStream.toByteArray() : null, this.success, this.message, this.documentId);
        }
        catch (JAXBException e) {
            logger.error("XML input is not a valid clinical document.", (Throwable)e);
            return false;
        }
        if (!((Boolean)this.success.value).booleanValue()) {
            logger.error("Could not send clinical document. " + (String)this.message.value);
            if (clinicalDocument != null) {
                logger.debug(CdaUtil.marshallIntoString(clinicalDocument));
            }
        } else {
            logger.debug("Sent document " + (String)this.message.value);
        }
        return (Boolean)this.success.value;
    }

    public String getDocumentId() {
        return (String)this.documentId.value;
    }

    public String getMessage() {
        return (String)this.message.value;
    }
}

