/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.mythic;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.beans.ContactBean;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.importer.div.importers.ILabImportUtil;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.importer.div.importers.DefaultLabImportUiHandler;
import ch.elexis.core.ui.importer.div.importers.LabImportUtil;
import ch.elexis.core.ui.importer.div.rs232.Connection;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MythicAction
extends Action
implements Connection.ComPortListener {
    private static final int MODE_AWAIT_START = 0;
    private static final int MODE_AWAIT_LINES = 1;
    private final int mode = 0;
    Connection ctrl = new Connection("Elexis-Mythic", CoreHub.localCfg.get("connectors/mythic/port", "COM1"), CoreHub.localCfg.get("connectors/mythic/params", "9600,8,n,1"), (Connection.ComPortListener)this);
    Labor myLab;
    Patient actPatient;
    String[] results = new String[]{"WBC", "RBC", "HGB", "HCT", "MCV", "MCH", "MCHC", "RDW", "PLT", "MPV", "THT", "PDW", "LYM%", "MON%", "GRA%", "LYM", "MON", "GRA"};
    String[] units = new String[]{"G/l", "G/l", "g/dl", "%", "fl", "pg", "g/dl", "%", "G/l", "fl", "%", "%", "%", "%", "%", "G/l", "G/l", "G/l"};

    public MythicAction() {
        super("Mythic", 2);
        this.setToolTipText("Daten von Mythic einlesen");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.connect.mythic", (String)"icons/mythic.ico"));
        this.myLab = LabImportUtil.getOrCreateLabor((String)"Mythic");
    }

    public void run() {
        if (this.isChecked()) {
            KontaktSelektor ksl = new KontaktSelektor(Hub.getActiveShell(), Patient.class, "Patient ausw\u00e4hlen", "Wem soll der Mythic-Befund zugeordnet werden?", Patient.DEFAULT_SORT);
            ksl.create();
            ksl.getShell().setText("Mythic Patientenauswahl");
            if (ksl.open() == 0) {
                this.actPatient = (Patient)ksl.getSelection();
                if (this.ctrl.connect()) {
                    this.ctrl.readLine((byte)13, 600);
                    return;
                }
                SWTHelper.showError((String)"Fehler mit Port", (String)"Konnte seriellen Port nicht \u00f6ffnen");
            }
        } else if (this.ctrl.isOpen()) {
            this.actPatient = null;
            this.ctrl.sendBreak();
            this.ctrl.close();
        }
        this.setChecked(false);
    }

    public void gotBreak(Connection connection) {
        this.actPatient = null;
        connection.close();
        SWTHelper.showError((String)"Mythic", (String)"Daten\u00fcbertragung wurde unterbrochen");
    }

    public void gotChunk(Connection connection, String data) {
        if (this.actPatient != null) {
            if (data.startsWith("END_RESULT")) {
                this.actPatient = null;
                this.ctrl.close();
                this.setChecked(false);
                ElexisEventDispatcher.reload(LabItem.class);
            } else {
                this.fetchResult(data);
            }
        }
    }

    private void fetchResult(String data) {
        String[] line = data.split(";");
        int idx = StringTool.getIndex((String[])this.results, (String)line[0]);
        if (idx != -1 && line.length > 7) {
            LabItem li = LabImportUtil.getLabItem((String)line[0], (Labor)this.myLab);
            if (li == null) {
                String ref = String.valueOf(line[5]) + "-" + line[6];
                li = new LabItem(line[0], line[0], (Kontakt)this.myLab, ref, ref, this.units[idx], LabItemTyp.NUMERIC, "MTH Mythic", "50");
            }
            String comment = "";
            if (line[2].length() > 0 || line[3].length() > 0) {
                comment = String.valueOf(line[2]) + ";" + line[3];
            }
            LabImportUtil lu = new LabImportUtil();
            TransientLabResult tLabResult = new TransientLabResult.Builder((IPatient)new ContactBean((Kontakt)this.actPatient), (IContact)new ContactBean((Kontakt)this.myLab), (ILabItem)li, line[1]).date(new TimeTool()).comment(comment).build((ILabImportUtil)lu);
            lu.importLabResults(Collections.singletonList(tLabResult), (ImportHandler)new DefaultLabImportUiHandler());
        }
    }

    public void timeout() {
        this.ctrl.close();
        SWTHelper.showError((String)"Mythic", (String)"Das Ger\u00e4t antwortet nicht");
        this.setChecked(false);
    }
}

