/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.archie.patientstatistik;

import ch.elexis.archie.patientstatistik.Counter;
import ch.elexis.archie.patientstatistik.Messages;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.part.ViewPart;

public class VerrechnungsStatistikView
extends ViewPart
implements IActivationListener,
Counter.IJobFinishedListener {
    private Action recalcAction;
    private Action exportCSVAction;
    Form form;
    Table table;
    String[] tableHeaders = new String[]{Messages.VerrechnungsStatistikView_CODESYSTEM, Messages.VerrechnungsStatistikView_CODE, Messages.VerrechnungsStatistikView_TEXT, Messages.VerrechnungsStatistikView_NUMBER, Messages.VerrechnungsStatistikView_AMOUNT};
    int[] columnWidths = new int[]{130, 60, 160, 40, 50};
    private ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        public void runInUi(ElexisEvent ev) {
            if (ev.getType() == 16) {
                Patient pat = (Patient)ev.getObject();
                VerrechnungsStatistikView.this.form.setText(pat.getLabel());
                VerrechnungsStatistikView.this.recalc();
            } else if (ev.getType() == 32) {
                VerrechnungsStatistikView.this.form.setText(Messages.VerrechnungsStatistikView_NoPatientSelected);
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.form = UiDesk.getToolkit().createForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.form.getBody().setLayout((Layout)new GridLayout());
        this.table = new Table(this.form.getBody(), 0);
        this.table.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        int i = 0;
        while (i < this.tableHeaders.length) {
            TableColumn tc = new TableColumn(this.table, 0);
            tc.setText(this.tableHeaders[i]);
            tc.setWidth(this.columnWidths[i]);
            ++i;
        }
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(new IAction[]{this.exportCSVAction, this.recalcAction});
        menu.createMenu(new IAction[]{this.exportCSVAction});
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    public void setFocus() {
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat});
            this.eeli_pat.catchElexisEvent(ElexisEvent.createPatientEvent());
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat});
        }
    }

    public void clearEvent(Class<? extends PersistentObject> template) {
    }

    private void recalc() {
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        if (pat != null) {
            Counter counter = new Counter(pat, null, null, this);
            this.table.removeAll();
            counter.schedule();
        }
    }

    @Override
    public void jobFinished(Counter counter) {
        HashMap<IVerrechenbar, List<Verrechnet>> cnt = counter.getValues();
        HashMap<String, Money> totals = new HashMap<String, Money>();
        ArrayList<IVerrechenbar> set = new ArrayList<IVerrechenbar>(cnt.keySet());
        Collections.sort(set, new Comparator<IVerrechenbar>(){

            @Override
            public int compare(IVerrechenbar o1, IVerrechenbar o2) {
                if (o1 != null && o2 != null) {
                    String csname2;
                    String csname1 = o1.getCodeSystemName();
                    int res = csname1.compareTo(csname2 = o2.getCodeSystemName());
                    if (res == 0) {
                        String cscode1 = o1.getCode();
                        String cscode2 = o2.getCode();
                        res = cscode1.compareTo(cscode2);
                    }
                    return res;
                }
                return 0;
            }
        });
        for (IVerrechenbar iv : set) {
            if (iv == null) continue;
            TableItem ti = new TableItem(this.table, 0);
            String codename = iv.getCodeSystemName();
            Money tCode = (Money)totals.get(codename);
            if (tCode == null) {
                tCode = new Money();
                totals.put(codename, tCode);
            }
            ti.setText(0, StringTool.unNull((String)codename));
            ti.setText(1, StringTool.unNull((String)iv.getCode()));
            ti.setText(2, StringTool.unNull((String)iv.getText()));
            Money total = new Money();
            int count = 0;
            for (Verrechnet vv : cnt.get(iv)) {
                Money singlePrice = vv.getNettoPreis();
                int num = vv.getZahl();
                singlePrice.multiply((double)num);
                total.addMoney(singlePrice);
                count += num;
            }
            tCode.addMoney(total);
            ti.setText(3, Integer.toString(count));
            ti.setText(4, total.getAmountAsString());
        }
        Money sumAll = new Money();
        for (String n : totals.keySet()) {
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(0, String.valueOf(Messages.VerrechnungsStatistikView_SUM) + n);
            Money sumClass = (Money)totals.get(n);
            ti.setText(4, sumClass.getAmountAsString());
            sumAll.addMoney(sumClass);
        }
        TableItem ti = new TableItem(this.table, 1);
        ti.setText(0, Messages.VerrechnungsStatistikView_SUMTOTAL);
        ti.setText(4, sumAll.getAmountAsString());
    }

    private void makeActions() {
        this.recalcAction = new Action(Messages.VerrechnungsStatistikView_REFRESH, Images.IMG_REFRESH.getImageDescriptor()){

            public void run() {
                VerrechnungsStatistikView.this.recalc();
            }
        };
        this.exportCSVAction = new Action(Messages.VerrechnungsStatistikView_ExportToCSV, Images.IMG_EXPORT.getImageDescriptor()){

            public void run() {
                FileDialog fd = new FileDialog(VerrechnungsStatistikView.this.getViewSite().getShell(), 8192);
                fd.setFilterExtensions(new String[]{"*.csv", "*.*"});
                fd.setFilterNames(new String[]{"CSV", Messages.VerrechnungsStatistikView_AllFiles});
                fd.setFileName("elexis-verr.csv");
                String fname = fd.open();
                if (fd != null) {
                    try {
                        FileWriter fw = new FileWriter(fname);
                        fw.write(String.valueOf(StringTool.join((String[])VerrechnungsStatistikView.this.tableHeaders, (String)";")) + "\r\n");
                        TableItem[] tableItemArray = VerrechnungsStatistikView.this.table.getItems();
                        int n = tableItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem it = tableItemArray[n2];
                            StringBuilder sb = new StringBuilder();
                            sb.append(it.getText(0)).append(";").append(it.getText(1)).append(";").append(it.getText(2)).append(";").append(it.getText(3)).append(";").append(it.getText(4)).append("\r\n");
                            fw.write(sb.toString());
                            ++n2;
                        }
                        fw.close();
                    }
                    catch (IOException e) {
                        ExHandler.handle((Throwable)e);
                    }
                }
            }
        };
    }
}

