/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.ui.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.e4.jface.preference.URIFieldEditor;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.Leistungsblock;
import ch.elexis.omnivore.PreferenceConstants;
import ch.elexis.omnivore.data.Messages;
import ch.elexis.omnivore.data.Preferences;
import ch.elexis.omnivore.ui.jobs.OutsourceUiJob;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static Logger log = LoggerFactory.getLogger((String)"ch.elexis.omnivore.PreferencePage");
    public static final String USR_COLUMN_WIDTH_SETTINGS = "ch.elexis.omnivore//columnwidths";
    public static final String SAVE_COLUM_WIDTH = "ch.elexis.omnivore//savecolwidths";
    public static final String USR_SORT_DIRECTION_SETTINGS = "ch.elexis.omnivore//sortdirection";
    public static final String SAVE_SORT_DIRECTION = "ch.elexis.omnivore//savesortdirection";
    public static final String GLOBAL_SHOW_CREATED_IN_INBOX = "ch.elexis.omnivore/showCreatedInInbox";
    private BooleanFieldEditor bStoreFSGlobal;
    private BooleanFieldEditor bStoreFS;
    private BooleanFieldEditor bAutomaticBilling;
    private BooleanFieldEditor bShowCreatedInInbox;
    private URIFieldEditor dfStorePath;
    private Button btnSaveColumnWidths;
    private Button btnSaveSortDirection;
    private Button outsource;
    boolean storeFs = Preferences.storeInFilesystem();
    boolean basePathSet = false;
    private Text tAutomaticBillingBlock;

    public PreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
        this.setDescription(Messages.Preferences_omnivore);
        String basePath = Preferences.getBasepath();
        if (basePath != null && basePath.length() > 0) {
            this.basePathSet = true;
        }
    }

    protected void createFieldEditors() {
        Group gAllOmnivorePrefs = new Group(this.getFieldEditorParent(), 0);
        GridLayout gOmnivorePrefsGridLayout = new GridLayout();
        gOmnivorePrefsGridLayout.numColumns = 1;
        gOmnivorePrefsGridLayout.makeColumnsEqualWidth = true;
        gAllOmnivorePrefs.setLayout((Layout)gOmnivorePrefsGridLayout);
        GridData gOmnivorePrefsGridLayoutData = new GridData();
        gOmnivorePrefsGridLayoutData.grabExcessHorizontalSpace = true;
        gOmnivorePrefsGridLayoutData.horizontalAlignment = 4;
        gAllOmnivorePrefs.setLayoutData((Object)gOmnivorePrefsGridLayoutData);
        Group gGeneralOptions = new Group((Composite)gAllOmnivorePrefs, 0);
        GridData gGeneralOptionsGridLayoutData = new GridData();
        gGeneralOptionsGridLayoutData.grabExcessHorizontalSpace = true;
        gGeneralOptionsGridLayoutData.horizontalAlignment = 4;
        gGeneralOptions.setLayoutData((Object)gGeneralOptionsGridLayoutData);
        this.addField((FieldEditor)new BooleanFieldEditor("ch.elexis.omnivore/date_modifiable", Messages.Preferences_dateModifiable, (Composite)gGeneralOptions));
        this.bShowCreatedInInbox = new BooleanFieldEditor(GLOBAL_SHOW_CREATED_IN_INBOX, Messages.Preferences_omnivoreShowCreatedInInbox, (Composite)gGeneralOptions);
        this.addField((FieldEditor)this.bShowCreatedInInbox);
        Group gPathForDocs = new Group((Composite)gGeneralOptions, 0);
        gPathForDocs.setLayoutData((Object)new GridData(4, 128, true, false));
        gPathForDocs.setLayout((Layout)new FillLayout());
        this.bStoreFSGlobal = new BooleanFieldEditor("ch.elexis.omnivore/store_in_fs_global", "Dateisystem Einstellungen global speichern", (Composite)gPathForDocs){

            protected void fireValueChanged(String property, Object oldValue, Object newValue) {
                super.fireValueChanged(property, oldValue, newValue);
                if (((Boolean)newValue).booleanValue()) {
                    Preferences.setFsSettingStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL));
                    PreferencePage.this.updateFSSettingsStore();
                } else {
                    Preferences.setFsSettingStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
                    PreferencePage.this.updateFSSettingsStore();
                }
            }
        };
        this.addField((FieldEditor)this.bStoreFSGlobal);
        this.bStoreFS = new BooleanFieldEditor("ch.elexis.omnivore/store_in_fs", Messages.Preferences_storeInFS, (Composite)gPathForDocs);
        this.addField((FieldEditor)this.bStoreFS);
        Preferences.storeInFilesystem();
        this.dfStorePath = new URIFieldEditor("ch.elexis.omnivore/basepath", Messages.Preferences_pathForDocs, (Composite)gPathForDocs);
        Preferences.getBasepath();
        this.dfStorePath.setEmptyStringAllowed(true);
        this.addField((FieldEditor)this.dfStorePath);
        Label label = new Label((Composite)gAllOmnivorePrefs, 0);
        label.setText("Datenbankeintr\u00e4ge auf Filesystem auslagern");
        this.outsource = new Button((Composite)gAllOmnivorePrefs, 8);
        this.outsource.setText("Auslagern");
        this.outsource.setEnabled(false);
        this.outsource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutsourceUiJob job = new OutsourceUiJob();
                job.execute(PreferencePage.this.getShell());
            }
        });
        Group gPathForMaxChars = new Group((Composite)gGeneralOptions, 0);
        gPathForMaxChars.setLayout((Layout)new FillLayout());
        SettingsPreferenceStore preferenceStore = new SettingsPreferenceStore(CoreHub.localCfg);
        preferenceStore.setDefault("ch.elexis.omnivore/max_filename_length", PreferenceConstants.OmnivoreMax_Filename_Length_Default.intValue());
        IntegerFieldEditor maxCharsEditor = new IntegerFieldEditor("ch.elexis.omnivore/max_filename_length", Messages.Preferences_MAX_FILENAME_LENGTH, (Composite)gPathForMaxChars);
        maxCharsEditor.setValidRange(PreferenceConstants.OmnivoreMax_Filename_Length_Min.intValue(), PreferenceConstants.OmnivoreMax_Filename_Length_Max.intValue());
        this.addField((FieldEditor)maxCharsEditor);
        Integer nAutoArchiveRules = Preferences.getOmnivorenRulesForAutoArchiving();
        Group gAutoArchiveRules = new Group((Composite)gAllOmnivorePrefs, 0);
        GridLayout gAutoArchiveRulesGridLayout = new GridLayout();
        gAutoArchiveRulesGridLayout.numColumns = 1;
        gAutoArchiveRules.setLayout((Layout)gAutoArchiveRulesGridLayout);
        GridData gAutoArchiveRulesGridLayoutData = new GridData();
        gAutoArchiveRulesGridLayoutData.grabExcessHorizontalSpace = true;
        gAutoArchiveRulesGridLayoutData.horizontalAlignment = 4;
        gAutoArchiveRules.setLayoutData((Object)gAutoArchiveRulesGridLayoutData);
        gAutoArchiveRules.setText(Messages.Preferences_automatic_archiving_of_processed_files);
        int i = 0;
        while (i < nAutoArchiveRules) {
            log.debug(PreferenceConstants.PREF_SRC_PATTERN[i] + " : " + Messages.Preferences_SRC_PATTERN);
            log.debug(PreferenceConstants.PREF_DEST_DIR[i] + " : " + Messages.Preferences_DEST_DIR);
            Group gAutoArchiveRule = new Group((Composite)gAutoArchiveRules, 0);
            GridLayout gAutoArchiveRuleGridLayout = new GridLayout();
            gAutoArchiveRuleGridLayout.numColumns = 1;
            gAutoArchiveRule.setLayout((Layout)gAutoArchiveRuleGridLayout);
            GridData gAutoArchiveRuleGridLayoutData = new GridData();
            gAutoArchiveRuleGridLayoutData.grabExcessHorizontalSpace = true;
            gAutoArchiveRuleGridLayoutData.horizontalAlignment = 4;
            gAutoArchiveRule.setLayoutData((Object)gAutoArchiveRuleGridLayoutData);
            gAutoArchiveRule.setText(Messages.Preferences_Rule + " " + (i + 1));
            log.debug("i {} val {}", (Object)i, (Object)PreferenceConstants.PREF_SRC_PATTERN[i]);
            this.addField((FieldEditor)new StringFieldEditor(PreferenceConstants.PREF_SRC_PATTERN[i], Messages.Preferences_SRC_PATTERN, (Composite)gAutoArchiveRule));
            this.addField((FieldEditor)new DirectoryFieldEditor(PreferenceConstants.PREF_DEST_DIR[i], Messages.Preferences_DEST_DIR, (Composite)gAutoArchiveRule));
            ++i;
        }
        Integer nCotfRules = Preferences.PREFERENCE_cotf_elements.length;
        Group gCotfRules = new Group((Composite)gAllOmnivorePrefs, 0);
        GridLayout gCotfRulesGridLayout = new GridLayout();
        gCotfRulesGridLayout.numColumns = nCotfRules;
        gCotfRules.setLayout((Layout)gCotfRulesGridLayout);
        GridData gCotfRulesGridLayoutData = new GridData();
        gCotfRulesGridLayoutData.grabExcessHorizontalSpace = true;
        gCotfRulesGridLayoutData.horizontalAlignment = 4;
        gCotfRules.setLayoutData((Object)gCotfRulesGridLayoutData);
        gCotfRules.setText(Messages.Preferences_construction_of_temporary_filename);
        int i2 = 0;
        while (i2 < nCotfRules) {
            Group gCotfRule = new Group((Composite)gCotfRules, 0);
            gCotfRule.setLayout((Layout)new FillLayout());
            GridLayout gCotfRuleGridLayout = new GridLayout();
            gCotfRuleGridLayout.numColumns = 6;
            gCotfRule.setLayout((Layout)gCotfRuleGridLayout);
            GridData gCotfRuleGridLayoutData = new GridData();
            gCotfRuleGridLayoutData.grabExcessHorizontalSpace = true;
            gCotfRuleGridLayoutData.horizontalAlignment = 4;
            gCotfRule.setLayoutData((Object)gCotfRuleGridLayoutData);
            gCotfRule.setText(Preferences.PREFERENCE_cotf_elements_messages[i2]);
            String prefName = "ch.elexis.omnivore/cotf_" + Preferences.PREFERENCE_cotf_elements[i2] + "_" + Preferences.PREFERENCE_cotf_parameters[1];
            log.debug("Add  {} val {}", (Object)i2, (Object)prefName);
            if (Preferences.PREFERENCE_cotf_elements[i2].contains("constant")) {
                gCotfRuleGridLayoutData.horizontalAlignment = 1;
                gCotfRuleGridLayoutData.verticalAlignment = 1;
                this.addField((FieldEditor)new StringFieldEditor(prefName, "", 10, (Composite)gCotfRule));
            } else {
                String str0 = "ch.elexis.omnivore/cotf_" + Preferences.PREFERENCE_cotf_elements[i2] + "_" + Preferences.PREFERENCE_cotf_parameters[0];
                String str2 = "ch.elexis.omnivore/cotf_" + Preferences.PREFERENCE_cotf_elements[i2] + "_" + Preferences.PREFERENCE_cotf_parameters[2];
                log.debug("{}: keyl {} {} {} {}", new Object[]{i2, str0, prefName, str2});
                log.debug("val {} {} {} {}", new Object[]{Preferences.PREFERENCE_cotf_parameters_messages[0], Preferences.PREFERENCE_cotf_parameters_messages[1], Preferences.PREFERENCE_cotf_parameters_messages[2]});
                this.addField((FieldEditor)new StringFieldEditor(str0, Preferences.PREFERENCE_cotf_parameters_messages[0], 10, (Composite)gCotfRule));
                this.addField((FieldEditor)new StringFieldEditor(prefName, Preferences.PREFERENCE_cotf_parameters_messages[1], 10, (Composite)gCotfRule));
                this.addField((FieldEditor)new StringFieldEditor(str2, Preferences.PREFERENCE_cotf_parameters_messages[2], 10, (Composite)gCotfRule));
            }
            ++i2;
        }
        this.enableOutsourceButton();
        this.bAutomaticBilling = new BooleanFieldEditor("ch.elexis.omnivore/automatic_billing", "Automatische Verrechnung (bei Drag and Drop)", (Composite)gAllOmnivorePrefs);
        this.addField((FieldEditor)this.bAutomaticBilling);
        Composite billingBlockComposite = new Composite((Composite)gAllOmnivorePrefs, 0);
        billingBlockComposite.setLayout((Layout)new RowLayout());
        this.tAutomaticBillingBlock = new Text(billingBlockComposite, 2056);
        this.tAutomaticBillingBlock.setLayoutData((Object)new RowData(250, -1));
        this.tAutomaticBillingBlock.setTextLimit(80);
        Button blockCodeSelection = new Button(billingBlockComposite, 8);
        blockCodeSelection.setText("...");
        blockCodeSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionDialog dialog = CodeSelectorFactory.getSelectionDialog((String)"Block", (Shell)PreferencePage.this.getShell(), (Object)"ignoreErrors");
                if (dialog.open() == 0) {
                    if (dialog.getResult() != null && dialog.getResult().length > 0) {
                        Leistungsblock block = (Leistungsblock)dialog.getResult()[0];
                        PreferencePage.this.selectBlock(block);
                        CoreHub.localCfg.set("ch.elexis.omnivore/automatic_billing_block", block.getId());
                    } else {
                        CoreHub.localCfg.set("ch.elexis.omnivore/automatic_billing_block", "");
                        PreferencePage.this.selectBlock(null);
                    }
                }
            }
        });
        if (!CoreHub.localCfg.get("ch.elexis.omnivore/automatic_billing_block", "").isEmpty()) {
            this.selectBlock(Leistungsblock.load((String)CoreHub.localCfg.get("ch.elexis.omnivore/automatic_billing_block", "")));
        }
    }

    private void selectBlock(Leistungsblock block) {
        if (block != null && block.exists()) {
            this.tAutomaticBillingBlock.setText(block.getLabel());
        } else {
            this.tAutomaticBillingBlock.setText("");
        }
    }

    private void enableOutsourceButton() {
        if (this.storeFs && this.basePathSet) {
            this.outsource.setEnabled(true);
        } else {
            this.outsource.setEnabled(false);
        }
    }

    private void updateFSSettingsStore() {
        this.bStoreFS.setPreferenceStore(Preferences.getFsSettingsStore());
        this.bStoreFS.load();
        this.dfStorePath.setPreferenceStore(Preferences.getFsSettingsStore());
        this.dfStorePath.load();
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        ConfigServicePreferenceStore globalStore = new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL);
        globalStore.setDefault(GLOBAL_SHOW_CREATED_IN_INBOX, true);
        this.bStoreFSGlobal.setPreferenceStore((IPreferenceStore)globalStore);
        this.bStoreFSGlobal.load();
        this.bShowCreatedInInbox.setPreferenceStore((IPreferenceStore)globalStore);
        this.bShowCreatedInInbox.load();
        this.updateFSSettingsStore();
        this.addSeparator();
        this.btnSaveColumnWidths = new Button(this.getFieldEditorParent(), 32);
        this.btnSaveColumnWidths.setText("Spaltenbreite speichern (f\u00fcr Ihren Benutzer)");
        this.btnSaveColumnWidths.setSelection(ConfigServiceHolder.getUser((String)SAVE_COLUM_WIDTH, (boolean)false));
        this.btnSaveSortDirection = new Button(this.getFieldEditorParent(), 32);
        this.btnSaveSortDirection.setText("Sortierung speichern (f\u00fcr Ihren Benutzer)");
        this.btnSaveSortDirection.setSelection(ConfigServiceHolder.getUser((String)SAVE_SORT_DIRECTION, (boolean)false));
        return c;
    }

    private void addSeparator() {
        Label separator = new Label(this.getFieldEditorParent(), 258);
        GridData separatorGridData = new GridData();
        separatorGridData.horizontalSpan = 3;
        separatorGridData.grabExcessHorizontalSpace = true;
        separatorGridData.horizontalAlignment = 4;
        separatorGridData.verticalIndent = 0;
        separator.setLayoutData((Object)separatorGridData);
    }

    public void init(IWorkbench workbench) {
        Integer i = 0;
        while (i < Preferences.getOmnivorenRulesForAutoArchiving()) {
            PreferenceConstants.PREF_SRC_PATTERN[i.intValue()] = "ch.elexis.omnivore/src_pattern" + i.toString().trim();
            PreferenceConstants.PREF_DEST_DIR[i.intValue()] = "ch.elexis.omnivore/dest_dir" + i.toString().trim();
            i = i + 1;
        }
    }

    public boolean performOk() {
        ConfigServiceHolder.setUser((String)SAVE_COLUM_WIDTH, (boolean)this.btnSaveColumnWidths.getSelection());
        ConfigServiceHolder.setUser((String)SAVE_SORT_DIRECTION, (boolean)this.btnSaveSortDirection.getSelection());
        CoreHub.localCfg.flush();
        return super.performOk();
    }
}

