/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core;

import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Xid;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.SubMonitor;

public interface IAeskulapImportFile {
    public File getFile();

    public Type getType();

    default public boolean doImport(boolean overwrite, SubMonitor monitor) {
        return this.doImport(null, overwrite, monitor);
    }

    public boolean doImport(Map<Type, IAeskulapImportFile> var1, boolean var2, SubMonitor var3);

    default public boolean isTransient() {
        return false;
    }

    default public Object getTransient(String id) {
        return null;
    }

    default public Object getWithXid(String domain, String id) {
        Xid existingXid = Xid.findXID((String)domain, (String)id);
        if (existingXid != null) {
            return existingXid.getObject();
        }
        return null;
    }

    public static enum Type {
        ADDRESSES(1, Kontakt.class),
        MANDATOR(2, Mandant.class),
        PATIENT(100, Patient.class),
        LABORCONTACT(200, Kontakt.class),
        LABORITEM(210, LabItem.class),
        LABORRESULT(250, LabResult.class),
        DIAGDIRECTORY(300, File.class),
        LETTER(1001, IOpaqueDocument.class),
        LETTERDIRECTORY(1000, File.class),
        DOCUMENT(1101, IOpaqueDocument.class),
        DOCUMENTDIRECTORY(1100, File.class),
        FILE(1201, IOpaqueDocument.class),
        FILEDIRECTORY(1200, File.class);

        private int sequence;
        private Class<?> elexisClass;
        private static List<Type> sequenced;

        private Type(int sequence, Class<?> clazz) {
            this.sequence = sequence;
            this.elexisClass = clazz;
        }

        public int getSequence() {
            return this.sequence;
        }

        public static List<Type> getSequenced() {
            if (sequenced == null) {
                List<Type> list = Arrays.asList(Type.values());
                list.sort(new Comparator<Type>(){

                    @Override
                    public int compare(Type o1, Type o2) {
                        return Integer.valueOf(o1.getSequence()).compareTo(o2.getSequence());
                    }
                });
                sequenced = list;
            }
            return sequenced;
        }

        public boolean checkElexisClass(Object object) {
            return this.elexisClass.isAssignableFrom(object.getClass());
        }
    }
}

