/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.message.ui.handler;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.ui.dialogs.ChoiceDialog;
import ch.elexis.hl7.message.ui.handler.MessageServiceHolder;
import ch.elexis.hl7.message.ui.handler.MessageUtil;
import ch.elexis.hl7.message.ui.preference.PreferenceUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class ExportMessageHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String messageTyp = event.getParameter("ch.elexis.hl7.message.ui.exportmessage.typ");
        if (messageTyp != null && !messageTyp.isEmpty()) {
            if (this.exportMessage(messageTyp)) {
                return null;
            }
        } else {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Unbekannter Message Typ", (String)("Der Message Typ [" + messageTyp + "] ist nicht bekannt. Es wurde keine Message exportiert."));
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private boolean exportMessage(String messageTyp) {
        block13: {
            block12: {
                block14: {
                    block11: {
                        receiver = null;
                        receivers = PreferenceUtil.getReceivers();
                        if (!receivers.isEmpty()) break block11;
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Empf\u00e4nger", (String)"Es sind keine Empf\u00e4nger konfiguriert.");
                        return false;
                    }
                    if (receivers.size() <= 1) break block12;
                    choices = new String[receivers.size()];
                    i = 0;
                    while (i < receivers.size()) {
                        choices[i] = receivers.get(i).getApplication() + " - " + receivers.get(i).getFacility();
                        ++i;
                    }
                    choiceDialog = new ChoiceDialog(Display.getDefault().getActiveShell(), "Empf\u00e4nger Auswahl", "Mehrere Empf\u00e4nger konfiguriert, welcher soll verwendet werden?.", choices);
                    if (choiceDialog.open() != 0) break block14;
                    index = choiceDialog.getResult();
                    receiver = receivers.get(index);
                    ** GOTO lbl26
                }
                return false;
            }
            try {
                receiver = receivers.get(0);
lbl26:
                // 2 sources

                context = MessageUtil.getContext();
                context.put("context.msg.receivingapplication", receiver.getApplication());
                context.put("context.msg.receivingfacility", receiver.getFacility());
                validationResult = MessageServiceHolder.getService().validateContext(messageTyp, context);
                if (validationResult.isEmpty()) {
                    message = MessageServiceHolder.getService().getMessage(messageTyp, context);
                    MessageUtil.export(messageTyp, message, this.getEncoding(message));
                    break block13;
                }
                sb = new StringBuilder("F\u00fcr die Generierung der Message vom Typ [" + messageTyp + "] fehlt folgende Auswahl.\n\n");
                for (String string : validationResult) {
                    if (string.equals("context.patient")) {
                        sb.append("* Patient\n");
                    }
                    if (string.equals("context.consultation")) {
                        sb.append("* Konsultation\n");
                    }
                    if (string.equals("context.mandator")) {
                        sb.append("* Mandant\n");
                    }
                    sb.append("\nEs wurde keine Message exportiert.");
                }
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)sb.toString());
                return false;
            }
            catch (ElexisException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error generating message", (Throwable)e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es ist ein Fehler bei der Generierung der Message vom Typ [" + messageTyp + "] aufgetreten. Es wurde keine Message exportiert."));
                return false;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error writing file", (Throwable)e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es ist ein Fehler beim Schreiben der Message vom Typ [" + messageTyp + "] aufgetreten."));
                return false;
            }
        }
        return true;
    }

    private String getEncoding(String message) {
        BufferedReader reader = new BufferedReader(new StringReader(message));
        try {
            String firstline = reader.readLine();
            if (firstline.startsWith("MSH") && (firstline.contains("8859-1") || firstline.contains("8859/1"))) {
                return StandardCharsets.ISO_8859_1.name();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return StandardCharsets.UTF_8.name();
    }
}

