/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm;

import at.medevit.ch.artikelstamm.ARTIKELSTAMM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ArtikelstammHelper {
    private static Logger log = LoggerFactory.getLogger(ArtikelstammHelper.class);
    public static String PHARMA_XSD_LOCATION = "Elexis_Artikelstamm_v5.xsd";
    private static URL schemaLocationUrl = null;
    private static SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    static DateFormat dateFormat = new SimpleDateFormat("ddMMyy");
    public static DateFormat monthAndYearWritten = new SimpleDateFormat("MMM yyyy");
    private static HashMap<String, ARTIKELSTAMM.ITEMS.ITEM> itemPharmacodeCache;
    private static HashMap<String, ARTIKELSTAMM.ITEMS.ITEM> itemGTINCache;

    static {
        try {
            schemaLocationUrl = new URL("platform:/plugin/at.medevit.ch.artikelstamm/lib/" + PHARMA_XSD_LOCATION);
        }
        catch (MalformedURLException e) {
            log.error("Error resolving Artikelstamm schema", (Throwable)e);
        }
        itemPharmacodeCache = null;
        itemGTINCache = null;
    }

    public static int getCummulatedVersionNumber(int year, int month) {
        return (year - 2013) * 12 + month;
    }

    public static Date getDateFromCumulatedVersionNumber(int cumulatedVersionNo) {
        int year = 2013 + cumulatedVersionNo / 12;
        int month = cumulatedVersionNo % 12 - 1;
        return new GregorianCalendar(year, month, 1).getTime();
    }

    public static String createUUID(int version, String gtin, BigInteger phar) {
        return ArtikelstammHelper.createUUID(version, gtin, phar, true);
    }

    public static String createUUID(int version, String gtin, BigInteger phar, boolean includeVersion) {
        StringBuilder sb = new StringBuilder();
        if (gtin.length() > 0) {
            sb.append(String.format("%014d", Long.parseLong(gtin)));
        } else {
            sb.append("00000000000000");
        }
        if (phar != null) {
            sb.append(String.format("%07d", phar));
        } else {
            sb.append("0000000");
        }
        if (version > 9999 || version < 0) {
            version = 0;
        }
        if (includeVersion) {
            sb.append(String.format("%04d", version));
        }
        return sb.toString();
    }

    public static ARTIKELSTAMM unmarshallInputStream(InputStream xmlFileIs) throws JAXBException, SAXException {
        System.out.println(schemaLocationUrl);
        Unmarshaller u = JAXBContext.newInstance((Class[])new Class[]{ARTIKELSTAMM.class}).createUnmarshaller();
        Schema schema = schemaFactory.newSchema(schemaLocationUrl);
        u.setSchema(schema);
        return (ARTIKELSTAMM)u.unmarshal(xmlFileIs);
    }

    public static ARTIKELSTAMM unmarshallFile(File xmlFile) throws JAXBException, SAXException, FileNotFoundException {
        return ArtikelstammHelper.unmarshallInputStream(new FileInputStream(xmlFile));
    }

    public static void marshallToFileSystem(Object newData, File outputFile) throws SAXException, JAXBException {
        Marshaller m = JAXBContext.newInstance((Class[])new Class[]{ARTIKELSTAMM.class}).createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal(newData, outputFile);
    }

    public static File determineOutputFileName(ARTIKELSTAMM converted, File inboundFileObj, String string) {
        Date outputDate = converted.getCREATIONDATETIME().toGregorianCalendar().getTime();
        String filename = string != null ? "artikelstamm_" + dateFormat.format(outputDate) + "_" + string + ".xml" : "artikelstamm_" + dateFormat.format(outputDate) + ".xml";
        return new File(inboundFileObj.getParent(), filename);
    }

    public static ARTIKELSTAMM.ITEMS.ITEM getItemInListByGTIN(ARTIKELSTAMM.ITEMS artikelstamm, String gtin) {
        if (itemGTINCache == null) {
            itemGTINCache = new HashMap(artikelstamm.getITEM().size());
            for (ARTIKELSTAMM.ITEMS.ITEM item : artikelstamm.getITEM()) {
                itemGTINCache.put(item.getGTIN(), item);
            }
        }
        if (itemGTINCache.containsKey(gtin)) {
            System.out.println("[INFO] Resolved over GTIN " + gtin);
            return itemGTINCache.get(gtin);
        }
        return null;
    }

    public String getSwissmedicNo8ForArtikelstammItem(ARTIKELSTAMM.ITEMS.ITEM item) {
        String gtin = item.getGTIN();
        if (gtin != null && gtin.startsWith("7680")) {
            return gtin.substring(4, 12);
        }
        return null;
    }
}

