/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.lucinda.view;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.data.Patient;
import ch.elexis.ungrad.lucinda.Activator;
import ch.elexis.ungrad.lucinda.IDocumentHandler;
import ch.elexis.ungrad.lucinda.Preferences;
import ch.elexis.ungrad.lucinda.controller.Controller;
import ch.elexis.ungrad.lucinda.view.Messages;
import ch.rgw.tools.StringTool;
import java.io.File;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class GlobalView
extends ViewPart
implements IActivationListener {
    private Controller controller;
    private Action doubleClickAction;
    private Action filterCurrentPatAction;
    private Action showInboxAction;
    private Action aquireAction;
    private Action rescanAction;
    private final ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class, 16){

        public void runInUi(ElexisEvent ev) {
            GlobalView.this.controller.changePatient((Patient)ev.getObject());
        }
    };

    public GlobalView() {
        this.controller = new Controller();
    }

    public void createPartControl(Composite parent) {
        if (!(this.is("ch.rgw.docmgr-lucinda.showConsultation") || this.is("ch.rgw.docmgr-lucinda.showInbox") || this.is("ch.rgw.docmgr-lucinda.showOmnivore"))) {
            this.save("ch.rgw.docmgr-lucinda.showConsultation", true);
            this.save("ch.rgw.docmgr-lucinda.showOmnivore", true);
            this.save("ch.rgw.docmgr-lucinda.showInbox", true);
        }
        this.makeActions();
        this.controller.createView(parent);
        this.contributeToActionBars();
        String colWidths = this.load("ch.rgw.docmgr-lucinda.columnWidths");
        this.controller.setColumnWidths(colWidths);
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    public void visible(boolean mode) {
        this.controller.reload();
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat});
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat});
            this.save("ch.rgw.docmgr-lucinda.columnWidths", this.controller.getColumnWidths());
        }
    }

    public void setFocus() {
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager menu = bars.getMenuManager();
        IToolBarManager toolbar = bars.getToolBarManager();
        toolbar.add((IAction)this.filterCurrentPatAction);
        toolbar.add((IAction)this.showInboxAction);
        for (IDocumentHandler dh : Activator.getDefault().getAddons()) {
            IAction menuAction;
            IAction toolbarAction = dh.getFilterAction(this.controller);
            if (toolbarAction != null) {
                toolbar.add(toolbarAction);
            }
            if ((menuAction = dh.getSyncAction(this.controller)) == null) continue;
            menu.add(menuAction);
        }
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.aquireAction);
        menu.add((IAction)this.rescanAction);
    }

    public void createViewerContextMenu(StructuredViewer viewer, final List<IContributionItem> contributionItems) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GlobalView.this.fillContextMenu(manager, contributionItems);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getViewSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void fillContextMenu(IMenuManager manager, List<IContributionItem> contributionItems) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        for (IContributionItem contributionItem : contributionItems) {
            ActionContributionItem ac;
            if (contributionItem == null) {
                manager.add((IContributionItem)new Separator());
                continue;
            }
            if (contributionItem instanceof ActionContributionItem && (ac = (ActionContributionItem)contributionItem).getAction() instanceof RestrictedAction) {
                ((RestrictedAction)ac.getAction()).reflectRight();
            }
            contributionItem.update();
            manager.add(contributionItem);
        }
    }

    private void makeActions() {
        File ac;
        this.rescanAction = new Action("Rescan"){
            {
                this.setToolTipText("Lucinda Dokumente neu einlesen");
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
            }

            public void run() {
                GlobalView.this.controller.doRescan();
            }
        };
        this.filterCurrentPatAction = new Action(Messages.GlobalView_actPatient_name, 2){
            {
                this.setToolTipText(Messages.GlobalView_actPatient_tooltip);
                this.setImageDescriptor(Images.IMG_PERSON.getImageDescriptor());
            }

            public void run() {
                GlobalView.this.controller.restrictToCurrentPatient(this.isChecked());
                GlobalView.this.save("ch.rgw.docmgr-lucinda.restrictToCurrentPatient", this.isChecked());
            }
        };
        this.filterCurrentPatAction.setChecked(this.is("ch.rgw.docmgr-lucinda.restrictToCurrentPatient"));
        this.showInboxAction = new Action(Preferences.INBOX_NAME, 2){
            {
                this.setToolTipText(Messages.GlobalView_filterInbox_name);
                this.setImageDescriptor(Images.IMG_DOCUMENT_TEXT.getImageDescriptor());
            }

            public void run() {
                GlobalView.this.controller.toggleDoctypeFilter(this.isChecked(), Preferences.INBOX_NAME);
                GlobalView.this.save("ch.rgw.docmgr-lucinda.showInbox", this.isChecked());
            }
        };
        this.showInboxAction.setChecked(this.is("ch.rgw.docmgr-lucinda.showInbox"));
        this.aquireAction = new Action("Aquire"){
            {
                this.setToolTipText("Document von externer Quelle einlesen");
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
            }

            public void run() {
                GlobalView.this.controller.launchAquireScript(GlobalView.this.getSite().getShell());
            }
        };
        this.aquireAction.setEnabled(false);
        String actionScript = Preferences.get("ch.rgw.docmgr-lucinda.aquire_action", null);
        if (!StringTool.isNothing((Object)actionScript) && (ac = new File(actionScript)).exists() && ac.canExecute()) {
            this.aquireAction.setEnabled(true);
        }
    }

    public void activation(boolean mode) {
    }

    private void save(String name, boolean value) {
        this.save(name, Boolean.toString(value));
    }

    private void save(String name, String value) {
        Preferences.set(name, value);
    }

    private String load(String name) {
        return Preferences.get(name, Messages.GlobalView_11);
    }

    private boolean is(String name) {
        return Boolean.parseBoolean(Preferences.get(name, Boolean.toString(false)));
    }
}

