/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.lucinda;

import ch.elexis.ungrad.lucinda.Preferences;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client3 {
    private String api = "/lucinda/3.0";
    private Logger log = LoggerFactory.getLogger((String)"Lucinda v3 client");
    private HttpURLConnection conn;

    private URL makeURL(String call) throws MalformedURLException {
        String server = Preferences.get("ch.rgw.docmgr-lucinda.serverAddr", "127.0.0.1");
        int port = Integer.parseInt(Preferences.get("ch.rgw.docmgr-lucinda.serverPort", "9997"));
        return new URL("http://" + server + ":" + port + this.api + call);
    }

    private byte[] doGet(String api_call) throws IOException {
        URL url = this.makeURL(api_call);
        this.conn = (HttpURLConnection)url.openConnection();
        this.conn.setRequestProperty("method", "get");
        this.conn.setConnectTimeout(5000);
        int response = this.conn.getResponseCode();
        if (response == 200) {
            int c;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bin = new BufferedInputStream(this.conn.getInputStream());
            while ((c = bin.read()) != -1) {
                baos.write(c);
            }
            return baos.toByteArray();
        }
        throw new IOException("could not read " + api_call + ": Status was " + response);
    }

    private String doPost(String api_call, String body, int expectedStatus) throws IOException {
        URL url = this.makeURL(api_call);
        this.conn = (HttpURLConnection)url.openConnection();
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("Content-Type", "application/json");
        this.conn.setRequestProperty("Content-Length", String.valueOf(body.length()));
        this.conn.setDoOutput(true);
        OutputStreamWriter os = new OutputStreamWriter(this.conn.getOutputStream());
        os.write(body);
        os.flush();
        int response = this.conn.getResponseCode();
        if (response == expectedStatus) {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
            StringBuffer buffer = new StringBuffer();
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            in.close();
            this.conn.disconnect();
            return buffer.toString();
        }
        this.log.error("Bad answer for " + api_call + ": " + response);
        return null;
    }

    public Map query(String phrase) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap query = new HashMap();
        HashMap<String, String> edismax = new HashMap<String, String>();
        edismax.put("query", phrase);
        query.put("edismax", edismax);
        params.put("query", query);
        params.put("limit", Preferences.get("ch.rgw.docmgr-lucinda.maximumHitNumber", "100"));
        String result = this.doPost("/query", this.writeJson(params), 200);
        if (result == null) {
            throw new Exception("Connection problem");
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("result", this.readJson(result).get("docs"));
        json.put("status", "ok");
        return json;
    }

    public Map get(String id) throws Exception {
        HashMap<String, Object> json = new HashMap<String, Object>();
        byte[] result = this.doGet("/get/" + id);
        json.put("status", "ok");
        json.put("result", result);
        return json;
    }

    public void rescan() {
    }

    public Map addToIndex(String id, String title, String doctype, Map metadata, byte[] contents) throws Exception {
        Map<String, Object> params = this.prepare(id, title, doctype, metadata);
        params.put("contents", contents);
        String ans = this.doPost("/addindex", this.writeJson(params), 201);
        if (StringTool.isNothing((Object)ans)) {
            throw new Exception("Empty response");
        }
        Map<String, Object> answer = this.readJson(ans);
        Map result = (Map)answer.get("responseHeader");
        if (result.get("status") == Integer.valueOf(0)) {
            result.put("status", "ok");
            result.put("_id", id);
        }
        return result;
    }

    public Map addFile(String uid, String filename, String concern, String doctype, Map<String, Object> metadata, byte[] contents) throws Exception {
        Map<String, Object> meta = this.prepare(uid, filename, doctype, metadata);
        if (!StringTool.isNothing((Object)concern)) {
            meta.put("concern", concern);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("metadata", meta);
        params.put("payload", contents);
        String ans = this.doPost("/addindex", this.writeJson(params), 202);
        if (StringTool.isNothing((Object)ans)) {
            throw new Exception("Empty response adding file " + filename);
        }
        Map<String, Object> answer = this.readJson(ans);
        Map result = (Map)answer.get("resultHeader");
        return result;
    }

    private Map<String, Object> prepare(String id, String title, String doctype, Map<String, Object> metadata) {
        if (metadata == null) {
            metadata = new HashMap<String, Object>();
        }
        if (!StringTool.isNothing((Object)id)) {
            metadata.put("id", id);
        }
        metadata.put("title", title);
        metadata.put("lucinda_doctype", doctype);
        metadata.put("filename", title);
        return metadata;
    }

    private Map make(String ... params) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] p = param.split(":");
            ret.put(p[0], p[1]);
            ++n2;
        }
        return ret;
    }

    public Map<String, Object> readJson(String source) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map res = (Map)mapper.readValue(source, (TypeReference)new TypeReference<Map<String, Object>>(){});
            return res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String writeJson(Map<String, Object> source) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(source);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return null;
        }
    }
}

