/*
 * Decompiled with CFR 0.152.
 */
package com.hilotec.elexis.opendocument;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.text.ReplaceCallback;
import ch.elexis.core.data.util.PlatformHelper;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.rgw.tools.StringTool;
import com.hilotec.elexis.opendocument.Export;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfXMLFactory;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.doc.draw.OdfDrawFrame;
import org.odftoolkit.odfdom.doc.draw.OdfDrawTextBox;
import org.odftoolkit.odfdom.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.doc.office.OdfOfficeFontFaceDecls;
import org.odftoolkit.odfdom.doc.office.OdfOfficeText;
import org.odftoolkit.odfdom.doc.style.OdfStyle;
import org.odftoolkit.odfdom.doc.style.OdfStyleBackgroundImage;
import org.odftoolkit.odfdom.doc.style.OdfStyleColumns;
import org.odftoolkit.odfdom.doc.style.OdfStyleFontFace;
import org.odftoolkit.odfdom.doc.style.OdfStyleGraphicProperties;
import org.odftoolkit.odfdom.doc.style.OdfStyleParagraphProperties;
import org.odftoolkit.odfdom.doc.style.OdfStyleTableColumnProperties;
import org.odftoolkit.odfdom.doc.style.OdfStyleTextProperties;
import org.odftoolkit.odfdom.doc.text.OdfTextLineBreak;
import org.odftoolkit.odfdom.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.doc.text.OdfTextTab;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.dom.element.style.StyleBackgroundImageElement;
import org.odftoolkit.odfdom.dom.element.style.StyleColumnsElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFontFaceElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableColumnPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TextPlugin
implements ITextPlugin {
    private Process editor_process;
    private File file;
    private OdfTextDocument odt;
    private Style curStyle;
    private Composite comp;
    private Label filename_label;
    private Button open_button;
    private Button import_button;
    private static final String pluginID = "com.hilotec.elexis.opendocument";
    private static final String NoFileOpen = "Dateiname: Keine Datei ge\u00f6ffnet";
    private static Logger logger = LoggerFactory.getLogger((String)"com.hilotec.elexis.opendocument");
    private static int cnt = 0;

    private String getTempPrefix() {
        ++cnt;
        StringBuffer sb = new StringBuffer();
        Patient actPatient = ElexisEventDispatcher.getSelectedPatient();
        if (actPatient != null) {
            sb.append(String.valueOf(cnt) + "_" + actPatient.getName() + "_");
            sb.append(String.valueOf(actPatient.getVorname()) + "_");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_S");
        Date date = new Date();
        sb.append(dateFormat.format(date));
        return sb.toString().replaceAll("[^0-9A-Za-z]", "_");
    }

    private boolean editorRunning() {
        if (this.editor_process == null) {
            return false;
        }
        try {
            int exitValue = this.editor_process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    private synchronized void odtSync() {
        if (this.file == null || this.odt == null || this.editorRunning()) {
            return;
        }
        try {
            this.odt.save(this.file);
            logger.info("odtSync: completed " + this.file.length() + " saved");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean ensureClosed() {
        Patient actPatient = ElexisEventDispatcher.getSelectedPatient();
        if (actPatient != null) {
            logger.info("ensureClosed: " + actPatient.getVorname() + " " + actPatient.getName().toString());
        }
        if (this.editorRunning()) {
            logger.info("Editor already opened file " + this.file.getAbsolutePath());
            SWTHelper.showError((String)"Editor bereits ge\u00f6ffnet", (String)("Es scheint bereits ein Editor ge\u00f6ffnet zu sein f\u00fcr " + this.file.getAbsolutePath() + " ge\u00f6ffnet zu sein.\n\n" + "Falls Sie sicher sind, dass kein Editor diese Datei mehr offen hat, m\u00fcssen Sie Elexis neu starten.\n\n" + "Falls Sie diese Warnung nicht beachten werden die in der Datei gemachten \u00c4nderungen nicht in der Elexis Datenbank gespeichert!"));
            return false;
        }
        return true;
    }

    private void openEditor() {
        Patient actPatient;
        logger.info("openEditor " + this.file);
        if (this.file == null || !this.ensureClosed()) {
            return;
        }
        this.odtSync();
        String editor = CoreHub.localCfg.get("com.hilotec.elexis.ooo.editorpath", "");
        String argstr = CoreHub.localCfg.get("com.hilotec.elexis.ooo.editargs", "");
        String baseName = "open_odf.sh";
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            baseName = "open_odf.bat";
        }
        String scriptFile = String.valueOf(PlatformHelper.getBasePath((String)pluginID)) + File.separator + "rsc" + File.separator + baseName;
        logger.info(scriptFile);
        if (editor.length() == 0) {
            SWTHelper.showError((String)"Kein Editor gesetzt", (String)"In den Einstellungen wurde kein Editor konfiguriert.");
            return;
        }
        File scriptShell = new File(scriptFile);
        if (!scriptShell.canExecute()) {
            scriptShell.setExecutable(true);
        }
        String args = String.valueOf(editor) + "\n" + argstr + "\n" + this.file.getAbsolutePath();
        if (CoreHub.localCfg.get("com.hilotec.elexis.ooo.wrapperscript", true)) {
            args = String.valueOf(scriptFile) + "\n" + args;
        }
        String personalia = (actPatient = ElexisEventDispatcher.getSelectedPatient()) != null ? actPatient.getPersonalia() : "null";
        logger.info("openEditor: " + personalia + " as " + this.file.getAbsolutePath());
        ProcessBuilder pb = new ProcessBuilder(args.split("\n"));
        this.filename_label.setText(this.file.getAbsolutePath());
        try {
            this.editor_process = pb.start();
            this.odt = null;
            new Thread(){

                @Override
                public void run() {
                    block5: {
                        try {
                            try {
                                TextPlugin.this.editor_process.waitFor();
                                TextPlugin.this.odt = (OdfTextDocument)OdfTextDocument.loadDocument((File)TextPlugin.this.file);
                                logger.info("openEditor: exitValue " + TextPlugin.this.editor_process.exitValue() + " done " + TextPlugin.this.file.getAbsolutePath() + " NOT closing odt");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TextPlugin.this.editor_process = null;
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        TextPlugin.this.filename_label.setText(TextPlugin.NoFileOpen);
                                        logger.info("openEditor: updated filename_label");
                                    }
                                });
                                break block5;
                            }
                        }
                        catch (Throwable throwable) {
                            TextPlugin.this.editor_process = null;
                            Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                            throw throwable;
                        }
                        TextPlugin.this.editor_process = null;
                        Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                }
            }.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void importFile() {
        if (this.file == null || !this.ensureClosed()) {
            return;
        }
        this.odtSync();
        FileDialog fd = new FileDialog(UiDesk.getTopShell(), 4096);
        fd.setFilterExtensions(new String[]{"*.odt"});
        String path = fd.open();
        if (path != null) {
            try {
                logger.info("importFile: " + path);
                OdfTextDocument ndoc = (OdfTextDocument)OdfTextDocument.loadDocument((String)path);
                if (ndoc != null) {
                    this.odt = ndoc;
                    this.fileValid();
                }
                this.odtSync();
            }
            catch (Exception e) {
                SWTHelper.showError((String)"Fehler beim Import", (String)e.getMessage());
            }
        }
    }

    public File exportPDF() {
        if (this.file == null || !this.ensureClosed()) {
            return null;
        }
        this.odtSync();
        File pdffile = new File(this.file.getAbsoluteFile().getPath().replaceAll("\\.odt$", ".pdf"));
        String pdfconv = CoreHub.localCfg.get("com.hilotec.elexis.ooo.pdfpath", "");
        String pdfargs = CoreHub.localCfg.get("com.hilotec.elexis.ooo.pdfargs", "");
        if (pdfconv.length() == 0) {
            SWTHelper.showError((String)"Kein Konvertierungsbefehl gesetzt", (String)"In den Einstellungen wurde kein Befehl zum Konvertieren nach PDF konfiguriert.");
            return null;
        }
        String[] args = (String.valueOf(pdfconv) + "\n" + pdfargs + "\n" + this.file.getAbsolutePath()).split("[\n\r]+");
        ProcessBuilder pb = new ProcessBuilder(args);
        try {
            pb.directory(this.file.getAbsoluteFile().getParentFile());
            Process convert = pb.start();
            convert.waitFor();
            return pdffile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean print(String toPrinter, String toTray, boolean wait) {
        logger.info("String: " + (this.file != null));
        if (this.file == null || !this.ensureClosed()) {
            return false;
        }
        this.odtSync();
        String editor = CoreHub.localCfg.get("com.hilotec.elexis.ooo.editorpath", "oowriter");
        String argstr = CoreHub.localCfg.get("com.hilotec.elexis.ooo.printargs", "");
        String[] args = (String.valueOf(editor) + "\n" + argstr + "\n" + this.file.getAbsolutePath()).split("\n");
        ProcessBuilder pb = new ProcessBuilder(args);
        try {
            try {
                logger.info("print: " + args);
                this.editor_process = pb.start();
                this.editor_process.waitFor();
                logger.info("print waitFor done: " + args);
                this.filename_label.setText(NoFileOpen);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.editor_process = null;
            }
        }
        finally {
            this.editor_process = null;
        }
        return true;
    }

    public Composite createContainer(Composite parent, ITextPlugin.ICallback handler) {
        if (this.comp == null) {
            Export.Exporter[] exps;
            this.comp = new Composite(parent, 0);
            RowLayout layout = new RowLayout(512);
            layout.wrap = true;
            layout.fill = false;
            layout.justify = false;
            this.comp.setLayout((Layout)layout);
            RowData data = new RowData();
            this.filename_label = new Label(this.comp, 8);
            this.filename_label.setText(NoFileOpen);
            this.filename_label.setLayoutData((Object)data);
            data.width = 400;
            this.open_button = new Button(this.comp, 8);
            this.open_button.setText("Editor \u00f6ffnen");
            this.open_button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TextPlugin.this.openEditor();
                }
            });
            data = new RowData();
            this.open_button.setLayoutData((Object)data);
            this.import_button = new Button(this.comp, 8);
            this.import_button.setText("Datei importieren");
            this.import_button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TextPlugin.this.importFile();
                }
            });
            this.import_button.setLayoutData((Object)data);
            this.comp.pack();
            Composite exporters = new Composite(parent, 0);
            exporters.setLayout((Layout)new GridLayout());
            Export.Exporter[] exporterArray = exps = Export.getExporters();
            int n = exps.length;
            int n2 = 0;
            while (n2 < n) {
                Export.Exporter e = exporterArray[n2];
                Button b = new Button(exporters, 8);
                b.setText(e.getLabel());
                b.setData((Object)e);
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button b = (Button)e.widget;
                        Export.Exporter ex = (Export.Exporter)b.getData();
                        File f = TextPlugin.this.exportPDF();
                        if (f != null) {
                            ex.export(f.getPath());
                        }
                    }
                });
                ++n2;
            }
            exporters.update();
        }
        return this.comp;
    }

    private void fileValid() {
        this.open_button.setEnabled(true);
        this.curStyle = new Style();
    }

    public void dispose() {
        logger.info("dispose: ");
    }

    private void closeFile() {
        logger.info("closeFile: " + this.file.toString());
        this.odtSync();
        this.file.delete();
        this.file = null;
    }

    public boolean clear() {
        logger.info("clear: ");
        SWTHelper.showError((String)"TODO", (String)"TODO: clear()");
        return false;
    }

    public boolean createEmptyDocument() {
        logger.info("createEmptyDocument: ");
        if (!this.ensureClosed()) {
            return false;
        }
        if (this.file != null) {
            this.closeFile();
        }
        try {
            this.file = File.createTempFile(this.getTempPrefix(), ".odt");
            this.file.deleteOnExit();
            logger.info("createEmptyDocument: " + this.file.toString());
            this.odt = OdfTextDocument.newTextDocument();
            this.odt.save(this.file);
            this.fileValid();
            logger.info("createEmptyDocument: save done: " + this.file.toString());
        }
        catch (Exception e) {
            this.file = null;
            return false;
        }
        return true;
    }

    public byte[] storeToByteArray() {
        logger.info("storeToByteArray: editorRunning() " + this.editorRunning() + " file: " + this.file + " odt null " + (this.odt == null));
        if (this.file == null || this.odt == null || this.editorRunning()) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (stream == null) {
            return null;
        }
        try {
            this.odt.save((OutputStream)stream);
            logger.info("storeToByteArray: completed " + this.file.length() + " bytes");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return stream.toByteArray();
    }

    public boolean loadFromByteArray(byte[] bs, boolean asTemplate) {
        logger.info("loadFromByteArray: asTemplate " + asTemplate);
        ByteArrayInputStream stream = new ByteArrayInputStream(bs);
        return this.loadFromStream(stream, asTemplate);
    }

    public boolean loadFromStream(InputStream is, boolean asTemplate) {
        logger.info("loadFromStream: " + (this.file != null));
        if (!this.ensureClosed()) {
            return false;
        }
        if (this.file != null) {
            this.closeFile();
        }
        try {
            this.file = File.createTempFile(this.getTempPrefix(), ".odt");
            logger.info("loadFromStream: " + this.file.toString());
            this.file.deleteOnExit();
            this.odt = (OdfTextDocument)OdfDocument.loadDocument((InputStream)is);
            this.odt.save(this.file);
            this.fileValid();
            logger.info("loadFromStream: saved (but not yet converted) " + this.file.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("loadFromStream: loading document failed ");
            return false;
        }
        return true;
    }

    private Text replaceTabs(OdfFileDom dom, Text text) {
        int i;
        Node parent = text.getParentNode();
        Text cur = text;
        while ((i = cur.getTextContent().indexOf(9)) >= 0) {
            Text next = cur.splitText(i);
            next.setTextContent(next.getTextContent().substring(1));
            OdfTextTab tab = (OdfTextTab)OdfXMLFactory.newOdfElement((OdfFileDom)dom, (OdfName)OdfTextTab.ELEMENT_NAME);
            parent.insertBefore((Node)tab, next);
            cur = next;
        }
        return cur;
    }

    private Text formatText(OdfFileDom dom, Text text) throws Exception {
        int i;
        Node parent = text.getParentNode();
        Text cur = text;
        String textContent = text.getTextContent();
        if (textContent.startsWith("_") && textContent.endsWith("_")) {
            text.setTextContent(textContent.substring(1, textContent.length() - 1));
            if (parent instanceof OdfStylableElement) {
                OdfStylableElement stel = (OdfStylableElement)parent;
                OdfFileDom contentDom = this.odt.getContentDom();
                OdfStyle newst = this.createNewStyle("ul_", contentDom, this.odt.getStylesDom());
                newst.setStyleFamilyAttribute("paragraph");
                OdfStyleTextProperties stp = (OdfStyleTextProperties)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)StyleTextPropertiesElement.ELEMENT_NAME);
                stp.setStyleTextUnderlineStyleAttribute("solid");
                stp.setStyleTextUnderlineWidthAttribute("auto");
                stp.setStyleTextUnderlineColorAttribute("font-color");
                newst.appendChild((Node)stp);
                String oldst = stel.getStyleName();
                if (oldst != null && !oldst.isEmpty()) {
                    newst.setStyleParentStyleNameAttribute(oldst);
                }
                stel.setStyleName(newst.getStyleNameAttribute());
            }
        }
        while ((i = cur.getTextContent().indexOf(10)) >= 0) {
            Text next = cur.splitText(i);
            next.setTextContent(next.getTextContent().substring(1));
            OdfTextLineBreak lbrk = (OdfTextLineBreak)OdfXMLFactory.newOdfElement((OdfFileDom)dom, (OdfName)OdfTextLineBreak.ELEMENT_NAME);
            parent.insertBefore((Node)lbrk, next);
            this.replaceTabs(dom, cur);
            cur = next;
        }
        return this.replaceTabs(dom, cur);
    }

    private boolean searchNode(Node n, Pattern pat, List<Text> matches, boolean onlyFirst) {
        boolean result = false;
        Node child = n.getFirstChild();
        while (child != null) {
            Text bit;
            String content;
            Matcher m;
            if (child instanceof Text && (m = pat.matcher(content = (bit = (Text)child).getTextContent())).find()) {
                int start = m.start();
                int end = m.end();
                if (start != 0) {
                    bit = bit.splitText(start);
                    end -= start;
                }
                if (end != bit.getTextContent().length()) {
                    bit.splitText(end);
                }
                result = true;
                matches.add(bit);
                child = bit;
                if (onlyFirst) {
                    return true;
                }
            }
            child = child.getNextSibling();
        }
        return result;
    }

    private List<Text> findTextNode(OdfFileDom dom, XPath xpath, Pattern pat, boolean onlyFirst) throws Exception {
        String[] types;
        ArrayList<Text> result = new ArrayList<Text>();
        String[] stringArray = types = new String[]{"//text:p", "//text:span"};
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            NodeList bits = (NodeList)xpath.evaluate(t, dom, XPathConstants.NODESET);
            int i = 0;
            while (i < bits.getLength()) {
                Node n3 = bits.item(i);
                if (this.searchNode(n3, pat, result, onlyFirst) && onlyFirst) {
                    return result;
                }
                ++i;
            }
            ++n2;
        }
        return result;
    }

    private void makeTableAt(OdfFileDom dom, Text match, String[][] content, int[] widths) throws Exception {
        Node tableParent = match.getParentNode();
        while (tableParent instanceof TextSpanElement) {
            tableParent = tableParent.getParentNode();
        }
        Node before = tableParent;
        tableParent = tableParent.getParentNode();
        TableTableElement table = (TableTableElement)OdfXMLFactory.newOdfElement((OdfFileDom)dom, (OdfName)TableTableElement.ELEMENT_NAME);
        tableParent.insertBefore((Node)table, before);
        before.getParentNode().removeChild(before);
        if (content.length == 0) {
            return;
        }
        int colcount = 0;
        String[][] stringArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            String[] row = stringArray[n2];
            colcount = Math.max(colcount, row.length);
            ++n2;
        }
        if (widths == null) {
            TableTableColumnElement ttc = (TableTableColumnElement)OdfXMLFactory.newOdfElement((OdfFileDom)dom, (OdfName)TableTableColumnElement.ELEMENT_NAME);
            ttc.setTableNumberColumnsRepeatedAttribute(Integer.valueOf(colcount));
            table.appendChild((Node)ttc);
        } else {
            float percentval = 655.35f;
            int i = 0;
            while (i < widths.length) {
                OdfStyle cst = this.createNewStyle("col", this.odt.getContentDom(), this.odt.getStylesDom());
                String stname = cst.getStyleNameAttribute();
                cst.setStyleFamilyAttribute("table-column");
                OdfStyleTableColumnProperties stcp = (OdfStyleTableColumnProperties)OdfXMLFactory.newOdfElement((OdfFileDom)dom, (OdfName)StyleTableColumnPropertiesElement.ELEMENT_NAME);
                stcp.setStyleRelColumnWidthAttribute(Integer.toString((int)((float)widths[i] * percentval)));
                cst.appendChild((Node)stcp);
                TableTableColumnElement ttc = (TableTableColumnElement)OdfXMLFactory.newOdfElement((OdfFileDom)dom, (OdfName)TableTableColumnElement.ELEMENT_NAME);
                ttc.setStyleName(stname);
                table.appendChild((Node)ttc);
                ++i;
            }
        }
        stringArray = content;
        n = content.length;
        n2 = 0;
        while (n2 < n) {
            String[] row = stringArray[n2];
            TableTableRowElement ttre = table.newTableTableRowElement();
            table.appendChild((Node)ttre);
            int i = 0;
            while (i < row.length) {
                boolean last;
                String col = row[i];
                boolean bl = last = i == row.length - 1;
                if (col == null) {
                    col = "";
                }
                TableTableCellElement ttce = ttre.newTableTableCellElement();
                ttce.setOfficeValueTypeAttribute("string");
                ttre.appendChild((Node)ttce);
                if (last && row.length < colcount) {
                    ttce.setTableNumberColumnsSpannedAttribute(Integer.valueOf(colcount - i));
                }
                TextPElement tp = (TextPElement)OdfXMLFactory.newOdfElement((OdfFileDom)dom, (OdfName)TextPElement.ELEMENT_NAME);
                tp.setStyleName(this.curStyle + "_pg");
                tp.setTextContent(col);
                ttce.appendChild((Node)tp);
                Text t = (Text)tp.getFirstChild();
                if (t != null) {
                    this.formatText(dom, t);
                }
                ++i;
            }
            ++n2;
        }
    }

    private void fillTableAt(OdfFileDom dom, Text match, String[][] content) throws Exception {
        Node cellNode = match.getParentNode();
        int cellIndex = 0;
        while (!(cellNode instanceof TableTableCellElement)) {
            cellNode = cellNode.getParentNode();
        }
        TableTableCellElement cell = (TableTableCellElement)cellNode;
        TableTableRowElement row = (TableTableRowElement)cell.getParentNode();
        Node parent = row.getParentNode();
        NodeList cellList = row.getChildNodes();
        int i = 0;
        while (i < cellList.getLength()) {
            Node n = cellList.item(i);
            if (n instanceof TableTableCellElement) {
                if (n == cell) break;
                ++cellIndex;
            }
            ++i;
        }
        String[][] stringArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            String[] rData = stringArray[n2];
            if (rData != null) {
                TableTableRowElement r = (TableTableRowElement)row.cloneNode(true);
                int i2 = 0;
                NodeList nl = r.getChildNodes();
                int j = 0;
                while (j < nl.getLength()) {
                    Node n3 = nl.item(j);
                    if (n3 instanceof TableTableCellElement) {
                        TableTableCellElement c = (TableTableCellElement)n3;
                        if (i2 >= cellIndex && i2 - cellIndex + 1 <= rData.length) {
                            TextPElement pe = (TextPElement)c.getChildNodes().item(0);
                            pe.setTextContent(StringTool.unNull((String)rData[i2 - cellIndex]));
                            Text t = (Text)pe.getFirstChild();
                            if (t != null) {
                                this.formatText(dom, t);
                            }
                        }
                        ++i2;
                    }
                    ++j;
                }
                parent.insertBefore((Node)r, (Node)row);
            }
            ++n2;
        }
        parent.removeChild((Node)row);
    }

    private void replaceTableFills(OdfFileDom dom, XPath xpath, Pattern pat, boolean onlyFirst, ReplaceCallback cb) throws Exception {
        String spat = pat.pattern();
        spat = spat.replaceAll("\\\\\\[", "\\\\{");
        spat = spat.replaceAll("\\\\\\]", "\\\\}");
        Pattern npat = Pattern.compile(spat);
        List<Text> matches = this.findTextNode(dom, xpath, npat, onlyFirst);
        for (Text match : matches) {
            String text = match.getTextContent().replaceAll("\\{", "[").replaceAll("\\}", "]");
            Object replacement = cb.replace(text);
            if (!(replacement instanceof String[][])) continue;
            try {
                this.fillTableAt(dom, match, (String[][])replacement);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private int findOrReplaceIn(OdfFileDom dom, Pattern pat, ReplaceCallback cb, XPath xpath) throws Exception {
        this.replaceTableFills(dom, xpath, pat, false, cb);
        List<Text> matches = this.findTextNode(dom, xpath, pat, false);
        for (Text match : matches) {
            String replstr;
            String text = match.getTextContent();
            Object replacement = cb.replace(text);
            if (replacement == null) continue;
            if (replacement instanceof String) {
                replstr = (String)replacement;
                if (replstr.compareTo(text) == 0) continue;
                match.setTextContent(replstr);
                this.formatText(dom, match);
                continue;
            }
            if (replacement instanceof String[][]) {
                try {
                    this.makeTableAt(dom, match, (String[][])replacement, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            replstr = "???Unbekannter Typ???";
            if (replstr.compareTo(text) == 0) continue;
            match.setTextContent(replstr);
        }
        return matches.size();
    }

    public boolean findOrReplace(String pattern, ReplaceCallback cb) {
        if (this.editorRunning() || this.file == null) {
            return false;
        }
        int count = 0;
        try {
            Pattern pat = Pattern.compile(pattern);
            OdfFileDom contentDom = this.odt.getContentDom();
            OdfFileDom styleDom = this.odt.getStylesDom();
            XPath xpath = this.odt.getXPath();
            count += this.findOrReplaceIn(contentDom, pat, cb, xpath);
            count += this.findOrReplaceIn(styleDom, pat, cb, xpath);
            this.odtSync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count > 0;
    }

    public boolean insertTable(String place, int properties, String[][] contents, int[] columnSizes) {
        List<Text> texts;
        OdfFileDom contentDom;
        block4: {
            if (!this.ensureClosed() || this.file == null) {
                return false;
            }
            try {
                contentDom = this.odt.getContentDom();
                XPath xpath = this.odt.getXPath();
                texts = this.findTextNode(contentDom, xpath, Pattern.compile(Pattern.quote(place)), true);
                if (texts.size() != 0) break block4;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        Text txt = texts.get(0);
        this.makeTableAt(contentDom, txt, contents, columnSizes);
        this.odtSync();
        return true;
    }

    public Object insertText(String marke, String text, int adjust) {
        List<Text> texts;
        OdfFileDom contentDom;
        block4: {
            if (!this.ensureClosed() || this.file == null) {
                return null;
            }
            try {
                contentDom = this.odt.getContentDom();
                XPath xpath = this.odt.getXPath();
                texts = this.findTextNode(contentDom, xpath, Pattern.compile(Pattern.quote(marke)), true);
                if (texts.size() != 0) break block4;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Text txt = texts.get(0);
        txt.setTextContent(text);
        txt = this.formatText(contentDom, txt);
        this.odtSync();
        return txt;
    }

    public Object insertText(Object pos, String text, int adjust) {
        if (!this.ensureClosed() || this.file == null || pos == null) {
            return null;
        }
        try {
            OdfFileDom contentDom = this.odt.getContentDom();
            Text prev = (Text)pos;
            this.curStyle.setAlign(adjust);
            TextSpanElement span = (TextSpanElement)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)TextSpanElement.ELEMENT_NAME);
            span.setTextContent(text);
            span.setStyleName(this.curStyle.getTextLbl());
            Text txt = prev;
            int i = 0;
            while (i < span.getChildNodes().getLength()) {
                Node n = span.getChildNodes().item(i);
                if (n instanceof Text) {
                    txt = (Text)n;
                    this.formatText(contentDom, txt);
                }
                ++i;
            }
            prev.getParentNode().insertBefore((Node)span, prev.getNextSibling());
            this.curStyle.clearAlign();
            return txt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String generateStyleName(String prefix, OdfFileDom contentDom, OdfFileDom styleDom, XPath xpath) {
        int i = 0;
        while (true) {
            String cur = String.valueOf(prefix) + i;
            String xp = "//*[@style:name='" + cur + "']";
            try {
                NodeList nl = (NodeList)xpath.evaluate(xp, contentDom, XPathConstants.NODESET);
                if (nl.getLength() <= 0 && (nl = (NodeList)xpath.evaluate(xp, styleDom, XPathConstants.NODESET)).getLength() <= 0) {
                    return cur;
                }
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private OdfStyle createNewStyle(String prefix, OdfFileDom contentDom, OdfFileDom styleDom) throws Exception {
        XPath xpath = this.odt.getXPath();
        String name = this.generateStyleName(prefix, contentDom, styleDom, xpath);
        OdfOfficeAutomaticStyles autost = (OdfOfficeAutomaticStyles)xpath.evaluate("//office:automatic-styles", contentDom, XPathConstants.NODE);
        OdfStyle style = (OdfStyle)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)StyleStyleElement.ELEMENT_NAME);
        style.setStyleNameAttribute(name);
        autost.appendChild((Node)style);
        return style;
    }

    public Object insertTextAt(int x, int y, int w, int h, String text, int adjust) {
        if (!this.ensureClosed() || this.file == null) {
            return null;
        }
        try {
            OdfFileDom contentDom = this.odt.getContentDom();
            OdfFileDom styleDom = this.odt.getStylesDom();
            XPath xpath = this.odt.getXPath();
            this.curStyle.setAlign(adjust);
            OdfStyle frst = this.createNewStyle("fr", contentDom, styleDom);
            String frstyle = frst.getStyleNameAttribute();
            frst.setStyleFamilyAttribute("graphic");
            frst.setStyleParentStyleNameAttribute("Frame");
            OdfStyleGraphicProperties gsp = (OdfStyleGraphicProperties)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)StyleGraphicPropertiesElement.ELEMENT_NAME);
            gsp.setStyleRunThroughAttribute("foreground");
            gsp.setStyleWrapAttribute("dynamic");
            gsp.setStyleNumberWrappedParagraphsAttribute("no-limit");
            gsp.setStyleVerticalPosAttribute("from-top");
            gsp.setStyleVerticalRelAttribute("page-content");
            gsp.setStyleHorizontalPosAttribute("from-left");
            gsp.setStyleHorizontalRelAttribute("page-content");
            gsp.setStyleBackgroundTransparencyAttribute("100%");
            gsp.setStyleShadowAttribute("none");
            gsp.setFoBackgroundColorAttribute("#ffffff");
            gsp.setFoPaddingAttribute("0cm");
            gsp.setFoBorderAttribute("none");
            frst.appendChild((Node)gsp);
            OdfStyleBackgroundImage bgimg = (OdfStyleBackgroundImage)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)StyleBackgroundImageElement.ELEMENT_NAME);
            gsp.appendChild((Node)bgimg);
            OdfStyleColumns scols = (OdfStyleColumns)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)StyleColumnsElement.ELEMENT_NAME);
            scols.setFoColumnCountAttribute(Integer.valueOf(1));
            scols.setFoColumnGapAttribute("0cm");
            gsp.appendChild((Node)scols);
            OdfOfficeText officeText = (OdfOfficeText)xpath.evaluate("//office:text", contentDom, XPathConstants.NODE);
            OdfDrawFrame frame = (OdfDrawFrame)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)DrawFrameElement.ELEMENT_NAME);
            frame.setSvgXAttribute(String.valueOf(x) + "mm");
            frame.setSvgYAttribute(String.valueOf(y) + "mm");
            frame.setSvgWidthAttribute(String.valueOf(w) + "mm");
            frame.setSvgHeightAttribute(String.valueOf(h + 1) + "mm");
            frame.setTextAnchorTypeAttribute("page");
            frame.setTextAnchorPageNumberAttribute(Integer.valueOf(1));
            frame.setDrawZIndexAttribute(Integer.valueOf(0));
            frame.setDrawStyleNameAttribute(frstyle);
            frame.setDrawNameAttribute("Frame" + frstyle);
            officeText.insertBefore((Node)frame, officeText.getFirstChild());
            OdfDrawTextBox textbox = (OdfDrawTextBox)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)DrawTextBoxElement.ELEMENT_NAME);
            frame.appendChild((Node)textbox);
            OdfTextParagraph para = (OdfTextParagraph)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)TextPElement.ELEMENT_NAME);
            para.setTextContent(text);
            para.setStyleName(this.curStyle.getParagraphLbl());
            textbox.appendChild((Node)para);
            Text txt = (Text)para.getChildNodes().item(0);
            this.formatText(contentDom, txt);
            this.curStyle.clearAlign();
            this.odtSync();
            return txt;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ITextPlugin.PageFormat getFormat() {
        return null;
    }

    public String getMimeType() {
        return "application/vnd.oasis.opendocument.text";
    }

    public void setFocus() {
    }

    public boolean setFont(String name, int style, float size) {
        if (!this.ensureClosed() || this.file == null) {
            return false;
        }
        this.curStyle.setFont(name, style, size);
        return true;
    }

    public void setFormat(ITextPlugin.PageFormat f) {
    }

    public void setSaveOnFocusLost(boolean bSave) {
    }

    public boolean setStyle(int style) {
        this.curStyle.setStyle(style);
        return true;
    }

    public void showMenu(boolean b) {
    }

    public void showToolbar(boolean b) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public boolean isDirectOutput() {
        return false;
    }

    public void setParameter(ITextPlugin.Parameter parameter) {
    }

    public void initTemplatePrintSettings(String template) {
    }

    private class Style {
        static final int ALIGN = 16924672;
        String font = null;
        public int flags;
        Float size = null;

        private Style() {
        }

        public void setStyle(int s) {
            this.flags = s;
        }

        public void clearAlign() {
            this.flags &= 0xFEFDBFFF;
        }

        public void setAlign(int a) {
            this.clearAlign();
            this.flags |= a;
        }

        public void setFont(String n, int f, float s) {
            this.font = n;
            this.flags = f;
            this.size = Float.valueOf(s);
        }

        private String label() {
            try {
                String pass = "" + this.flags;
                if (this.font != null) {
                    pass = String.valueOf(pass) + "_" + this.font;
                }
                if (this.size != null) {
                    pass = String.valueOf(pass) + "_" + this.size;
                }
                MessageDigest m = MessageDigest.getInstance("MD5");
                byte[] data = pass.getBytes();
                m.update(data, 0, data.length);
                BigInteger i = new BigInteger(1, m.digest());
                return String.format("%1$032X", i);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                return null;
            }
        }

        private void declareFont(String name) throws Exception {
            OdfFileDom contentDom = TextPlugin.this.odt.getContentDom();
            XPath xpath = TextPlugin.this.odt.getXPath();
            OdfOfficeFontFaceDecls ffdec = (OdfOfficeFontFaceDecls)xpath.evaluate("//office:font-face-decls", contentDom, XPathConstants.NODE);
            OdfStyleFontFace fface = (OdfStyleFontFace)ffdec.getFirstChild();
            NodeList nl = (NodeList)xpath.evaluate("//office:font-face-decls/style:font-face[@style:name='" + this.font + "']", contentDom, XPathConstants.NODESET);
            if (nl.getLength() == 0) {
                fface = (OdfStyleFontFace)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)StyleFontFaceElement.ELEMENT_NAME);
                fface.setStyleNameAttribute(this.font);
                fface.setSvgFontFamilyAttribute("'" + this.font + "'");
                ffdec.appendChild((Node)fface);
            }
        }

        private void createStyle(String sname, String family) {
            try {
                OdfFileDom contentDom = TextPlugin.this.odt.getContentDom();
                XPath xpath = TextPlugin.this.odt.getXPath();
                NodeList nl = (NodeList)xpath.evaluate("//style:style[@style:name='" + sname + "']", contentDom, XPathConstants.NODESET);
                if (nl.getLength() == 0) {
                    OdfOfficeAutomaticStyles autost = (OdfOfficeAutomaticStyles)xpath.evaluate("//office:automatic-styles", contentDom, XPathConstants.NODE);
                    OdfStyle frst = (OdfStyle)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)StyleStyleElement.ELEMENT_NAME);
                    frst.setStyleNameAttribute(sname);
                    frst.setStyleFamilyAttribute(family);
                    frst.setStyleParentStyleNameAttribute("Standard");
                    autost.appendChild((Node)frst);
                    OdfStyleTextProperties stp = (OdfStyleTextProperties)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)StyleTextPropertiesElement.ELEMENT_NAME);
                    if (this.font != null) {
                        this.declareFont(this.font);
                        stp.setStyleFontNameAttribute(this.font);
                    }
                    if (this.size != null) {
                        stp.setFoFontSizeAttribute(this.size + "pt");
                        stp.setStyleFontSizeAsianAttribute(this.size + "pt");
                        stp.setStyleFontSizeComplexAttribute(this.size + "pt");
                    }
                    if ((this.flags & 1) != 0) {
                        stp.setFoFontWeightAttribute("bold");
                    }
                    if ((this.flags & 2) != 0) {
                        stp.setFoFontStyleAttribute("italic");
                    }
                    if ((this.flags & 0x1024000) != 0 && family.compareTo("paragraph") == 0) {
                        OdfStyleParagraphProperties pp = (OdfStyleParagraphProperties)OdfXMLFactory.newOdfElement((OdfFileDom)contentDom, (OdfName)StyleParagraphPropertiesElement.ELEMENT_NAME);
                        if ((this.flags & 0x4000) != 0) {
                            pp.setFoTextAlignAttribute("left");
                        } else if ((this.flags & 0x20000) != 0) {
                            pp.setFoTextAlignAttribute("right");
                        } else if ((this.flags & 0x1000000) != 0) {
                            pp.setFoTextAlignAttribute("center");
                        }
                        frst.appendChild((Node)pp);
                    }
                    frst.appendChild((Node)stp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String getParagraphLbl() {
            String lbl = String.valueOf(this.label()) + "_pg";
            this.createStyle(lbl, "paragraph");
            return lbl;
        }

        public String getTextLbl() {
            String lbl = String.valueOf(this.label()) + "_txt";
            this.createStyle(lbl, "text");
            return lbl;
        }
    }
}

