/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labor.viollier.v2.labimport;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.importer.div.importers.LabImportUtil;
import ch.elexis.core.ui.text.GenericDocument;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.labor.viollier.v2.Messages;
import ch.elexis.labor.viollier.v2.data.ViollierLaborImportSettings;
import ch.elexis.laborimport.viollier.v2.util.ViollierLogger;
import ch.rgw.io.FileTool;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class PatientLabor {
    public static String LABOR_NAME = Messages.PatientLabor_nameViollierLabor;
    public static String DEFAULT_PRIO = "50";
    public static String FORMAT_DATE = "yyyyMMdd";
    public static String FORMAT_TIME = "HHmmss";
    private static String KUERZEL = Messages.PatientLabor_kuerzelViollier;
    private static String FIELD_ORGIN = "Quelle";
    private static int MAX_LEN_RESULT = 80;
    private ViollierLaborImportSettings settings;
    private Labor myLab = null;
    private final Patient patient;
    private IDocumentManager docManager;
    private boolean overwriteResults = false;

    public PatientLabor(Patient patient) {
        this.patient = patient;
        this.myLab = LabImportUtil.getOrCreateLabor((String)KUERZEL);
        this.initDocumentManager();
    }

    private void initDocumentManager() {
        this.settings = new ViollierLaborImportSettings(CoreHub.actMandant);
        Object os = Extensions.findBestService((String)"DocumentManagement");
        if (os != null) {
            this.docManager = (IDocumentManager)os;
        }
    }

    private void checkCreateCategory(String category) {
        if (category != null) {
            boolean catExists = false;
            String[] categories = this.docManager.getCategories();
            if (categories != null) {
                String[] stringArray = categories;
                int n = categories.length;
                int n2 = 0;
                while (n2 < n) {
                    String cat = stringArray[n2];
                    if (category.equals(cat)) {
                        catExists = true;
                    }
                    ++n2;
                }
            }
            if (!catExists) {
                Boolean result = this.docManager.addCategorie(category);
                if (result.booleanValue()) {
                    ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_InfoCategoryCreate, category));
                } else {
                    ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_WarnCategoryCreate, category));
                }
            }
        }
    }

    private boolean addDocument(String title, String category, String dateStr, File file, String keywords) throws IOException, ElexisException {
        this.checkCreateCategory(category);
        List documentList = this.docManager.listDocuments(this.patient, category, title, null, new TimeSpan(String.valueOf(dateStr) + "-" + dateStr), null);
        if (documentList == null || documentList.size() == 0) {
            this.docManager.addDocument((IOpaqueDocument)new GenericDocument(this.patient, title, category, file, dateStr, keywords, FileTool.getExtension((String)file.getName())));
            return true;
        }
        return false;
    }

    private LabItem getLabItem(String kuerzel, String name, LabItemTyp type) {
        Query qli = new Query(LabItem.class);
        qli.add("kuerzel", "=", kuerzel);
        qli.and();
        qli.add("LaborID", "=", this.myLab.get("ID"));
        qli.and();
        qli.add("Typ", "=", new Integer(type.ordinal()).toString());
        LabItem labItem = null;
        List itemList = qli.execute();
        if (itemList.size() > 0) {
            labItem = (LabItem)itemList.get(0);
        } else {
            qli = new Query(LabItem.class);
            qli.add("kuerzel", "=", name);
            qli.and();
            qli.add("LaborID", "=", this.myLab.get("ID"));
            qli.and();
            qli.add("Typ", "=", new Integer(type.ordinal()).toString());
            labItem = null;
            itemList = qli.execute();
            if (itemList.size() > 0) {
                labItem = (LabItem)itemList.get(0);
            }
        }
        return labItem;
    }

    private LabResult getLabResult(LabItem labItem, String name, String date) {
        Query qli = new Query(LabResult.class);
        qli.add("ItemID", "=", labItem.getId());
        qli.and();
        qli.add("Datum", "=", date);
        qli.and();
        qli.add("PatientID", "=", this.patient.getId());
        qli.and();
        qli.add("Resultat", "=", name);
        LabResult labResult = null;
        List resultList = qli.execute();
        if (resultList.size() > 0) {
            labResult = (LabResult)resultList.get(0);
        }
        return labResult;
    }

    public void saveLaborItem(String title, String category, File file, Date timeStamp, String orderId, String keyword, String group, String sequence) throws IOException {
        String name;
        String kuerzel;
        LabItem labItem;
        String filename = file.getName();
        if (this.docManager == null) {
            throw new IOException(MessageFormat.format(Messages.PatientLabor_errorKeineDokumentablage, filename, this.patient.getLabel()));
        }
        this.checkCreateCategory(category);
        TimeTool dateTime = new TimeTool();
        dateTime.setTime(timeStamp);
        SimpleDateFormat sdfDatum = new SimpleDateFormat(FORMAT_DATE);
        SimpleDateFormat sdfZeit = new SimpleDateFormat(FORMAT_TIME);
        String datum = sdfDatum.format(timeStamp);
        String zeit = sdfZeit.format(timeStamp);
        if (title.length() > MAX_LEN_RESULT) {
            title = "..." + title.substring(title.length() - MAX_LEN_RESULT + 3, title.length());
        }
        if ((labItem = this.getLabItem(kuerzel = "doc", name = Messages.PatientLabor_DocumentLabItemName, LabItemTyp.DOCUMENT)) == null) {
            if (group == null || group.length() == 0) {
                group = LABOR_NAME;
            }
            if (sequence == null || sequence.length() == 0) {
                sequence = DEFAULT_PRIO;
            }
            labItem = new LabItem(kuerzel, Messages.PatientLabor_nameDokumentLaborParameter, (Kontakt)this.myLab, "", "", "pdf", LabItemTyp.DOCUMENT, group, sequence);
        }
        if (orderId == null || "".equals(orderId)) {
            orderId = LABOR_NAME;
        }
        boolean saved = false;
        LabResult lr = this.getLabResult(labItem, title, datum);
        if (lr == null) {
            lr = new LabResult(this.patient, dateTime, labItem, title, null);
            lr.set(FIELD_ORGIN, orderId);
            lr.set("Zeit", zeit);
            saved = true;
        } else if (this.overwriteResults || lr.getDateTime().getTimeInMillis() < dateTime.getTimeInMillis()) {
            ViollierLogger.getLogger().println(MessageFormat.format(Messages.PatientLabor_InfoOverwriteValue, String.valueOf(labItem.getKuerzel()) + "-" + labItem.getName(), lr.getDateTime().toDBString(true), dateTime.toDBString(true), lr.getResult(), title));
            lr.setResult(title);
            lr.set("Zeit", zeit);
            saved = true;
        } else {
            ViollierLogger.getLogger().println(MessageFormat.format(Messages.PatientLabor_InfoExistingValueIsValid, String.valueOf(labItem.getKuerzel()) + "-" + labItem.getName(), lr.getDateTime().toDBString(true), dateTime.toDBString(true), lr.getResult(), title));
        }
        if (saved) {
            try {
                String dateTimeStr = dateTime.toString(4);
                this.addDocument(title, category, dateTimeStr, file, keyword);
                ViollierLogger.getLogger().println(MessageFormat.format(Messages.PatientLabor_InfoDocSavedToOmnivore, title));
            }
            catch (ElexisException e) {
                throw new IOException(MessageFormat.format(Messages.PatientLabor_errorAddingDocument, filename), e);
            }
        }
    }

    public static enum SaveResult {
        SUCCESS,
        ERROR;

    }
}

