/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.bestellung.rose;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.exchange.IDataSender;
import ch.elexis.core.ui.exchange.XChangeException;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.BestellView;
import ch.elexis.data.Artikel;
import ch.elexis.data.Bestellung;
import ch.elexis.data.BestellungEntry;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Sender
implements IDataSender {
    private static final String XML_NEWLINE = "\r\n";
    private static final String ORDER_URL = "http://xml.estudio.zur-rose.hin.ch/orderXML/";
    private static final String ENCODING = "UTF-8";
    private static final String DEFAULT_ASAS_PROXY_HOST = "localhost";
    private static final String DEFAULT_ASAS_PROXY_PORT = "5016";
    protected Log log = Log.get((String)"iatrix-bestellung-rose");
    private final List<String> orderRequests = new ArrayList<String>();
    private int counter;

    public boolean canHandle(Class<? extends PersistentObject> clazz) {
        return clazz.equals(Bestellung.class);
    }

    public void finalizeExport() throws XChangeException {
        if (this.counter == 0) {
            this.log.log("Order contains no articles to order from Rose supplier", 4);
            return;
        }
        Properties systemSettings = System.getProperties();
        String oldProxyHost = systemSettings.getProperty("http.proxyHost");
        String oldProxyPort = systemSettings.getProperty("http.proxyPort");
        systemSettings.put("http.proxyHost", CoreHub.globalCfg.get("org.iatrix.bestellung.rose/asas_host", DEFAULT_ASAS_PROXY_HOST));
        systemSettings.put("http.proxyPort", CoreHub.globalCfg.get("org.iatrix.bestellung.rose/asas_port", DEFAULT_ASAS_PROXY_PORT));
        System.setProperties(systemSettings);
        try {
            for (String orderRequest : this.orderRequests) {
                System.out.println(orderRequest);
                try {
                    String line;
                    String postString = "order=" + URLEncoder.encode(orderRequest, ENCODING);
                    URL serverURL = new URL(ORDER_URL);
                    HttpURLConnection httpConnection = (HttpURLConnection)serverURL.openConnection();
                    httpConnection.setRequestMethod("POST");
                    HttpURLConnection.setFollowRedirects(true);
                    httpConnection.setDoInput(true);
                    httpConnection.setDoOutput(true);
                    httpConnection.setUseCaches(false);
                    PrintWriter out = new PrintWriter(httpConnection.getOutputStream());
                    out.println(postString);
                    out.close();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream()));
                    StringBuffer responseMessage = new StringBuffer();
                    while ((line = bufferedReader.readLine()) != null) {
                        responseMessage.append(line);
                    }
                    bufferedReader.close();
                    System.err.println("prescription response: " + responseMessage.toString());
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    SWTHelper.alert((String)"Fehler bei \u00dcbermittlung", (String)"Die Bestellung konnte nicht gesendet werden. Bitte \u00fcberpr\u00fcfen Sie den Zustand in eStudio.");
                    throw new XChangeException("Die Bestellung konnte nicht gesendet werden. Bitte \u00fcberpr\u00fcfen Sie den Zustand in eStudio.");
                }
            }
        }
        finally {
            if (oldProxyHost != null || oldProxyPort != null) {
                systemSettings = System.getProperties();
                if (oldProxyHost != null) {
                    systemSettings.put("http.proxyHost", oldProxyHost);
                }
                if (oldProxyPort != null) {
                    systemSettings.put("http.proxyPort", oldProxyPort);
                }
                System.setProperties(systemSettings);
            }
        }
    }

    public XChangeElement store(Object output) throws XChangeException {
        if (output instanceof Bestellung) {
            Bestellung order = (Bestellung)output;
            return this.addOrder(order);
        }
        throw new XChangeException("Can't handle object of class " + output.getClass().getName());
    }

    private String escapeXmlAttribute(String value) {
        String escaped = value;
        escaped = escaped.replaceAll("&", "&amp;");
        escaped = escaped.replaceAll("\"", "&qt;");
        escaped = escaped.replaceAll("<", "&lt;");
        escaped = escaped.replaceAll(">", "&gt;");
        return escaped;
    }

    private XChangeElement addOrder(Bestellung order) throws XChangeException {
        String selDialogTitle;
        this.counter = 0;
        if (order == null) {
            throw new XChangeException("Die Bestellung ist leer.");
        }
        List items = order.getEntries();
        if (items == null || items.size() == 0) {
            throw new XChangeException("Die Bestellung ist leer.");
        }
        String clientNrRose = CoreHub.globalCfg.get("org.iatrix.bestellung.rose/global_client_number", "").trim();
        if (StringTool.isNothing((Object)clientNrRose)) {
            throw new XChangeException("Kundennummer ist nicht konfiguriert. (Einstellungen/Datenaustausch/zur Rose (Bestellungen))");
        }
        String supplier = CoreHub.globalCfg.get("org.iatrix.bestellung.rose/supplier", null);
        Kontakt roseSupplier = BestellView.resolveDefaultSupplier((String)supplier, (String)(selDialogTitle = "Kein 'Zur Rose' Lieferant definiert"));
        if (roseSupplier == null || !roseSupplier.exists()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8 \"?>\r\n");
        sb.append("<order xmlns=\"http://estudio.clustertec.ch/schemas/order\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://estudio.clustertec.ch/schemas/order http://estudio.clustertec.ch/schemas/order/order.xsd\" clientNrRose=\"" + this.escapeXmlAttribute(clientNrRose) + "\"" + " user=\"elexis\" password=\"elexis\"" + " deliveryType=\"1\"" + ">" + XML_NEWLINE);
        for (BestellungEntry item : items) {
            String eanId;
            Artikel artikel = item.getArticle();
            Kontakt artSupplier = item.getProvider();
            if (!roseSupplier.equals((Object)artSupplier)) continue;
            String pharmacode = artikel.getPharmaCode();
            if (pharmacode != null && pharmacode.length() == 6) {
                pharmacode = "0" + pharmacode;
            }
            if (StringTool.isNothing((Object)(eanId = artikel.getExt("EAN")))) {
                eanId = artikel.getEAN();
            }
            String description = artikel.getName();
            int quantity = item.getCount();
            if (StringTool.isNothing((Object)pharmacode) || StringTool.isNothing((Object)eanId) || StringTool.isNothing((Object)description) || quantity < 1) {
                StringBuffer msg = new StringBuffer();
                msg.append("Der Artikel " + PersistentObject.checkNull((Object)description) + " (Pharma-Code " + PersistentObject.checkNull((Object)pharmacode) + ") ist nicht korrekt konfiguriert: ");
                if (StringTool.isNothing((Object)pharmacode)) {
                    msg.append("Ung\u00fcltiger Pharmacode. ");
                }
                if (StringTool.isNothing((Object)eanId)) {
                    msg.append("Ung\u00fcltiger EAN-Code. ");
                }
                if (quantity < 1) {
                    msg.append("Ung\u00fcltige Anzahl. ");
                }
                msg.append("Bitte korrigieren Sie diese Fehler.");
                SWTHelper.alert((String)"Fehlerhafter Artikel", (String)msg.toString());
                throw new XChangeException("Fehlerhafter Artikel: Pharamcode: " + pharmacode + ", EAN: " + eanId + ", Name: " + description + ", Anzahl: " + quantity);
            }
            sb.append("<product pharmacode=\"" + this.escapeXmlAttribute(pharmacode) + "\"" + " eanId=\"" + this.escapeXmlAttribute(eanId) + "\"" + " description=\"" + this.escapeXmlAttribute(description) + "\"" + " quantity=\"" + quantity + "\"" + " positionType=\"1\"" + "/>" + XML_NEWLINE);
            ++this.counter;
        }
        sb.append("</order>\r\n");
        this.orderRequests.add(sb.toString());
        return null;
    }
}

